<!doctype html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="theme-color" content="#000000">
    <title>Data Ijin/Sakit</title>
    <meta http-equiv="Cache-Control" content="no-cache" />
    <meta name="description" content="E-Presensi Geolocation">
    <meta name="keywords" content="" />
    <link rel="icon" type="image/png" href="<?php echo e(asset('assets/img/favicon.png')); ?>" sizes="32x32">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('assets/img/icon/192x192.png')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>">
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css"/>
    <link rel="manifest" href="__manifest.json">
</head>

<body>

    <!-- loader -->
    <div id="loader">
        <img src="<?php echo e(asset('assets/img/loading-icon.png')); ?>" alt="icon" class="loading-icon">
    </div>
    <!-- * loader -->

    <!-- App Header -->
    <div class="appHeader">
        <div class="left">
            <a href="/dashboard" class="headerButton goBack">
                <ion-icon name="chevron-back-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">Data Ijin/Sakit</div>
        <div class="right">
        </div>
    </div>
    <!-- * App Header -->

    <!-- App Capsule -->
    

    <div class="fab-button animate bottom-right dropdown" style="margin-bottom: 55px;">
        <a href="#" class="fab bg-primary" data-bs-toggle="dropdown">
            <ion-icon name="add-outline" role="img" class="md hydrated" aria-label="add-outline"></ion-icon>
        </a>
        <div class="dropdown-menu">
            <a href="/ijinabsen" class="dropdown-item bg-primary">
                <ion-icon name="document-text-outline" role="img" class="md hydrated" aria-label="image outline"></ion-icon>
                <p>Ijin</p>
            </a>
            <a href="/ijinsakit" class="dropdown-item bg-primary">
                <ion-icon name="medkit-outline" role="img" class="md hydrated" aria-label="videocam outline"></ion-icon>
                <p>Sakit</p>
            </a>
            <a href="/ijincuti" class="dropdown-item bg-primary">
                <ion-icon name="mail-unread-outline" role="img" class="md hydrated" aria-label="videocam outline"></ion-icon>
                <p>Cuti</p>
            </a>
        </div>
    </div>    

    <div id="appCapsule">
        <div class="section full mt-1">
            <div class="col">
                <?php
                $messagesuccess = Session::get('success');
                $messageerror = Session::get('error');
                ?>
                <?php if(Session::get('success')): ?>
                <div class="alert alert-info alert-dismissible fade show mb-1" role="alert" id="timer-alert">
                    <?php echo e($messagesuccess); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php endif; ?>
                <?php if(Session::get('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show mb-1" role="alert" id="timer-alert">
                    <?php echo e($messageerror); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php endif; ?>
                
                <div class="card mb-1">
                    <div class="card-body">
                        <form action="/ijin" method="get">
                            <div class="row">
                            
                                <div class="col-6">
                                    <div class="form-group basic">
                                        <div class="input-wrapper">
                                            <select class="form-control custom-select" name="bulan" id="bulan">
                                            <option value="">Bulan</option>
                                                <?php for($i = 1; $i <= 12; $i++): ?>
                                                <option <?php echo e(Request('bulan') == $i ? 'selected' : ''); ?> value="<?php echo e($i); ?>"><?php echo e($namabulan[$i]); ?></option>
                                                <?php endfor; ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-3">
                                    <div class="form-group basic">
                                        <div class="input-wrapper">
                                            <select class="form-control custom-select" name="tahun" id="tahun">
                                            <option value="">Tahun</option>
                                                <?php
                                                    $tahun_awal = 2022;
                                                    $tahun_sekarang = date("Y");
                                                    for($t = $tahun_awal; $t <= $tahun_sekarang; $t++){ 
                                                        if (Request('tahun')==$t) {
                                                            $selected = 'selected';
                                                        } else {
                                                            $selected = '';
                                                        }
                                                        
                                                        echo "<option $selected value='$t'>$t</option>" ; }
                                                ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-3" style="display: inline-flex; justify-content: center; align-items: center;">
                                    <button type="submit" class="btn btn-icon btn-primary">
                                        <ion-icon name="search-outline"></ion-icon>
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <style>
                    .historicontent {
                        display: flex;
                    }
                    .datapresensi {
                        margin-left: 10px;
                    }
                    .status {
                        position: absolute;
                        right: 20px;
                    }
                </style>
                <?php $__currentLoopData = $dataijin; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="card mb-1">
                    <div class="card-body">
                        <div class="historicontent">
                            <div class="iconpresensi">
                                <?php if($d->status == "i"): ?>
                                <ion-icon name="document-text-outline" style="font-size: 48px;" class="text-info"></ion-icon>
                                <?php elseif($d->status == "s"): ?>
                                <ion-icon name="medkit-outline" style="font-size: 48px;" class="text-danger"></ion-icon>
                                <?php elseif($d->status == "c"): ?>
                                <ion-icon name="calendar-outline" style="font-size: 48px;" class="text-warning"></ion-icon>
                                <?php endif; ?>
                            </div>
                            <div class="datapresensi">
                                <h3 style="margin-bottom: 0px;"><?php echo e(date("d-m-Y",strtotime($d->tgl_ijin_dari))); ?> (<?php echo e($d->status == "s" ? "Sakit" : ($d->status == "i" ? "Ijin" : "Cuti")); ?>)</h3>
                                <small><?php echo e(date("d-m-Y",strtotime($d->tgl_ijin_dari))); ?> s/d <?php echo e(date("d-m-Y",strtotime($d->tgl_ijin_sampai))); ?></small>
                                <p style="margin-bottom: 6px; line-height: 0px;">Ket: <?php echo e($d->unik_ijin); ?></p>
                                <?php if($d->status == "c"): ?>
                                    <span class="badge badge-danger" style="height: 16px; font-size: 10px;"><?php echo e($d->nama_cuti); ?></span>
                                    <br>
                                <?php endif; ?>
                                <?php if(empty($d->file_surat)): ?>
                                    <span class="badge badge-danger" style="height: 16px; font-size: 10px;">Tidak Ada Surat</span>
                                <?php else: ?>
                                    <a class="btn btn-info" style="height: 16px; font-size: 10px;" data-bs-toggle="modal" data-bs-target="#FileSurat<?php echo e($d->unik_ijin); ?>">
                                        <ion-icon name="eye" style="font-size: 10px;"></ion-icon> Lihat Surat</a>
                                <?php endif; ?>
                            </div>
                            <div class="status">
                                <?php if($d->status_approved == 0): ?>
                                    <span class="badge badge-warning">Pending</span>
                                    <?php elseif($d->status_approved == 1): ?>
                                    <span class="badge badge-info">Disetujui</span>
                                    <?php elseif($d->status_approved == 2): ?>
                                    <span class="badge badge-danger">Ditolak</span>
                                <?php endif; ?>
                                <br>
                                <span><?php echo e(hitunghari($d->tgl_ijin_dari,$d->tgl_ijin_sampai)); ?> Hari</span>
                                <br>
                                <?php if($d->status_approved == 0): ?>
                                <div class="d-flex">
                                    <div>
                                    <?php if($d->status == "i"): ?>
                                        <a href="/ijinabsen/<?php echo e($d->unik_ijin); ?>/edit" class="btn btn-icon btn-info btn-sm edit" style="width: 24px; height: 24px; margin-right: 4px; border-top-right-radius: 10px; border-bottom-right-radius: 10px;">
                                            <ion-icon name="create" style="font-size: 16px;"></ion-icon>
                                        </a>
                                        <?php elseif($d->status == "s"): ?>
                                        <a href="/ijinsakit/<?php echo e($d->unik_ijin); ?>/edit" class="btn btn-icon btn-info btn-sm edit" style="width: 24px; height: 24px; margin-right: 4px; border-top-right-radius: 10px; border-bottom-right-radius: 10px;">
                                            <ion-icon name="create" style="font-size: 16px;"></ion-icon>
                                        </a>
                                        <?php elseif($d->status == "c"): ?>
                                        <a href="/ijincuti/<?php echo e($d->unik_ijin); ?>/edit" class="btn btn-icon btn-info btn-sm edit" style="width: 24px; height: 24px; margin-right: 4px; border-top-right-radius: 10px; border-bottom-right-radius: 10px;">
                                            <ion-icon name="create" style="font-size: 16px;"></ion-icon>
                                        </a>
                                    <?php endif; ?>
                                    </div>
                                    <div>
                                    <form action="/ijin/<?php echo e($d->unik_ijin); ?>/deleteijin" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <a class="btn btn-icon btn-danger btn-sm delete-confirm" style="width: 24px; height: 24px;"><ion-icon name="trash" style="font-size: 16px;"></ion-icon></a>
                                    </form>
                                    </div>
                                </div>
                                <?php endif; ?>
                            </div>
                            <?php
                                $path = Storage::url('uploads/file_ijin/'.$d->file_surat);
                            ?>
                            <div class="modal fade dialogbox" id="FileSurat<?php echo e($d->unik_ijin); ?>" data-bs-backdrop="static" tabindex="-1" role="dialog">
                                <div class="modal-dialog" role="document">
                                    <div class="modal-content">
                                        <div class="text-center mt-2">
                                            <span style="color: black;">File Surat</span>
                                            <a href="#" class="btn" data-bs-dismiss="modal" style="float: right;">X</a>
                                        </div>
                                        <div class="pt-3 text-center mb-2">
                                            <img src="<?php echo e(url($path)); ?>" alt="image" class="imaged" style="width: 100%">
                                        </div>
                                        <div class="modal-footer">
                                            <div class="btn-inline">
                                                <a href="#" class="btn" data-bs-dismiss="modal">OK</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
    <div class="modal fade action-sheet" id="actionSheetIconed" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Aksi</h5>
                </div>
                <div class="modal-body" id="showact">
     
                </div>
            </div>
        </div>
    </div>
    <!-- * App Capsule -->

    <!-- App Bottom Menu -->
    <div class="appBottomMenu">
        <a href="/dashboard" class="item">
            <div class="col">
                <ion-icon name="file-tray-full-outline"></ion-icon>
                <strong>Home</strong>
            </div>
        </a>
        <a href="/histori" class="item">
            <div class="col">
                <ion-icon name="list-circle-outline"></ion-icon>
                <strong>Riwayat</strong>
            </div>
        </a>
        <a href="/presensi/create" class="item">
            <div class="col">
                <div class="action-button large">
                    <ion-icon name="finger-print"></ion-icon>
                </div>
            </div>
        </a>
        <a href="/ijin" class="item active">
            <div class="col">
                <ion-icon name="document-text-outline"></ion-icon>
                <strong>Ijin</strong>
            </div>
        </a>
        <a href="/profile" class="item">
            <div class="col">
                <ion-icon name="person-outline"></ion-icon>
                <strong>Profil</strong>
            </div>
        </a>
    </div>
    <!-- * App Bottom Menu -->



    <!-- ========= JS Files =========  -->
    <!-- Jquery -->
    <script src="<?php echo e(asset('assets/js/lib/jquery-3.4.1.min.js')); ?>"></script>
    <!-- Bootstrap -->
    <script src="<?php echo e(asset('assets/js/lib/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/lib/popper.min.js')); ?>"></script>
    <!-- Ionicons -->
    <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>
    <!-- Webcam -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/webcamjs/1.0.26/webcam.min.js"></script>
    <!-- Maps -->
    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
    <!-- Splide -->
    <script src="<?php echo e(asset('assets/js/plugins/splide/splide.min.js')); ?>"></script>
    <!-- Owl Carousel -->
    <script src="<?php echo e(asset('assets/js/plugins/owl-carousel/owl.carousel.min.js')); ?>"></script>
    <!-- jQuery Circle Progress -->
    <script src="<?php echo e(asset('assets/js/plugins/jquery-circle-progress/circle-progress.min.js')); ?>"></script>
    <script src="https://cdn.amcharts.com/lib/4/core.js"></script>
    <script src="https://cdn.amcharts.com/lib/4/charts.js"></script>
    <script src="https://cdn.amcharts.com/lib/4/themes/animated.js"></script>
    <!-- SweetAlert -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <!-- Base Js File -->
    <script src="<?php echo e(asset('assets/js/base.js')); ?>"></script>

    <script>
        $(function(){
            $(".card_ijin").click(function(e) {
                var unik_ijin = $(this).attr("unik_ijin");
                $("#showact").load('/ijin/' + unik_ijin + '/showact');
            });

            $(".delete-confirm").click(function(e) {
                var form = $(this).closest('form');
                e.preventDefault();
                Swal.fire({
                    title: 'Anda Yakin?',
                    text: "Data Ijin Ini Akan Di Hapus",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#6658dd',
                    cancelButtonColor: '#f1556c',
                    cancelButtonText: 'Batal',
                    confirmButtonText: 'Ya, Hapus'
                    }).then((result) => {
                    if (result.isConfirmed) {
                        form.submit();
                    }
                    });
                    return false;
            });

            $("#timer-alert").fadeTo(5000, 500).slideUp(500, function(){
              $("#timer-alert").slideUp(500);
          });
        });
    </script>

</body>

</html><?php /**PATH D:\BELAJAR\#KUMPULAN SOURCE CODE\PRESENSI GPS LARAVEL\presensigps\resources\views/presensi/ijin.blade.php ENDPATH**/ ?>