<!doctype html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="theme-color" content="#000000">
    <title>Presensi</title>
    <meta http-equiv="Cache-Control" content="no-cache" />
    <meta name="description" content="E-Presensi Geolocation">
    <meta name="keywords" content="" />
    <link rel="icon" type="image/png" href="<?php echo e(asset('assets/img/favicon.png')); ?>" sizes="32x32">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('assets/img/icon/192x192.png')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>">
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css"/>
    <link rel="manifest" href="__manifest.json">
    <style>
        .webcam-capture,
        .webcam-capture video {
            display: block;
            width: 270px !important;
            margin: auto;
            height: 360px !important;
            border-radius: 15px;
        }

        #map { 
            height: 200px;
            border-radius: 15px;
        }
    </style>
</head>

<body>

    <!-- loader -->
    <div id="loader">
        <img src="<?php echo e(asset('assets/img/loading-icon.png')); ?>" alt="icon" class="loading-icon">
    </div>
    <!-- * loader -->

    <!-- App Header -->
    <div class="appHeader">
        <div class="left">
            <a href="/dashboard" class="headerButton goBack">
                <ion-icon name="chevron-back-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">Presensi</div>
        <div class="right">
        </div>
    </div>
    <!-- * App Header -->

    <?php
    function format_hari_tanggal($waktu)
        {
            $hari_array = array(
                'Minggu',
                'Senin',
                'Selasa',
                'Rabu',
                'Kamis',
                'Jumat',
                'Sabtu'
            );
            $hr = date('w', strtotime($waktu));
            $hari = $hari_array[$hr];
            $tanggal = date('j', strtotime($waktu));
            $bulan_array = array(
                1 => 'Januari',
                2 => 'Februari',
                3 => 'Maret',
                4 => 'April',
                5 => 'Mei',
                6 => 'Juni',
                7 => 'Juli',
                8 => 'Agustus',
                9 => 'September',
                10 => 'Oktober',
                11 => 'November',
                12 => 'Desember',
            );
            $bl = date('n', strtotime($waktu));
            $bulan = $bulan_array[$bl];
            $tahun = date('Y', strtotime($waktu));
            $jam = date( 'H:i:s', strtotime($waktu));
            return "$hari, $tanggal $bulan $tahun";
        }

        $date = date('Y-m-d');
    ?>

    <!-- App Capsule -->
    <div id="appCapsule">
        <div class="section full">
            <div class="col">
                <input type="hidden" id="lokasi">
                <div class="webcam-capture" style="margin-top: 8px"></div>
            </div>
        </div>
        <div class="section full mb-1">
            <div class="col">
                <div class="card p-1">
                    <h2 id="jam" style="text-align: center; margin-bottom: 0px;"></h2>
                    <h5 style="text-align: center; margin-bottom: 0px;">
                        <?php echo e(format_hari_tanggal($date)); ?></h5>
                </div>
            </div>
        </div>
        <div class="section full mb-1" style="padding-left: 8px; padding-right: 8px;">
            <div class="row">
                <div class="col-6">
                    <div class="card bg-info">
                        <div class="card-body text-center" style="padding: 8px !important; line-height: 0.8rem;">
                            <div style="margin-bottom: 4px;">
                                <span style="font-size: 0.8rem; font-weight:500;">
                                    Jam Masuk</span>
                            </div>
                            <span style="font-size: 0.8rem; font-weight:500;">
                                <?php echo e(date("H:i",strtotime($jamkerja->jam_masuk_awal))); ?></span> -
                            <span style="font-size: 0.8rem; font-weight:500;">
                                <?php echo e(date("H:i",strtotime($jamkerja->jam_masuk_akhir))); ?></span>
                        </div>
                    </div>
                </div>
                <div class="col-6">
                    <div class="card bg-danger">
                        <div class="card-body text-center" style="padding: 8px !important; line-height: 0.8rem;">
                            <div style="margin-bottom: 4px;">
                                <span style="font-size: 0.8rem; font-weight:500;">
                                    Jam Pulang</span>
                            </div>
                            <span style="font-size: 0.8rem; font-weight:500;">
                                <?php echo e(date("H:i",strtotime($jamkerja->jam_pulang_awal))); ?></span> - 
                            <span style="font-size: 0.8rem; font-weight:500;">
                                <?php echo e(date("H:i",strtotime($jamkerja->jam_pulang_akhir))); ?></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="section full mb-1">
            <div class="col">

                <?php if(date('D') != 'Sun'): ?>
                    <?php if($cek != null): ?>
                        <?php if($cek->status == "i"): ?>
                            <button class="btn btn-success btn-lg btn-block" disabled>
                                <ion-icon name="document-text-outline"></ion-icon> Hari Ini Anda Ijin
                            </button>
                        <?php elseif($cek->status == "s"): ?>
                            <button class="btn btn-success btn-lg btn-block" disabled>
                                <ion-icon name="medkit-outline"></ion-icon> Hari Ini Anda Ijin Sakit
                            </button>
                        <?php elseif($cek->status == "c"): ?>
                            <button class="btn btn-success btn-lg btn-block" disabled>
                                <ion-icon name="calendar-outline"></ion-icon> Hari Ini Anda Cuti
                            </button>
                        <?php else: ?>
                            <?php if($cek->jam_out != null): ?>
                                <button class="btn btn-warning btn-lg btn-block" disabled>
                                    <ion-icon name="checkmark-circle-outline"></ion-icon> Anda Sudah Absen Pulang. Terima Kasih.
                                </button>
                            <?php else: ?>
                                <button id="takeabsen" class="btn btn-danger btn-lg btn-block">
                                    <ion-icon name="camera-outline"></ion-icon> Absen Pulang
                                </button>
                            <?php endif; ?>
                        <?php endif; ?>
                    <?php else: ?>
                    <button id="takeabsen" class="btn btn-success btn-lg btn-block">
                        <ion-icon name="camera-outline"></ion-icon> Absen Masuk</button>
                    <?php endif; ?>
                <?php else: ?>
                <button class="btn btn-danger btn-lg btn-block" disabled>
                    <ion-icon name="calendar-outline"></ion-icon> Hari Minggu Libur Boss!
                </button>
                <?php endif; ?>
                
            </div>
        </div>
        <div class="section full mb-1">
            <div class="col">
                <div id="map"></div>
            </div>
        </div>
    </div>
    <!-- * App Capsule -->

    <!-- App Bottom Menu -->
    <div class="appBottomMenu">
        <a href="/dashboard" class="item">
            <div class="col">
                <ion-icon name="file-tray-full-outline"></ion-icon>
                <strong>Home</strong>
            </div>
        </a>
        <a href="/histori" class="item">
            <div class="col">
                <ion-icon name="list-circle-outline"></ion-icon>
                <strong>Riwayat</strong>
            </div>
        </a>
        <a href="/presensi/create" class="item">
            <div class="col">
                <div class="action-button large">
                    <ion-icon name="finger-print"></ion-icon>
                </div>
            </div>
        </a>
        <a href="/ijin" class="item">
            <div class="col">
                <ion-icon name="document-text-outline"></ion-icon>
                <strong>Ijin</strong>
            </div>
        </a>
        <a href="/profile" class="item">
            <div class="col">
                <ion-icon name="person-outline"></ion-icon>
                <strong>Profil</strong>
            </div>
        </a>
    </div>
    <!-- * App Bottom Menu -->



    <!-- ========= JS Files =========  -->
    <!-- Jquery -->
    <script src="<?php echo e(asset('assets/js/lib/jquery-3.4.1.min.js')); ?>"></script>
    <!-- Bootstrap -->
    <script src="<?php echo e(asset('assets/js/lib/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/lib/popper.min.js')); ?>"></script>
    <!-- Ionicons -->
    <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>
    <!-- Webcam -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/webcamjs/1.0.26/webcam.min.js"></script>
    <!-- Maps -->
    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
    <!-- Splide -->
    <script src="<?php echo e(asset('assets/js/plugins/splide/splide.min.js')); ?>"></script>
    <!-- Owl Carousel -->
    <script src="<?php echo e(asset('assets/js/plugins/owl-carousel/owl.carousel.min.js')); ?>"></script>
    <!-- jQuery Circle Progress -->
    <script src="<?php echo e(asset('assets/js/plugins/jquery-circle-progress/circle-progress.min.js')); ?>"></script>
    <script src="https://cdn.amcharts.com/lib/4/core.js"></script>
    <script src="https://cdn.amcharts.com/lib/4/charts.js"></script>
    <script src="https://cdn.amcharts.com/lib/4/themes/animated.js"></script>
    <!-- SweetAlert -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <!-- Base Js File -->
    <script src="<?php echo e(asset('assets/js/base.js')); ?>"></script>

    <script type="text/javascript">
        window.onload = function() {
            jam();
        }
     
        function jam() {
            var e = document.getElementById('jam')
                , d = new Date()
                , h, m, s;
            h = d.getHours();
            m = set(d.getMinutes());
            s = set(d.getSeconds());
     
            e.innerHTML = h + ':' + m + ':' + s;
     
            setTimeout('jam()', 1000);
        }
     
        function set(e) {
            e = e < 10 ? '0' + e : e;
            return e;
        }
     
    </script>

    <script>
        // Webcam
        Webcam.set({
            height:600,
            width:480,
            image_format:'jpeg',
            jpeg_quality:80,
            flip_horiz: true
        });

        Webcam.attach('.webcam-capture');
        
        var lokasi = document.getElementById('lokasi');
        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(successCallback, errorCallback);
        }

        function successCallback(position) {
            lokasi.value = position.coords.latitude + "," + position.coords.longitude;

            var map = L.map('map').setView([position.coords.latitude, position.coords.longitude], 17);

            L.tileLayer('http://{s}.google.com/vt/lyrs=m&x={x}&y={y}&z={z}',{
                maxZoom: 20,
                subdomains:['mt0','mt1','mt2','mt3']
            }).addTo(map);

            var marker = L.marker([position.coords.latitude, position.coords.longitude]).addTo(map);
            //Lokasi Kantor
            var lat_kantor = <?php echo e($lokasi_kantor->latitude); ?>

            var long_kantor = <?php echo e($lokasi_kantor->longitude); ?>

            var radius = <?php echo e($lokasi_kantor->radius); ?>

            var circle = L.circle([lat_kantor, long_kantor], {
                color: 'red',
                fillColor: '#f03',
                fillOpacity: 0.5,
                radius: radius
            }).addTo(map);
        }

        function errorCallback() {

        }

        $("#takeabsen").click(function(e){
            Webcam.snap(function(uri){
                image = uri;
            });
            var lokasi = $("#lokasi").val();
            $.ajax({
                type: 'POST',
                url: '/presensi/store',
                data: {
                    _token: "<?php echo e(csrf_token()); ?>",
                    image: image,
                    lokasi: lokasi
                },
                cache: false,
                success: function(respond){
                    var status = respond.split("|");
                    if(status[0] == "success"){
                        Swal.fire({
                            title: 'Mantab!',
                            text: status[1],
                            icon: 'success'
                            })
                            setTimeout("location.href='/dashboard'", 2000);
                    }else{
                        Swal.fire({
                            title: 'Waduh!',
                            text: status[1],
                            icon: 'error'
                            })
                    }
                }
            });
        });
    </script>


</body>

</html><?php /**PATH D:\BELAJAR\#KUMPULAN SOURCE CODE\PRESENSI GPS LARAVEL\presensigps\resources\views/presensi/create.blade.php ENDPATH**/ ?>