<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <title>Cetak Rekap Presensi Karyawan</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/normalize/7.0.0/normalize.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/paper-css/0.4.1/paper.css">
  <style>
      @page {
        size: A4
      }
      h3 {
        font-family: Arial, Helvetica, sans-serif
      }
      span {
        font-family: Arial, Helvetica, sans-serif
      }
      .tabeldatakaryawan {
        margin-top: 30px;
        font-family: Arial, Helvetica, sans-serif;
        font-size: 14px;
      }
      .tabeldatakaryawan td {
        padding: 5px;
      }
      .tabelpresensi {
        width: 100%;
        margin-top: 20px;
        font-family: Arial, Helvetica, sans-serif;
        font-size: 10px;
        border-collapse: collapse;
      }
      .tabelpresensi tr th {
        border: 1px solid #000000;
        padding: 8px;
        background-color: #e2e2e2;
      }
      .tabelpresensi tr td {
        border: 1px solid #000000;
        padding: 2px;
      }
      .tandatangan {
        width: 100%;
        font-family: Arial, Helvetica, sans-serif;
        font-size: 14px;
        margin-top: 20px;
      }
  </style>
</head>

<body class="legal landscape">
  <?php
    //Function Untuk Menghitung Selisih Jam
    function selisih($jam_masuk, $jam_keluar)
            {
                list($h, $m, $s) = explode(":", $jam_masuk);
                $dtAwal = mktime($h, $m, $s, "1", "1", "1");
                list($h, $m, $s) = explode(":", $jam_keluar);
                $dtAkhir = mktime($h, $m, $s, "1", "1", "1");
                $dtSelisih = $dtAkhir - $dtAwal;
                $totalmenit = $dtSelisih / 60;
                $jam = explode(".", $totalmenit / 60);
                $sisamenit = ($totalmenit / 60) - $jam[0];
                $sisamenit2 = $sisamenit * 60;
                $jml_jam = $jam[0];
                return $jml_jam . ":" . round($sisamenit2);
            }
  ?>
  
  <section class="sheet padding-10mm">

    <table style="width: 100%">
      <tr>
        <td style="width: 120px">
          <img src="<?php echo e(asset('assets/panel/img/logo-alamien.png')); ?>" width="100" alt="">
        </td>
        <td>
          <h3 style="margin-block-end: 0em;">
            LAPORAN PRESENSI KARYAWAN <br>
            PERIODE <?php echo e(strtoupper($namabulan[$bulan])); ?> <?php echo e($tahun); ?> <br>
            AL AMIEN JEMBER <br>
          </h3>
          <span>Jl. K. Masduqi Kebonsari Ambulu Jember</span>
        </td>
      </tr>
    </table>

    <table class="tabelpresensi">
      <tr>
        <th rowspan="2">No.</th>
        <th rowspan="2">NIK</th>
        <th rowspan="2">Nama Karyawan</th>
        <th colspan="<?php echo e($jmlhari); ?>">Bulan <?php echo e($namabulan[$bulan]); ?> <?php echo e($tahun); ?></th>
        <th rowspan="2">H</th>
        <th rowspan="2">I</th>
        <th rowspan="2">S</th>
        <th rowspan="2">C</th>
        <th rowspan="2">A</th>
      </tr>
      <tr>
        <?php $__currentLoopData = $rangetanggal; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <?php if($d != NULL): ?>
          <th><?php echo e(date("d",strtotime($d))); ?></th>  
          <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </tr>
      <?php $__currentLoopData = $rekap; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr>
              <td style="text-align: center;"><?php echo e($loop->iteration); ?></td>
              <td style="text-align: center;"><?php echo e($r->nik); ?></td>
              <td><?php echo e($r->nama_lengkap); ?></td>
              <?php
                $jml_hadir = 0;
                $jml_ijin = 0;
                $jml_sakit = 0;
                $jml_cuti = 0;
                $jml_alpa = 0;
                $color = "";
                for($i=1; $i<=$jmlhari; $i++){
                  $tgl = "tgl_".$i;
                  $datapresensi = explode("|",$r->$tgl);
                  if ($r->$tgl != NULL) {
                      $status = $datapresensi[2];
                  } else {
                      $status = "";
                  }

                  if ($status == "h") {
                      $jml_hadir += 1;
                      $color = "#ffffff";
                  } elseif ($status == "i") {
                      $jml_ijin += 1;
                      $color = "#ffc800";
                  } elseif ($status == "s") {
                      $jml_sakit += 1;
                      $color = "#00ff84";
                  } elseif ($status == "c") {
                      $jml_cuti += 1;
                      $color = "#00d0ff";
                  } elseif (empty($status)) {
                      $jml_alpa += 1;
                      $color = "#ff0000";
                  }
                  
              ?>
              <td style="text-align: center; background-color: <?php echo e($color); ?>;">
                  <?php echo e($status); ?>

              </td>
              <?php } ?>
              <td style="text-align: center;"><?php echo e(!empty($jml_hadir) ? $jml_hadir : ""); ?></td>
              <td style="text-align: center;"><?php echo e(!empty($jml_ijin) ? $jml_ijin : ""); ?></td>
              <td style="text-align: center;"><?php echo e(!empty($jml_sakit) ? $jml_sakit : ""); ?></td>
              <td style="text-align: center;"><?php echo e(!empty($jml_cuti) ? $jml_cuti : ""); ?></td>
              <td style="text-align: center;"><?php echo e(!empty($jml_alpa) ? $jml_alpa : ""); ?></td>
          </tr>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </table>
    

    <table class="tandatangan">
      <tr>
        <td style="width: 60%;"></td>
        <td style="text-align: center;">
          Jember, <?php echo e(date("d-m-Y")); ?> <br>
          Kepala Madrasah <br>
          <br><br><br><br>
          <b><u>Nama Kepala Madrasah</u></b>
        </td>
      </tr>
    </table>

  </section>

</body>

</html><?php /**PATH D:\BELAJAR\#KUMPULAN SOURCE CODE\PRESENSI GPS LARAVEL\presensigps\resources\views/presensi/cetakrekap.blade.php ENDPATH**/ ?>