<!doctype html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="theme-color" content="#000000">
    <title>E-Presensi Geolocation</title>
    <meta http-equiv="Cache-Control" content="no-cache" />
    <meta name="description" content="E-Presensi Geolocation">
    <meta name="keywords" content="" />
    <link rel="icon" type="image/png" href="<?php echo e(asset('assets/img/favicon.png')); ?>" sizes="32x32">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('assets/img/icon/192x192.png')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>">
    <link rel="manifest" href="__manifest.json">
    <style>
        div.scrollmenu {
            overflow: auto;
            white-space: nowrap;
            padding:10px; 
            max-height:300px;
        }

        .table-scroll {
            position: relative;
            width:100%;
            z-index: 1;
            margin: auto;
            overflow: auto;
            max-height:300px;
        }
        .table-scroll table {
            width:100%;
            margin: auto;
            border-collapse: separate;
            border-spacing: 0;
        }
        .table-wrap {
            position: relative;
        }
        .table-scroll th,
        .table-scroll td {
            padding: 5px;
            border: 1px solid #f8f8f8;
            background: #fff;
            vertical-align: top;
        }
        .table-scroll thead th {
            background: #05D0A4;
            color: #ffffff;
            position: -webkit-sticky;
            position: sticky;
            top: 0;
            font-weight: normal;
        }

        th:first-child {
            position: sticky;
            left: 0;
            z-index: 2;
            background: #ffffff;
            width: 140px;
            min-width: 140px;
            font-weight: normal;
        }
        thead th:first-child,
        tfoot th:first-child {
            z-index: 5;
        }
    </style>
</head>

<body>
    <?php
    function format_hari_tanggal($waktu)
        {
            $hari_array = array(
                'Minggu',
                'Senin',
                'Selasa',
                'Rabu',
                'Kamis',
                'Jumat',
                'Sabtu'
            );
            $hr = date('w', strtotime($waktu));
            $hari = $hari_array[$hr];
            $tanggal = date('j', strtotime($waktu));
            $bulan_array = array(
                1 => 'Januari',
                2 => 'Februari',
                3 => 'Maret',
                4 => 'April',
                5 => 'Mei',
                6 => 'Juni',
                7 => 'Juli',
                8 => 'Agustus',
                9 => 'September',
                10 => 'Oktober',
                11 => 'November',
                12 => 'Desember',
            );
            $bl = date('n', strtotime($waktu));
            $bulan = $bulan_array[$bl];
            $tahun = date('Y', strtotime($waktu));
            $jam = date( 'H:i:s', strtotime($waktu));
            return "$hari, $tanggal $bulan $tahun";
        }

        $date = date('Y-m-d');
    ?>

    <!-- loader -->
    <div id="loader">
        <img src="<?php echo e(asset('assets/img/loading-icon.png')); ?>" alt="icon" class="loading-icon">
    </div>
    <!-- * loader -->

    <!-- App Header -->
    <div class="appHeader bg-primary text-light">
        <div class="left">
            <a href="#" class="headerButton" data-bs-toggle="modal" data-bs-target="#sidebarPanel">
                <ion-icon name="menu-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">
            
            E-Presensi Al Amien
        </div>
        <div class="right">
            
            <a href="/proseslogout" class="headerButton">
                <ion-icon class="icon" name="log-out-outline"></ion-icon>
            </a>
        </div>
    </div>
    <!-- * App Header -->


    <!-- App Capsule -->
    <div id="appCapsule">
        <!-- Wallet Card -->
        <div class="section wallet-card-section pt-1">
            <div class="wallet-card">

                <div class="section text-center">
                    <div class="avatar-section">
                        <?php if(!empty(Auth::guard('karyawan')->user()->foto)): ?>
                         <?php
                             $path = Storage::url('uploads/karyawan/'.Auth::guard('karyawan')->user()->foto);
                         ?>
                        <img src="<?php echo e(url($path)); ?>" alt="avatar" class="imaged w100 rounded">
                        <?php else: ?>
                        <img src="<?php echo e(asset('storage/uploads/karyawan/default.png')); ?>" alt="avatar" class="imaged w100 rounded">
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Balance -->
                <div class="balance">
                    <div class="center">
                            <h1 style="margin-bottom: 0px; margin-top: 5px;" class="total"><?php echo e($karyawan->nama_lengkap); ?></h1>
                            <span class="title" style="margin-bottom: 0px;"><?php echo e($karyawan->nama_jab); ?> (<?php echo e($karyawan->kode_cabang); ?>)</span>
                    </div>
                </div>
                <!-- * Balance -->
                <!-- Wallet Footer -->
                <div class="wallet-footer">
                    <div class="item">
                        <a href="/profile">
                            <div class="icon-wrapper">
                                <ion-icon name="person-outline"></ion-icon>
                            </div>
                            <strong>Profil</strong>
                        </a>
                    </div>
                    <div class="item">
                        <a href="/ijin">
                            <div class="icon-wrapper">
                                <ion-icon name="calendar-outline"></ion-icon>
                            </div>
                            <strong>Cuti</strong>
                        </a>
                    </div>
                    <div class="item">
                        <a href="/histori">
                            <div class="icon-wrapper">
                                <ion-icon name="document-text-outline"></ion-icon>
                            </div>
                            <strong>Histori</strong>
                        </a>
                    </div>
                    <div class="item">
                        <a href="/lokasisaya">
                            <div class="icon-wrapper">
                                <ion-icon name="location-outline"></ion-icon>
                            </div>
                            <strong>Lokasi</strong>
                        </a>
                    </div>

                </div>
                <!-- * Wallet Footer -->
            </div>
        </div>
        <!-- Wallet Card -->

        <!-- Stats -->
        <div class="section">
            <div class="todaypresence">
                <div class="row">
                    <div class="col-6">
                        <div class="card warnagreen">
                            <div class="card-body">
                                <div class="presencecontent">
                                    <div class="iconpresence">

                                        <?php if($presensihariini != null): ?>
                                            <?php if($presensihariini->jam_in != null): ?>
                                                <?php
                                                $path = Storage::url('uploads/absensi/'.$presensihariini->foto_in);
                                                ?>
                                                <img src="<?php echo e(url($path)); ?>" alt="" class="imaged w48">
                                            <?php else: ?>
                                                <ion-icon name="image"></ion-icon>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <ion-icon name="image"></ion-icon>
                                        <?php endif; ?>
                                        
                                    </div>
                                    <div class="presencedetail">
                                        <h4 class="presencetitle">Masuk</h4>
                                        <span>
                                            
                                            <?php if($presensihariini != null): ?>
                                                <?php if($presensihariini->jam_in != null): ?>
                                                    <?php echo e($presensihariini->jam_in); ?>

                                                <?php else: ?>
                                                    Belum Absen
                                                <?php endif; ?>
                                            <?php else: ?>
                                                Belum Absen
                                            <?php endif; ?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="card warnared">
                            <div class="card-body">
                                <div class="presencecontent">
                                    <div class="iconpresence">
                                        <?php if($presensihariini != null && $presensihariini->jam_out != null): ?>
                                            <?php
                                            $path = Storage::url('uploads/absensi/'.$presensihariini->foto_out);
                                            ?>
                                            <img src="<?php echo e(url($path)); ?>" alt="" class="imaged w48">
                                        <?php else: ?>
                                            <ion-icon name="image"></ion-icon>
                                        <?php endif; ?>
                                        
                                    </div>
                                    <div class="presencedetail">
                                        <h4 class="presencetitle">Pulang</h4>
                                        <span><?php echo e($presensihariini != null && $presensihariini->jam_out != null ? $presensihariini->jam_out : "Belum Absen"); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- * Stats -->

        <!-- Rekap -->
        <div class="section mt-2" id="rekappresensi">
            <div class="section-heading2" style="margin-bottom: 0px;">
                <h3>Rekap Presensi Bulan <?php echo e($namabulan[$bulanini]); ?> <?php echo e($tahunini); ?></h3>
            </div>
            <div class="row">
                <div class="col-3">
                    <div class="card">
                        <div class="card-body text-center" style="padding: 8px !important; line-height: 0.8rem;">
                            <span class="badge badge-danger" style="position:absolute; top:3px; right:5px; font-size:0.6rem; z-index:999;">
                                <?php echo e($rekappresensi->jmlhadir); ?></span>
                            <ion-icon name="checkmark-circle" class="text-info" style="font-size: 1.5rem"></ion-icon>
                            <br>
                            <span style="font-size: 0.8rem; font-weight:500;">Hadir</span>
                        </div>
                    </div>
                </div>
                <div class="col-3">
                    <div class="card">
                        <div class="card-body text-center" style="padding: 8px !important; line-height: 0.8rem;">
                            <span class="badge badge-danger" style="position:absolute; top:3px; right:5px; font-size:0.6rem; z-index:999;">
                                <?php echo e($rekapijin->jmlijin != null ? $rekapijin->jmlijin : 0); ?></span>
                            <ion-icon name="document-text" class="text-primary" style="font-size: 1.5rem"></ion-icon>
                            <br>
                            <span style="font-size: 0.8rem; font-weight:500;">Ijin</span>
                        </div>
                    </div>
                </div>
                <div class="col-3">
                    <div class="card">
                        <div class="card-body text-center" style="padding: 8px !important; line-height: 0.8rem;">
                            <span class="badge badge-danger" style="position:absolute; top:3px; right:5px; font-size:0.6rem; z-index:999;">
                                <?php echo e($rekapijin->jmlsakit != null ? $rekapijin->jmlsakit : 0); ?></span>
                            <ion-icon name="medkit" class="text-danger" style="font-size: 1.5rem"></ion-icon>
                            <br>
                            <span style="font-size: 0.8rem; font-weight:500;">Sakit</span>
                        </div>
                    </div>
                </div>
                <div class="col-3">
                    <div class="card">
                        <div class="card-body text-center" style="padding: 8px !important; line-height: 0.8rem;">
                            <span class="badge badge-danger" style="position:absolute; top:3px; right:5px; font-size:0.6rem; z-index:999;">
                                <?php echo e($rekappresensi->jmlterlambat != null ? $rekappresensi->jmlterlambat : 0); ?></span>
                            <ion-icon name="alarm" class="text-warning" style="font-size: 1.5rem"></ion-icon>
                            <br>
                            <span style="font-size: 0.8rem; font-weight:500;">Telat</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <div class="section mt-3">
            <div class="section-heading2" style="margin-bottom: 0px;">
                <h3>Riwayat Presensi</h3>
            </div>
            <div class="card">
                <div class="card-body" style="padding: 10px;">
                    <ul class="nav nav-tabs capsuled" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" data-bs-toggle="tab" href="#bulanini" role="tab">
                                Bulan Ini
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-bs-toggle="tab" href="#hariini" role="tab">
                                Hari Ini
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-bs-toggle="tab" href="#rekap" role="tab">
                                Rekap
                            </a>
                        </li>
                    </ul>

                    
                    <div class="tab-content mt-1">
                        <div class="tab-pane fade show active" id="bulanini" role="tabpanel">
                            <div class="scrollmenu">
                                <ul class="listview image-listview">
                                    <?php $__currentLoopData = $historibulanini; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> 
                                    <li>
                                        <div class="item" style="padding: 0px">
                                            <?php
                                                $pathin = Storage::url('uploads/absensi/'.$d->foto_in);
                                            ?>
                                            
                                            <?php
                                                $pathout = Storage::url('uploads/absensi/'.$d->foto_out);
                                            ?>
                                            
                                            <?php if($d->status == "h"): ?>
                                                <div class="icon-box bg-primary">
                                                    <ion-icon name="finger-print-outline"></ion-icon>
                                                </div>
                                            <?php elseif($d->status == "i"): ?>
                                                <div class="icon-box bg-info">
                                                    <ion-icon name="document-text-outline"></ion-icon>
                                                </div>
                                            <?php elseif($d->status == "s"): ?>
                                                <div class="icon-box bg-danger">
                                                    <ion-icon name="medkit-outline"></ion-icon>
                                                </div>
                                            <?php elseif($d->status == "c"): ?>
                                                <div class="icon-box bg-warning">
                                                    <ion-icon name="calendar-outline"></ion-icon>
                                                </div>
                                            <?php endif; ?>
                                            
                                            <div class="in">
                                                <div><?php echo e(date("d-m-Y",strtotime($d->tgl_presensi))); ?></div>
                                                <div>
                                                    <?php if($d->status == "h"): ?>
                                                        
                                                        <a href="#" data-bs-toggle="modal" data-bs-target="#FotoMasuk<?php echo e(date("Ymd",strtotime($d->tgl_presensi))); ?>">
                                                            <span class="badge <?php echo e($d->jam_in < $d->jam_masuk_akhir ? "badge-info" : "badge-warning"); ?>"><?php echo e($d->jam_in); ?></span>
                                                        </a>
                                                        
                                                        <a href="#" data-bs-toggle="modal" data-bs-target="#FotoPulang<?php echo e(date("Ymd",strtotime($d->tgl_presensi))); ?>">
                                                            <span class="badge badge-danger"><?php echo e($d->jam_out != null ? $d->jam_out : 'Belum Absen'); ?></span>
                                                        </a>
                                                    <?php else: ?>
                                                    <span class="badge badge-primary"><?php echo e($d->status == "s" ? "Sakit" : ($d->status == "i" ? "Ijin" : "Cuti")); ?></span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </li>

                                    <!-- Modal Foto Masuk -->
                                    <div class="modal fade dialogbox" id="FotoMasuk<?php echo e(date("Ymd",strtotime($d->tgl_presensi))); ?>" data-bs-backdrop="static" tabindex="-1" role="dialog">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="text-center mt-2">
                                                    <span style="color: black;">Foto Masuk</span>
                                                </div>
                                                <div class="pt-3 text-center mb-2">
                                                    <img src="<?php echo e(url($pathin)); ?>" alt="image" class="imaged" style="width: 280px">
                                                </div>
                                                <div class="modal-footer">
                                                    <div class="btn-inline">
                                                        <a href="#" class="btn" data-bs-dismiss="modal">OK</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- * Modal Foto Masuk -->
                                    <!-- Modal Foto Pulang -->
                                    <div class="modal fade dialogbox" id="FotoPulang<?php echo e(date("Ymd",strtotime($d->tgl_presensi))); ?>" data-bs-backdrop="static" tabindex="-1" role="dialog">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="text-center mt-2">
                                                    <span style="color: black;">Foto Pulang</span>
                                                </div>
                                                <div class="pt-3 text-center mb-2">
                                                    <?php if($d->jam_out != null): ?>
                                                        <img src="<?php echo e(url($pathout)); ?>" alt="image" class="imaged" style="width: 280px">
                                                    <?php else: ?>
                                                    <span class="badge badge-danger">Belum Absen</span>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="modal-footer">
                                                    <div class="btn-inline">
                                                        <a href="#" class="btn" data-bs-dismiss="modal">OK</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- * Modal Foto Pulang -->
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>

                        <div class="tab-pane fade" id="hariini" role="tabpanel">
                            <div class="scrollmenu">
                                <ul class="listview image-listview"> 
                                    
                                    <?php $__currentLoopData = $leaderboard; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li>
                                        <div class="item" style="padding: 0px">
                                            <?php if(!empty($d->foto)): ?>
                                                <?php
                                                    $path = Storage::url('uploads/karyawan/'.$d->foto);
                                                ?>
                                                <img src="<?php echo e(url($path)); ?>" alt="image" class="image">
                                            <?php else: ?>
                                                <img src="<?php echo e(asset('storage/uploads/karyawan/default.png')); ?>" alt="image" class="image">
                                            <?php endif; ?>
                                            <div class="in">
                                                <div style="line-height: 0.8rem">
                                                    <?php echo e($d->nama_lengkap); ?>

                                                    <br>
                                                    <span class="text-muted" style="font-size: 10px"><?php echo e($d->nama_jab); ?> (<?php echo e($d->kode_cabang); ?>)</span>
                                                </div>
                                                <div>
                                                    <?php if($d->status == "h"): ?>
                                                        <span class="badge <?php echo e($d->jam_in < $d->jam_masuk_akhir ? "badge-info" : "badge-warning"); ?>" style="margin-bottom: 0.1rem;"><?php echo e($d->jam_in); ?></span>
                                                        <br>
                                                        <?php if($d->jam_out != null): ?>
                                                            <span class="badge badge-danger"><?php echo e($d->jam_out); ?></span>
                                                        <?php else: ?>
                                                        <?php endif; ?>
                                                    <?php else: ?>
                                                        <span class="badge badge-primary"><?php echo e($d->status == "s" ? "Sakit" : ($d->status == "i" ? "Ijin" : "Cuti")); ?></span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    
                                </ul>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="rekap" role="tabpanel">
                            <div id="table-scroll" class="table-scroll">
                                <table id="main-table" class="main-table">
                                    <thead>
                                    <tr>
                                        <th style="text-align: center;">Nama Guru</th>
                                        <?php
                                            for($i=1; $i<=31; $i++){
                                        ?>
                                            <th style="text-align: center;"><?php echo e($i); ?></th>
                                        <?php
                                            }
                                        ?>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $rekap; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <th><?php echo e($d->nama_lengkap); ?></th>
                                            <?php
                                            $totalhadir = 0;
                                            $totalterlambat = 0;
                                            for($i=1; $i<=31; $i++){
                                                $tgl = "tgl_".$i;
                                                if(empty($d->$tgl)){
                                                    $hadir = ["",""];
                                                    $totalhadir += 0;
                                                }else{
                                                    $hadir = explode("-", $d->$tgl);
                                                    $totalhadir += 1;
                                                    if ($hadir[0] > $d->jam_masuk_akhir) {
                                                    $totalterlambat += 1;
                                                    }
                                                }
                                            ?>
                                                <td style="text-align: center;">
                                                    <?php if(!empty($hadir[0])): ?>
                                                        <?php if($hadir[0] > $d->jam_masuk_akhir): ?>
                                                            <ion-icon name="ellipse" class="text-warning"></ion-icon>
                                                        <?php else: ?>
                                                            <ion-icon name="ellipse" class="text-info"></ion-icon>
                                                        <?php endif; ?>
                                                    <?php else: ?>
                                                        <span></span>
                                                    <?php endif; ?> <br>
                                                    <?php if(!empty($hadir[1])): ?>
                                                     <ion-icon name="ellipse" class="text-danger"></ion-icon>
                                                    <?php else: ?>
                                                        <span></span>
                                                    <?php endif; ?>

                                                </td>
                                            <?php
                                                }
                                            ?>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <!-- * App Capsule -->

    <br>

    <!-- App Bottom Menu -->
    <div class="appBottomMenu">
        <a href="/dashboard" class="item active">
            <div class="col">
                <ion-icon name="file-tray-full-outline"></ion-icon>
                <strong>Home</strong>
            </div>
        </a>
        <a href="/histori" class="item">
            <div class="col">
                <ion-icon name="list-circle-outline"></ion-icon>
                <strong>Riwayat</strong>
            </div>
        </a>
        <a href="/presensi/create" class="item">
            <div class="col">
                <div class="action-button large">
                    <ion-icon name="finger-print"></ion-icon>
                </div>
            </div>
        </a>
        <a href="/ijin" class="item">
            <div class="col">
                <ion-icon name="document-text-outline"></ion-icon>
                <strong>Ijin</strong>
            </div>
        </a>
        <a href="/profile" class="item">
            <div class="col">
                <ion-icon name="person-outline"></ion-icon>
                <strong>Profil</strong>
            </div>
        </a>
    </div>
    <!-- * App Bottom Menu -->

    <!-- App Sidebar -->
    <div class="modal fade panelbox panelbox-left" id="sidebarPanel" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body p-0">
                    <!-- profile box -->
                    <div class="profileBox pt-2 pb-2">
                        <div class="image-wrapper">
                            <?php if(!empty(Auth::guard('karyawan')->user()->foto)): ?>
                            <?php
                                $path = Storage::url('uploads/karyawan/'.Auth::guard('karyawan')->user()->foto);
                            ?>
                            <img src="<?php echo e(url($path)); ?>" alt="image" class="imaged  w36">
                            <?php else: ?>
                            <img src="<?php echo e(asset('storage/uploads/karyawan/default.png')); ?>" alt="image" class="imaged  w36">
                            <?php endif; ?>
                        </div>
                        <div class="in">
                            <strong><?php echo e(Auth::guard('karyawan')->user()->nama_lengkap); ?></strong>
                            <div class="text-muted"><?php echo e(Auth::guard('karyawan')->user()->nik); ?></div>
                        </div>
                        <a href="#" class="btn btn-link btn-icon sidebar-close" data-bs-dismiss="modal">
                            <ion-icon name="close-outline"></ion-icon>
                        </a>
                    </div>
                    <!-- * profile box -->
                    <!-- balance -->
                    <div class="sidebar-balance">
                        <div class="listview-title"><?php echo e(format_hari_tanggal($date)); ?></div>
                        <div class="in">
                            <h1 id="jam" class="amount"></h1>
                        </div>
                    </div>
                    <!-- * balance -->

                    <!-- menu -->
                    <div class="listview-title mt-1">Menu</div>
                    <ul class="listview flush transparent no-line image-listview">
                        <li>
                            <a href="/proseslogout" class="item">
                                <div class="icon-box bg-primary">
                                    <ion-icon name="log-out-outline"></ion-icon>
                                </div>
                                <div class="in">
                                    Logout
                                </div>
                            </a>
                        </li>
                    </ul>
                    <!-- * menu -->

                </div>
            </div>
        </div>
    </div>
    <!-- * App Sidebar -->


    <!-- ========= JS Files =========  -->
    <!-- Jquery -->
    <script src="<?php echo e(asset('assets/js/lib/jquery-3.4.1.min.js')); ?>"></script>
    <!-- Bootstrap -->
    <script src="<?php echo e(asset('assets/js/lib/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/lib/popper.min.js')); ?>"></script>
    <!-- Ionicons -->
    <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>
    <!-- Splide -->
    <script src="<?php echo e(asset('assets/js/plugins/splide/splide.min.js')); ?>"></script>
    <!-- Apex Charts -->
    <script src="<?php echo e(asset('assets/js/plugins/apexcharts/apexcharts.min.js')); ?>"></script>
    <!-- Owl Carousel -->
    <script src="<?php echo e(asset('assets/js/plugins/owl-carousel/owl.carousel.min.js')); ?>"></script>
    <!-- jQuery Circle Progress -->
    <script src="<?php echo e(asset('assets/js/plugins/jquery-circle-progress/circle-progress.min.js')); ?>"></script>
    <script src="https://cdn.amcharts.com/lib/4/core.js"></script>
    <script src="https://cdn.amcharts.com/lib/4/charts.js"></script>
    <script src="https://cdn.amcharts.com/lib/4/themes/animated.js"></script>
    <!-- SweetAlert -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <!-- Base Js File -->
    <script src="<?php echo e(asset('assets/js/base.js')); ?>"></script>

    <script type="text/javascript">
        window.onload = function() {
            jam();
        }
     
        function jam() {
            var e = document.getElementById('jam')
                , d = new Date()
                , h, m, s;
            h = d.getHours();
            m = set(d.getMinutes());
            s = set(d.getSeconds());
     
            e.innerHTML = h + ':' + m + ':' + s;
     
            setTimeout('jam()', 1000);
        }
     
        function set(e) {
            e = e < 10 ? '0' + e : e;
            return e;
        }
     
    </script>

</body>

</html><?php /**PATH D:\BELAJAR\#KUMPULAN SOURCE CODE\PRESENSI GPS LARAVEL\presensigps\resources\views/dashboard/dashboard.blade.php ENDPATH**/ ?>