<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <title>Cetak Rekap Ijin/Sakit Karyawan</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/normalize/7.0.0/normalize.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/paper-css/0.4.1/paper.css">
  <style>
      @page {
        size: A4
      }
      h3 {
        font-family: Arial, Helvetica, sans-serif
      }
      span {
        font-family: Arial, Helvetica, sans-serif
      }
      .tabeldatakaryawan {
        margin-top: 30px;
        font-family: Arial, Helvetica, sans-serif;
        font-size: 14px;
      }
      .tabeldatakaryawan td {
        padding: 5px;
      }
      .tabelpresensi {
        width: 100%;
        margin-top: 20px;
        font-family: Arial, Helvetica, sans-serif;
        font-size: 10px;
        border-collapse: collapse;
      }
      .tabelpresensi tr th {
        border: 1px solid #000000;
        padding: 8px;
        background-color: #e2e2e2;
      }
      .tabelpresensi tr td {
        border: 1px solid #000000;
        padding: 2px;
      }
      .tandatangan {
        width: 100%;
        font-family: Arial, Helvetica, sans-serif;
        font-size: 14px;
        margin-top: 20px;
      }
  </style>
</head>

<body class="A4 potrait">
    
  <section class="sheet padding-10mm">

    <table style="width: 100%">
      <tr>
        <td>
          <h3 style="margin-block-end: 0em;">
            LAPORAN PERIJINAN KARYAWAN <br>
            PERIODE <?php echo e(strtoupper($namabulan[$bulan])); ?> <?php echo e($tahun); ?> <br>
            AL AMIEN JEMBER <br>
          </h3>
          <span>Jl. K. Masduqi Kebonsari Ambulu Jember</span>
        </td>
      </tr>
    </table>

    <table class="tabelpresensi">
      <tr>
        <th>No.</th>
        <th>Tanggal Ijin</th>
        <th>NIK</th>
        <th>Nama Karyawan</th>
        <th>Status</th>
        <th>Keterangan</th>
        <th>Count</th>
      </tr>
      <?php $__currentLoopData = $rekap; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr>
              <td style="text-align: center;"><?php echo e($loop->iteration); ?></td>
              <td style="text-align: center;"><?php echo e($d->tgl_ijin); ?></td>
              <td style="text-align: center;"><?php echo e($d->nik); ?></td>
              <td><?php echo e($d->nama_lengkap); ?></td>
              <td style="text-align: center;"><?php echo e($d->status == "i" ? "Ijin" : "Sakit"); ?></td>
              <td><?php echo e($d->keterangan); ?></td>
              <td style="text-align: center;">1</td>
          </tr>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </table>
    

    <table class="tandatangan">
      <tr>
        <td style="width: 60%;"></td>
        <td style="text-align: center;">
          Jember, <?php echo e(date("d-m-Y")); ?> <br>
          Kepala Madrasah <br>
          <br><br><br><br>
          <b><u>Nama Kepala Madrasah</u></b>
        </td>
      </tr>
    </table>

  </section>

</body>

</html><?php /**PATH D:\BELAJAR\#KUMPULAN SOURCE CODE\PRESENSI GPS LARAVEL\presensigps\resources\views/presensi/cetakrekapijinexcel.blade.php ENDPATH**/ ?>