<!doctype html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="theme-color" content="#000000">
    <title>Edit Ijin</title>
    <meta http-equiv="Cache-Control" content="no-cache" />
    <meta name="description" content="E-Presensi Geolocation">
    <meta name="keywords" content="" />
    <link rel="icon" type="image/png" href="<?php echo e(asset('assets/img/favicon.png')); ?>" sizes="32x32">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('assets/img/icon/192x192.png')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>">
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css"/>
    <link rel="manifest" href="__manifest.json">
</head>

<body>

    <!-- loader -->
    <div id="loader">
        <img src="<?php echo e(asset('assets/img/loading-icon.png')); ?>" alt="icon" class="loading-icon">
    </div>
    <!-- * loader -->

    <!-- App Header -->
    <div class="appHeader">
        <div class="left">
            <a href="/ijin" class="headerButton goBack">
                <ion-icon name="chevron-back-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">Edit Ijin</div>
        <div class="right">
        </div>
    </div>
    <!-- * App Header -->

    <!-- App Capsule -->
    <div id="appCapsule">
        <div class="section full mt-1">
            <div class="col">
                <div class="card">
                    <div class="card-body" style="padding: 10px;">
                        <form action="/ijinabsen/<?php echo e($dataijin->unik_ijin); ?>/update" method="POST" id="frmijin" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="form-group boxed">
                                <div class="input-wrapper">
                                    <label class="label" for="tgl_ijin_dari">Dari Tanggal</label>
                                    <input type="date" class="tm form-control" id="tgl_ijin_dari" name="tgl_ijin_dari" value="<?php echo e($dataijin->tgl_ijin_dari); ?>">
                                    <i class="clear-input">
                                        <ion-icon name="close-circle"></ion-icon>
                                    </i>
                                </div>
                            </div>
                            <div class="form-group boxed">
                                <div class="input-wrapper">
                                    <label class="label" for="tgl_ijin_sampai">Sampai Tanggal</label>
                                    <input type="date" class="form-control" id="tgl_ijin_sampai" name="tgl_ijin_sampai" value="<?php echo e($dataijin->tgl_ijin_sampai); ?>">
                                    <i class="clear-input">
                                        <ion-icon name="close-circle"></ion-icon>
                                    </i>
                                </div>
                            </div>
                            <div class="form-group boxed">
                                <div class="input-wrapper">
                                    <label class="label" for="jml_hari">Jumlah Ijin</label>
                                    <input type="input" class="form-control" id="jml_hari" name="jml_hari" readonly>
                                </div>
                            </div>

                            
                            <div class="form-group boxed">
                                <div class="input-wrapper">
                                    <label class="label" for="keterangan">Keterangan</label>
                                    <textarea id="keterangan" name="keterangan" rows="3" class="form-control" placeholder="Keterangan"><?php echo e($dataijin->keterangan); ?></textarea>
                                    <i class="clear-input">
                                        <ion-icon name="close-circle"></ion-icon>
                                    </i>
                                </div>
                            </div>

                            <div class="form-group boxed">
                                <div class="input-wrapper">
                                    <label class="label" for="lihatsurat">Surat Ijin</label>
                                    <?php if(empty($dataijin->file_surat)): ?>
                                        <span class="badge badge-danger">Tidak Ada Surat</span>
                                    <?php else: ?>
                                        <a class="btn btn-info" data-bs-toggle="modal" data-bs-target="#FileSurat<?php echo e($dataijin->unik_ijin); ?>">
                                            <ion-icon name="eye"></ion-icon> Lihat Surat</a>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <?php
                                $path = Storage::url('uploads/file_ijin/'.$dataijin->file_surat);
                            ?>
                            <div class="modal fade dialogbox" id="FileSurat<?php echo e($dataijin->unik_ijin); ?>" data-bs-backdrop="static" tabindex="-1" role="dialog">
                                <div class="modal-dialog" role="document">
                                    <div class="modal-content">
                                        <div class="text-center mt-2">
                                            <span style="color: black;">File Surat</span>
                                            <a href="#" class="btn" data-bs-dismiss="modal" style="float: right;">X</a>
                                        </div>
                                        <div class="pt-3 text-center mb-2">
                                            <img src="<?php echo e(url($path)); ?>" alt="image" class="imaged" style="width: 100%">
                                        </div>
                                        <div class="modal-footer">
                                            <div class="btn-inline">
                                                <a href="#" class="btn" data-bs-dismiss="modal">OK</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group boxed">
                                <div class="input-wrapper">
                                    <label class="label" style="margin-bottom: 0px;" for="file_surat">
                                        <?php if(empty($dataijin->file_surat)): ?>
                                        Upload File Surat (.png/.jpg)
                                        <?php else: ?>
                                        Ganti File Surat (.png/.jpg)
                                        <?php endif; ?>
                                        </label>
                                    <label class="label" style="margin-bottom: 0px; font-size: 10px; color: #FF396F;" for="file_surat">
                                        <?php if(empty($dataijin->file_surat)): ?>
                                        <?php else: ?>
                                        Kosongkan Jika Surat Ijin Tidak Diubah</label>
                                        <?php endif; ?>
                                </div>
                            </div>
                            <div class="custom-file-upload" id="fileUpload1">
                                <input type="file" id="fileuploadInput" name="file_surat" accept=".png, .jpg, .jpeg">
                                <input type="hidden" name="old_file_surat" value="<?php echo e($dataijin->file_surat); ?>">
                                <label for="fileuploadInput">
                                    <span>
                                        <strong>
                                            <ion-icon name="image-outline"></ion-icon>
                                            <i>Pilih File Surat (.png/.jpg)</i>
                                        </strong>
                                    </span>
                                </label>
                            </div>

                            <div class="form-group boxed">
                                <div class="input-wrapper">
                                    <button type="submit" class="btn btn-primary btn-block">
                                        <ion-icon name="send-outline"></ion-icon>
                                        Kirim
                                    </button>
                                </div>
                            </div>

                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <!-- * App Capsule -->

    <!-- App Bottom Menu -->
    <div class="appBottomMenu">
        <a href="/dashboard" class="item">
            <div class="col">
                <ion-icon name="file-tray-full-outline"></ion-icon>
                <strong>Home</strong>
            </div>
        </a>
        <a href="/histori" class="item">
            <div class="col">
                <ion-icon name="list-circle-outline"></ion-icon>
                <strong>Riwayat</strong>
            </div>
        </a>
        <a href="/presensi/create" class="item">
            <div class="col">
                <div class="action-button large">
                    <ion-icon name="finger-print"></ion-icon>
                </div>
            </div>
        </a>
        <a href="/ijin" class="item active">
            <div class="col">
                <ion-icon name="document-text-outline"></ion-icon>
                <strong>Ijin</strong>
            </div>
        </a>
        <a href="/editprofile" class="item">
            <div class="col">
                <ion-icon name="person-outline"></ion-icon>
                <strong>Profil</strong>
            </div>
        </a>
    </div>
    <!-- * App Bottom Menu -->



    <!-- ========= JS Files =========  -->
    <!-- Jquery -->
    <script src="<?php echo e(asset('assets/js/lib/jquery-3.4.1.min.js')); ?>"></script>
    <!-- Bootstrap -->
    <script src="<?php echo e(asset('assets/js/lib/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/lib/popper.min.js')); ?>"></script>
    <!-- Ionicons -->
    <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>
    <!-- Webcam -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/webcamjs/1.0.26/webcam.min.js"></script>
    <!-- Maps -->
    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
    <!-- Splide -->
    <script src="<?php echo e(asset('assets/js/plugins/splide/splide.min.js')); ?>"></script>
    <!-- Owl Carousel -->
    <script src="<?php echo e(asset('assets/js/plugins/owl-carousel/owl.carousel.min.js')); ?>"></script>
    <!-- jQuery Circle Progress -->
    <script src="<?php echo e(asset('assets/js/plugins/jquery-circle-progress/circle-progress.min.js')); ?>"></script>
    <script src="https://cdn.amcharts.com/lib/4/core.js"></script>
    <script src="https://cdn.amcharts.com/lib/4/charts.js"></script>
    <script src="https://cdn.amcharts.com/lib/4/themes/animated.js"></script>
    <!-- SweetAlert -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <!-- Base Js File -->
    <script src="<?php echo e(asset('assets/js/base.js')); ?>"></script>
    <script>
        $(document).ready(function(e){

            function loadjumlahhari() {
                var dari = $("#tgl_ijin_dari").val();
                var sampai = $("#tgl_ijin_sampai").val();
                var date1 = new Date(dari);
                var date2 = new Date(sampai);

                // To calculate the time difference of two dates
                var Difference_In_Time = date2.getTime() - date1.getTime();
                // To calculate the no. of days between two dates
                var Difference_In_Days = Difference_In_Time / (1000 * 3600 *24);

                if (dari == "" || sampai == "") {
                    var jmlhari = 0;
                } else {
                    var jmlhari = Difference_In_Days + 1;
                }
                //To display the final no. of days (result)
                $("#jml_hari").val(jmlhari + " Hari");
            }

            loadjumlahhari();

            $("#tgl_ijin_dari,#tgl_ijin_sampai").change(function(e) {
                loadjumlahhari();
            });


            // $("#tgl_ijin").change(function(e){
            //     var tgl_ijin = $(this).val();
            //     $.ajax({
            //         type:'POST',
            //         url:'/cekpengajuanijin',
            //         data:{
            //             _token:"<?php echo e(csrf_token()); ?>",
            //             tgl_ijin: tgl_ijin
            //         },
            //         cache:false,
            //         success: function(respond){
            //             if(respond == 1) {
            //                 Swal.fire({
            //                     title: 'Maaf!',
            //                     text: 'Ijin Sudah Pernah Diajukan Pada Tanggal Ini!',
            //                     icon: 'warning'
            //                     }).then((result) => {
            //                         $("#tgl_ijin").val("");
            //                     });
            //             }
            //         }
            //     });
            // });

            $("#frmijin").submit(function(){
                var tgl_ijin_dari = $("#tgl_ijin_dari").val();
                var tgl_ijin_sampai = $("#tgl_ijin_sampai").val();
                var keterangan = $("#keterangan").val();
                if(tgl_ijin_dari == '') {
                    Swal.fire({
                        title: 'Maaf!',
                        text: 'Tanggal Mulai Ijin Belum Diisi',
                        icon: 'warning'
                        });
                    return false;
                } else if(tgl_ijin_sampai == '') {
                    Swal.fire({
                        title: 'Maaf!',
                        text: 'Tanggal Akhir Ijin Belum Diisi',
                        icon: 'warning'
                        });
                    return false;
                } else if(keterangan == '') {
                    Swal.fire({
                        title: 'Maaf!',
                        text: 'Keterangan Wajib Diisi',
                        icon: 'warning'
                        });
                    return false;
                }
            });
        });
    </script>

</body>

</html><?php /**PATH D:\BELAJAR\#KUMPULAN SOURCE CODE\PRESENSI GPS LARAVEL\presensigps\resources\views/ijin/edit.blade.php ENDPATH**/ ?>