<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\CabangController;
use App\Http\Controllers\CutiController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\DepartemenController;
use App\Http\Controllers\IjinabsenController;
use App\Http\Controllers\IjincutiController;
use App\Http\Controllers\IjinsakitController;
use App\Http\Controllers\JabatanController;
use App\Http\Controllers\KaryawanController;
use App\Http\Controllers\KonfigurasiController;
use App\Http\Controllers\PresensiController;
use App\Http\Controllers\UserController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return redirect('/login');
});

Route::get('/logintrial', function () {
    return view('auth.logintrial');
});

Route::middleware(['guest:karyawan'])->group(function () {
    Route::get('/login', function () {
        return view('auth.login');
    })->name('login');
    Route::post('/proseslogin', [AuthController::class, 'proseslogin']);
});

Route::middleware(['guest:user'])->group(function () {
    Route::get('/panel', function () {
        return view('auth.loginadmin');
    })->name('loginadmin');
    Route::post('/prosesloginadmin', [AuthController::class, 'prosesloginadmin']);
});

Route::middleware(['auth:karyawan'])->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index']);
    Route::get('/proseslogout', [AuthController::class, 'proseslogout']);

    //Presensi
    Route::get('/presensi/create', [PresensiController::class, 'create']);
    Route::post('presensi/store', [PresensiController::class, 'store']);

    //Edit Profile
    Route::get('/profile', [PresensiController::class, 'profile']);
    Route::get('/editprofile', [PresensiController::class, 'editprofile']);
    Route::post('/presensi/{nik}/updateprofile', [PresensiController::class, 'updateprofile']);

    //Histori
    Route::get('/histori', [PresensiController::class, 'histori']);
    Route::post('/gethistori', [PresensiController::class, 'gethistori']);

    //Lokasi Saya
    Route::get('/lokasisaya', [DashboardController::class, 'lokasisaya']);

    //Ijin/Cuti
    Route::get('/ijin', [PresensiController::class, 'ijin']);
    Route::get('/buatijin', [PresensiController::class, 'buatijin']);
    Route::post('/storeijin', [PresensiController::class, 'storeijin']);
    Route::post('/cekpengajuanijin', [PresensiController::class, 'cekpengajuanijin']);
    //Delete Ijin
    Route::post('/ijin/{unik_ijin}/deleteijin', [PresensiController::class, 'deleteijin']);

    //Ijin Absen
    Route::get('/ijinabsen', [IjinabsenController::class, 'create']);
    Route::post('/ijinabsen/store', [IjinabsenController::class, 'store']);
    Route::get('/ijinabsen/{unik_ijin}/edit', [IjinabsenController::class, 'edit']);
    Route::post('/ijinabsen/{unik_ijin}/update', [IjinabsenController::class, 'update']);

    //Sakit
    Route::get('/ijinsakit', [IjinsakitController::class, 'create']);
    Route::post('/ijinsakit/store', [IjinsakitController::class, 'store']);
    Route::get('/ijinsakit/{unik_ijin}/edit', [IjinsakitController::class, 'edit']);
    Route::post('/ijinsakit/{unik_ijin}/update', [IjinsakitController::class, 'update']);

    //Cuti
    Route::get('/ijincuti', [IjincutiController::class, 'create']);
    Route::post('/ijincuti/store', [IjincutiController::class, 'store']);
    Route::get('/ijincuti/{unik_ijin}/edit', [IjincutiController::class, 'edit']);
    Route::post('/ijincuti/{unik_ijin}/update', [IjincutiController::class, 'update']);

    Route::get('/ijin/{unik_ijin}/showact', [PresensiController::class, 'showact']);
});

Route::middleware(['auth:user'])->group(function () {
    Route::get('/proseslogoutadmin', [AuthController::class, 'proseslogoutadmin']);
    Route::get('/panel/dashboard', [DashboardController::class, 'dashboardadmin']);

    //Karyawan
    Route::get('/panel/karyawan', [KaryawanController::class, 'index']);
    Route::post('/panel/karyawan/store', [KaryawanController::class, 'store']);
    Route::post('/panel/karyawan/ceknik', [KaryawanController::class, 'ceknik']);

    //Import Karyawan
    Route::post('/panel/karyawan/import', [KaryawanController::class, 'import']);

    //Edit Karyawan
    Route::post('/panel/karyawan/edit', [KaryawanController::class, 'edit']);
    Route::post('/panel/karyawan/{id_enc}/update', [KaryawanController::class, 'update']);
    // Delete Karyawan
    Route::post('/panel/karyawan/{id_enc}/delete', [KaryawanController::class, 'delete']);
    //Reset Password
    Route::post('/panel/karyawan/{id_enc}/resetpassword', [KaryawanController::class, 'resetpassword']);

    //Departemen
    Route::get('/panel/departemen', [DepartemenController::class, 'index']);
    Route::post('/tambahdepartemen', [DepartemenController::class, 'tambahdepartemen']);
    //Edit Departemen
    Route::post('/panel/departemen/edit', [DepartemenController::class, 'edit']);
    Route::post('/panel/departemen/{kode_dept}/update', [DepartemenController::class, 'update']);
    //Delete Departemen
    Route::post('/panel/departemen/{kode_dept}/delete', [DepartemenController::class, 'delete']);

    //Jabatan
    Route::get('/panel/jabatan', [JabatanController::class, 'index']);
    Route::post('/tambahjabatan', [JabatanController::class, 'tambahjabatan']);
    //Edit Jabatan
    Route::post('/panel/jabatan/edit', [JabatanController::class, 'edit']);
    Route::post('/panel/jabatan/{id}/update', [JabatanController::class, 'update']);
    //Delete Jabatan
    Route::post('/panel/jabatan/{kode_jab}/delete', [JabatanController::class, 'delete']);

    //Kantor
    Route::get('/panel/kantor', [KonfigurasiController::class, 'lokasikantor']);
    Route::post('/tambahkantor', [KonfigurasiController::class, 'tambahkantor']);
    //Edit Kantor
    Route::post('/panel/kantor/edit', [KonfigurasiController::class, 'edit']);
    Route::post('/panel/kantor/{id}/update', [KonfigurasiController::class, 'update']);
    //Delete Kantor
    Route::post('/panel/kantor/{id}/delete', [KonfigurasiController::class, 'delete']);

    //Kantor Cabang
    Route::get('/panel/cabang', [CabangController::class, 'index']);
    Route::post('/tambahcabang', [CabangController::class, 'tambahcabang']);
    //Edit Kantor Cabang
    Route::post('/panel/cabang/edit', [CabangController::class, 'edit']);
    Route::post('/panel/cabang/{id}/update', [CabangController::class, 'update']);
    //Delete Kantor
    Route::post('/panel/cabang/{id}/delete', [CabangController::class, 'delete']);

    //Cuti
    Route::get('/panel/cuti', [CutiController::class, 'index']);
    Route::post('/tambahcuti', [CutiController::class, 'tambahcuti']);
    Route::post('/panel/cuti/cekkodecuti', [CutiController::class, 'cekkodecuti']);
    //Edit Cuti
    Route::post('/panel/cuti/edit', [CutiController::class, 'edit']);
    Route::post('/panel/cuti/{unik_cuti}/update', [CutiController::class, 'update']);
    //Delete Cuti
    Route::post('/panel/cuti/{unik_cuti}/delete', [CutiController::class, 'delete']);

    //Halaman Approval Ijin/Sakit
    Route::get('/panel/perijinan', [PresensiController::class, 'perijinan']);
    Route::get('/panel/perijinan/cuti', [PresensiController::class, 'perijinancuti']);
    Route::get('/panel/perijinan/{unik_ijin}/detail', [PresensiController::class, 'detailijin']);
    Route::post('/panel/perijinan/{unik_ijin}/approvalijin', [PresensiController::class, 'approvalijin']);
    Route::post('/panel/perijinan/{unik_ijin}/batalkan', [PresensiController::class, 'batalkan']);
    // Route::get('/panel/perijinan/{unik_ijin}/tolak', [PresensiController::class, 'tolak']);

    //Halaman Perijinan Disetujui dan Ditolak
    Route::get('/panel/perijinan/approved', [PresensiController::class, 'approved']);
    Route::get('/panel/perijinan/refused', [PresensiController::class, 'refused']);

    //Monitoring
    Route::get('/panel/monitoring', [PresensiController::class, 'monitoring']);
    Route::post('/getpresensi', [PresensiController::class, 'getpresensi']);
    Route::post('/tampilkanpeta', [PresensiController::class, 'tampilkanpeta']);

    //Laporan
    Route::get('/panel/laporan', [PresensiController::class, 'laporan']);
    Route::post('/panel/cetaklaporan', [PresensiController::class, 'cetaklaporan']);

    //Rekap
    Route::get('/panel/rekap', [PresensiController::class, 'rekap']);
    Route::post('/panel/cetakrekap', [PresensiController::class, 'cetakrekap']);

    //Rekap Ijin
    Route::get('/panel/rekapijin', [PresensiController::class, 'rekapijin']);
    Route::post('/panel/cetakrekapijin', [PresensiController::class, 'cetakrekapijin']);

    //Jam Kerja
    Route::get('/panel/jamkerja', [KonfigurasiController::class, 'jamkerja']);
    Route::post('/tambahjamkerja', [KonfigurasiController::class, 'tambahjamkerja']);
    Route::post('/panel/jamkerja/cekkode', [KonfigurasiController::class, 'cekkode']);
    //Edit Jam Kerja
    Route::post('/panel/jamkerja/edit', [KonfigurasiController::class, 'editjamkerja']);
    Route::post('/panel/jamkerja/{id}/update', [KonfigurasiController::class, 'updatejamkerja']);
    //Delete Jam Kerja
    Route::post('/panel/jamkerja/{id}/delete', [KonfigurasiController::class, 'deletejamkerja']);
    //Set Jam Kerja Karyawan
    Route::get('/panel/konfigurasi/{nik}/setjamkerja', [KonfigurasiController::class, 'setjamkerja']);
    Route::post('/panel/konfigurasi/storesetjamkerja', [KonfigurasiController::class, 'storesetjamkerja']);
    //Update Jam Kerja Karyawan
    Route::post('/panel/konfigurasi/updatesetjamkerja', [KonfigurasiController::class, 'updatesetjamkerja']);

    //Upload Set Jam Kerja
    // Route::get('/panel/uploadsetjamkerja', [KonfigurasiController::class, 'uploadsetjamkerja']);
    // Route::post('/panel/setjamkerja/import', [KonfigurasiController::class, 'import']);

    //Jam Kerja Departemen
    Route::get('/panel/jamkerjadept', [KonfigurasiController::class, 'jamkerjadept']);
    Route::get('/panel/jamkerjadept/create', [KonfigurasiController::class, 'createjamkerjadept']);
    Route::post('/panel/jamkerjadept/store', [KonfigurasiController::class, 'storejamkerjadept']);
    //Edit Jam Kerja Departemen
    Route::get('/panel/jamkerjadept/{kode_jk_dept}/edit', [KonfigurasiController::class, 'editjamkerjadept']);
    Route::post('/panel/jamkerjadept/{kode_jk_dept}/update', [KonfigurasiController::class, 'updatejamkerjadept']);
    //Show Jam Kerja Departemen
    Route::post('/panel/jamkerjadept/show', [KonfigurasiController::class, 'showjamkerjadept']);
    //Delete Jam Kerja Departemen
    Route::get('/panel/jamkerjadept/{kode_jk_dept}/delete', [KonfigurasiController::class, 'deletejamkerjadept']);

    //User
    Route::get('/panel/user', [UserController::class, 'index']);
    Route::get('/panel/profil', [UserController::class, 'profil']);
    Route::post('/panel/user/{id}/updatepassword', [UserController::class, 'updatepassword']);
});
