@include('layouts.admin.header')

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="{{ asset('assets/panel/img/favicon/favicon.ico') }}" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet" />

    <!-- Icons -->
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/fonts/fontawesome.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/fonts/tabler-icons.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/fonts/flag-icons.css') }}" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/css/rtl/core.css') }}" class="template-customizer-core-css" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/css/rtl/theme-default.css') }}" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="{{ asset('assets/panel/css/demo.css') }}" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/perfect-scrollbar/perfect-scrollbar.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/node-waves/node-waves.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/typeahead-js/typeahead.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/animate-css/animate.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/sweetalert2/sweetalert2.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/datatables-bs5/datatables.bootstrap5.css') }}">
    
    <!-- Page CSS -->

    <!-- Helpers -->
    <script src="{{ asset('assets/panel/vendor/js/helpers.js') }}"></script>
    <!-- Template customizer  -->
    <script src="{{ asset('assets/panel/vendor/js/template-customizer.js') }}"></script>
    <!-- Mandatory theme config file  -->
    <script src="{{ asset('assets/panel/js/config.js') }}"></script>
  </head>

  <body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
      <div class="layout-container">
        <!-- Menu -->
        <x-sidebar></x-sidebar>
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page">
          <!-- Navbar -->
          @include('layouts.admin.navbar')
          <!-- / Navbar -->

          <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->

            <div class="container-xxl flex-grow-1 container-p-y">
              <h4 class="fw-bold py-3 mb-4">Data Ijin Ditolak</h4>
              <!-- Hoverable Table rows -->
              <div class="card">
                <div class="card-body">
                    <div class="row mb-2">
                      <div class="col">
                        @php
                            $messagesuccess = Session::get('success');
                            $messageerror = Session::get('error');
                        @endphp
                        @if (Session::get('success'))
                        <div class="alert alert-success alert-dismissible" role="alert" id="timer-alert">
                            {{ $messagesuccess }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                        @endif
                        @if (Session::get('error'))
                        <div class="alert alert-danger alert-dismissible" role="alert" id="timer-alert">
                            {{ $messageerror }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                        @endif
                      </div>
                    </div>
                    <div class="table-responsive text-nowrap">
                      <table id="refused" class="table table-hover" style="width:100%">
                          <thead class="table-light">
                              <tr class="text-nowrap">
                                    <th style="text-align: center;">No.</th>
                                    <th style="text-align: center;">Tanggal</th>
                                    <th style="text-align: center;">Nama Karyawan</th>
                                    <th style="text-align: center;">Status</th>
                                    <th style="text-align: center;">Surat</th>
                                    {{-- <th style="text-align: center;">Detail</th> --}}
                                    <th style="text-align: center;">Status Ijin</th>
                                    <th style="width: 20px; text-align: center;">Aksi</th>
                              </tr>
                          </thead>
                          <tbody class="table-border-bottom-0">
                              @foreach ($refused as $d)
                              <tr>
                                    @php
                                    $path = Storage::url('uploads/file_ijin/'.$d->file_surat);
                                    @endphp
                                    <td style="text-align: center;">{{ $loop->iteration }}.</td>
                                    <td style="text-align: center;">{{ date('d-m-Y',strtotime($d->tgl_ijin)) }}</td>
                                    <td style="text-align: center;">{{ $d->nama_lengkap }}</td>
                                    <td style="text-align: center;">{{ $d->status == "s" ? "Sakit" : ($d->status == "i" ? "Ijin" : "Cuti") }}</td>
                                    <td style="text-align: center;">
                                        @if (empty($d->file_surat))
                                            <span class="text-danger" style="font-size: 12px;">Tidak Ada</span>
                                        @else
                                            <a href="{{ url($path) }}" target="_blank" class="btn btn-success btn-xs rounded-pill"><i class="fe-eye"></i> Lihat Surat</a>
                                        @endif
                                    </td>
                                    {{-- <td style="text-align: center;">
                                        <a href="#" class="detail btn btn-info btn-xs rounded-pill" style="margin-right: 2px" time="{{ $d->time }}"><i class="fe-eye"></i> Detail Ijin</a>
                                    </td> --}}
                                    <td style="text-align: center;">
                                        @if ($d->status_approved == 1)
                                        <span class="badge rounded-pill bg-success">Disetujui</span>
                                        @elseif($d->status_approved == 2)
                                        <span class="badge rounded-pill bg-danger">Ditolak</span>
                                        @else
                                        <span class="badge rounded-pill bg-warning">Pending</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            @if ($d->status_approved == 0)
                                                <a href="/panel/perijinan/{{ $d->time }}/approve" class="btn text-success" style="padding: 0px;" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="Setujui"><i class="ti ti-check ti-xs me-2"></i></a>
                                                <a href="/panel/perijinan/{{ $d->time }}/tolak" class="btn text-danger" style="padding: 0px;" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="Tolak"><i class="ti ti-x ti-xs me-2"></i></a>
                                            @else
                                                <a href="/panel/perijinan/{{ $d->time }}/batalkan" class="btn text-danger" style="padding: 0px;" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="Batalkan"><i class="ti ti-refresh ti-xs me-2"></i></a>
                                            @endif
                                        {{-- <a href="#" class="btn text-primary" style="padding: 0px;" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="Detail"><i class="ti ti-eye ti-xs me-2"></i></a>
                                        <a href="#" class="btn text-success edit" style="padding: 0px;" kode_dept="{{ $d->kode_dept }}" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="Edit"><i class="ti ti-edit ti-xs me-2"></i></a>
                                        <form action="/panel/departemen/{{ $d->kode_dept }}/delete" method="POST">
                                            @csrf
                                            <a class="btn text-danger delete-confirm" style="padding: 0px;" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="Hapus"><i class="ti ti-trash ti-xs"></i></a>
                                        </form> --}}
                                        </div>
                                    </td>
                              </tr>
                              @endforeach
                          </tbody>
                      </table>
                    </div>
                </div>
              </div>
              <!--/ Hoverable Table rows -->

              <!-- Modal Tambah Departemen -->
              <div class="modal fade" id="modal-tambah-departemen" tabindex="-1" aria-hidden="true">
                <div class="modal-dialog modal-sm" role="document">
                  <div class="modal-content">
                    <div class="modal-header">
                      <h5 class="modal-title" id="modalCenterTitle">Tambah Departemen</h5>
                      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                      <form action="/tambahdepartemen" method="POST" id="tbhdept">
                        @csrf
                          <div class="row">
                            <div class="col-6 mb-3">
                              <label for="kode_dept" class="form-label">Kode</label>
                              <input type="text" id="kode_dept" name="kode_dept" class="form-control" placeholder="Kode" />
                            </div>
                          </div>
                          <div class="row">
                            <div class="col mb-3">
                              <label for="nama_dept" class="form-label">Nama Departemen</label>
                              <input type="text" id="nama_dept" name="nama_dept" class="form-control" placeholder="Nama Departemen" />
                            </div>
                          </div>
                          <div class="modal-footer">
                            <button type="button" class="btn btn-label-secondary" data-bs-dismiss="modal">
                              Batal
                            </button>
                            <button type="submit" class="btn btn-primary">Tambah</button>
                          </div>
                      </form>
                    </div>
                  </div>
                </div>
              </div>

              <!-- Modal Edit Departemen -->
              <div class="modal fade" id="modal-edit-departemen" tabindex="-1" aria-hidden="true">
                <div class="modal-dialog modal-sm" role="document">
                  <div class="modal-content">
                    <div class="modal-header">
                      <h5 class="modal-title" id="modalCenterTitle">Edit Departemen</h5>
                      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body" id="loadeditdeptform">
                      
                    </div>
                  </div>
                </div>
              </div>
              
            </div>
            <!-- / Content -->

            <!-- Footer -->
            @include('layouts.admin.footer')
            <!-- / Footer -->

            <div class="content-backdrop fade"></div>
          </div>
          <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
      </div>

      <!-- Overlay -->
      <div class="layout-overlay layout-menu-toggle"></div>

      <!-- Drag Target Area To SlideIn Menu On Small Screens -->
      <div class="drag-target"></div>
    </div>
    <!-- / Layout wrapper -->

    <!-- Core JS -->
    <!-- build:js assets/vendor/js/core.js -->
    <script src="{{ asset('assets/panel/vendor/libs/jquery/jquery.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/libs/popper/popper.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/js/bootstrap.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/libs/perfect-scrollbar/perfect-scrollbar.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/libs/node-waves/node-waves.js') }}"></script>

    <script src="{{ asset('assets/panel/vendor/libs/hammer/hammer.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/libs/i18n/i18n.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/libs/typeahead-js/typeahead.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/libs/datatables-bs5/1.13.6/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/libs/datatables-bs5/datatables-bootstrap5.js') }}"></script>

    <script src="{{ asset('assets/panel/vendor/js/menu.js') }}"></script>
    <!-- endbuild -->

    <!-- Vendors JS -->
    <script src="{{ asset('assets/panel/vendor/libs/sweetalert2/sweetalert2.js') }}"></script>

    <!-- Main JS -->
    <script src="{{ asset('assets/panel/js/main.js') }}"></script>

    <!-- Page JS -->
    <script src="{{ asset('assets/panel/js/extended-ui-sweetalert2.js') }}"></script>

    <script>
      $(function(){
          $("#timer-alert").fadeTo(2000, 500).slideUp(500, function(){
              $("#timer-alert").slideUp(500);
          });

          new DataTable('#refused');
      });
    </script>
</body>
</html>
