<!doctype html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="theme-color" content="#000000">
    <title>Profil Saya</title>
    <meta http-equiv="Cache-Control" content="no-cache" />
    <meta name="description" content="E-Presensi Geolocation">
    <meta name="keywords" content="" />
    <link rel="icon" type="image/png" href="{{ asset('assets/img/favicon.png')}}" sizes="32x32">
    <link rel="apple-touch-icon" sizes="180x180" href="{{ asset('assets/img/icon/192x192.png')}}">
    <link rel="stylesheet" href="{{ asset('assets/css/style.css')}}">
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css"/>
    <link rel="manifest" href="__manifest.json">
</head>

<body>

    <!-- loader -->
    <div id="loader">
        <img src="{{ asset('assets/img/loading-icon.png')}}" alt="icon" class="loading-icon">
    </div>
    <!-- * loader -->

    <!-- App Header -->
    <div class="appHeader">
        <div class="left">
            <a href="/dashboard" class="headerButton goBack">
                <ion-icon name="chevron-back-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">Profil Saya</div>
        <div class="right">
        </div>
    </div>
    <!-- * App Header -->

    <!-- App Capsule -->
    <div id="appCapsule">
        <div class="section full mt-1">
            <div class="col">
                <div class="card">
                    <div class="card-body" style="padding: 10px;">
                        <div class="row mb-3">
                            <div class="text-center">
                                @if (!empty(Auth::guard('karyawan')->user()->foto))
                                @php
                                    $path = Storage::url('uploads/karyawan/'.Auth::guard('karyawan')->user()->foto);
                                @endphp
                                <img src="{{ url($path) }}" alt="image" class="imaged rounded w120">
                                @else
                                <img src="{{ asset('storage/uploads/karyawan/default.png') }}" alt="image" class="imaged rounded w120">
                                @endif
                            </div>
                        </div>
                            @php
                            $messagesuccess = Session::get('success');
                            $messageerror = Session::get('error');
                            @endphp
                            @if (Session::get('success'))
                            <div class="alert alert-info alert-dismissible fade show mb-1" role="alert" id="timer-alert">
                                {{ $messagesuccess }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                            @endif
                            @if (Session::get('error'))
                            <div class="alert alert-danger alert-dismissible fade show mb-1" role="alert" id="timer-alert">
                                {{ $messageerror }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                            @endif
                            <?php
                                function tanggal_indo($tgl)
                                {
                                    $bulan = array (
                                    1 =>   'Januari',
                                    'Februari',
                                    'Maret',
                                    'April',
                                    'Mei',
                                    'Juni',
                                    'Juli',
                                    'Agustus',
                                    'September',
                                    'Oktober',
                                    'November',
                                    'Desember'
                                    );
                                    $pecah = explode('-', $tgl);
                                    return $pecah[2] . ' ' . $bulan[ (int)$pecah[1] ] . ' ' . $pecah[0]; 
                                }
                            ?>
                        <ul class="listview image-listview">
                            <li>
                                <div class="item">
                                    <div class="in">
                                        <span class="text-muted">NIK</span>
                                        <div>{{ $karyawan->nik }}</div>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="item">
                                    <div class="in">
                                        <span class="text-muted">Nama</span>
                                        <div>{{ $karyawan->nama_lengkap }}</div>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="item">
                                    <div class="in">
                                        <span class="text-muted">Tanggal Lahir</span>
                                        <div>{{ tanggal_indo($karyawan->tgl_lahir) }}</div>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="item">
                                    <div class="in">
                                        <span class="text-muted">No. HP</span>
                                        <div>{{ $karyawan->no_hp }}</div>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="item">
                                    <div class="in">
                                        <span class="text-muted">Email</span>
                                        <div>{{ $karyawan->email }}</div>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="form-group boxed">
                    <div class="input-wrapper">
                        <a href="/editprofile" type="button" class="btn btn-danger btn-block">
                            <ion-icon name="create-outline"></ion-icon>
                            Edit Profil
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- * App Capsule -->

    <!-- App Bottom Menu -->
    <div class="appBottomMenu">
        <a href="/dashboard" class="item">
            <div class="col">
                <ion-icon name="file-tray-full-outline"></ion-icon>
                <strong>Home</strong>
            </div>
        </a>
        <a href="/histori" class="item">
            <div class="col">
                <ion-icon name="list-circle-outline"></ion-icon>
                <strong>Riwayat</strong>
            </div>
        </a>
        <a href="/presensi/create" class="item">
            <div class="col">
                <div class="action-button large">
                    <ion-icon name="finger-print"></ion-icon>
                </div>
            </div>
        </a>
        <a href="/ijin" class="item">
            <div class="col">
                <ion-icon name="document-text-outline"></ion-icon>
                <strong>Ijin</strong>
            </div>
        </a>
        <a href="/profile" class="item active">
            <div class="col">
                <ion-icon name="person-outline"></ion-icon>
                <strong>Profil</strong>
            </div>
        </a>
    </div>
    <!-- * App Bottom Menu -->



    <!-- ========= JS Files =========  -->
    <!-- Jquery -->
    <script src="{{asset('assets/js/lib/jquery-3.4.1.min.js')}}"></script>
    <!-- Bootstrap -->
    <script src="{{asset('assets/js/lib/bootstrap.bundle.min.js')}}"></script>
    <script src="{{asset('assets/js/lib/popper.min.js')}}"></script>
    <!-- Ionicons -->
    <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>
    <!-- Webcam -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/webcamjs/1.0.26/webcam.min.js"></script>
    <!-- Maps -->
    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
    <!-- Splide -->
    <script src="{{asset('assets/js/plugins/splide/splide.min.js')}}"></script>
    <!-- Owl Carousel -->
    <script src="{{asset('assets/js/plugins/owl-carousel/owl.carousel.min.js')}}"></script>
    <!-- jQuery Circle Progress -->
    <script src="{{asset('assets/js/plugins/jquery-circle-progress/circle-progress.min.js')}}"></script>
    <script src="https://cdn.amcharts.com/lib/4/core.js"></script>
    <script src="https://cdn.amcharts.com/lib/4/charts.js"></script>
    <script src="https://cdn.amcharts.com/lib/4/themes/animated.js"></script>
    <!-- SweetAlert -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <!-- Base Js File -->
    <script src="{{asset('assets/js/base.js')}}"></script>

    <script>
        $(function(){
            $("#timer-alert").fadeTo(2000, 500).slideUp(500, function(){
                $("#timer-alert").slideUp(500);
            });
        });
      </script>

</body>

</html>