@include('layouts.admin.header')

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="{{ asset('assets/panel/img/favicon/favicon.ico') }}" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet" />

    <!-- Icons -->
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/fonts/fontawesome.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/fonts/tabler-icons.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/fonts/flag-icons.css') }}" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/css/rtl/core.css') }}" class="template-customizer-core-css" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/css/rtl/theme-default.css') }}" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="{{ asset('assets/panel/css/demo.css') }}" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/perfect-scrollbar/perfect-scrollbar.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/node-waves/node-waves.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/typeahead-js/typeahead.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/animate-css/animate.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/sweetalert2/sweetalert2.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/datatables-bs5/datatables.bootstrap5.css') }}">
    
    <!-- Page CSS -->
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/bootstrap-datepicker/bootstrap-datepicker.css') }}" />

    <!-- Helpers -->
    <script src="{{ asset('assets/panel/vendor/js/helpers.js') }}"></script>
    <!-- Template customizer  -->
    <script src="{{ asset('assets/panel/vendor/js/template-customizer.js') }}"></script>
    <!-- Mandatory theme config file  -->
    <script src="{{ asset('assets/panel/js/config.js') }}"></script>
  </head>

  <body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
      <div class="layout-container">
        <!-- Menu -->
        <x-sidebar></x-sidebar>
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page">
          <!-- Navbar -->
          @include('layouts.admin.navbar')
          <!-- / Navbar -->

          <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->

            <div class="container-xxl flex-grow-1 container-p-y">
              <h4 class="fw-bold py-3 mb-4">Data Ijin/Sakit/Cuti</h4>
              <!-- Hoverable Table rows -->
              <div class="card">
                <div class="card-body">
                    <div class="row mb-2">
                      <div class="col">
                        @php
                            $messagesuccess = Session::get('success');
                            $messageerror = Session::get('error');
                        @endphp
                        @if (Session::get('success'))
                        <div class="alert alert-success alert-dismissible" role="alert" id="timer-alert">
                            {{ $messagesuccess }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                        @endif
                        @if (Session::get('error'))
                        <div class="alert alert-danger alert-dismissible" role="alert" id="timer-alert">
                            {{ $messageerror }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                        @endif
                      </div>
                    </div>
                    <div class="table-responsive text-nowrap">
                      <table id="perijinan" class="table table-hover" style="width:100%">
                          <thead class="table-light">
                              <tr class="text-nowrap">
                                    <th style="text-align: center;">No.</th>
                                    <th style="text-align: center;">Tanggal</th>
                                    <th style="text-align: center;">Nama Karyawan</th>
                                    <th style="text-align: center;">Status</th>
                                    <th style="text-align: center;">Surat</th>
                                    {{-- <th style="text-align: center;">Detail</th> --}}
                                    <th style="text-align: center;">Status Ijin</th>
                                    <th style="width: 20px; text-align: center;">Aksi</th>
                              </tr>
                          </thead>
                          <tbody class="table-border-bottom-0">
                              @foreach ($perijinan as $d)
                              <tr>
                                    @php
                                    $path = Storage::url('uploads/file_ijin/'.$d->file_surat);
                                    @endphp
                                    <td style="text-align: center;">{{ $loop->iteration }}.</td>
                                    <td style="text-align: center;">{{ date('d-m-Y',strtotime($d->tgl_ijin_dari)) }} s/d {{ date('d-m-Y',strtotime($d->tgl_ijin_sampai)) }}</td>
                                    <td style="text-align: center;">{{ $d->nama_lengkap }}</td>
                                    <td style="text-align: center;">{{ $d->status == "s" ? "Sakit" : ($d->status == "i" ? "Ijin" : "Cuti") }}</td>
                                    <td style="text-align: center;">
                                        @if (empty($d->file_surat))
                                            <span class="text-danger" style="font-size: 12px;">Tidak Ada</span>
                                        @else
                                            <a href="{{ url($path) }}" target="_blank" class="btn btn-info btn-xs rounded-pill"><i class="ti ti-eye me-1" style="font-size: 10px;"></i>View</a>
                                        @endif
                                    </td>
                                    <td style="text-align: center;">
                                        @if ($d->status_approved == 1)
                                        <span class="badge rounded-pill bg-success" style="font-size: 10px;">Disetujui</span>
                                        @elseif($d->status_approved == 2)
                                        <span class="badge rounded-pill bg-danger" style="font-size: 10px;">Ditolak</span>
                                        @else
                                        <span class="badge rounded-pill bg-warning" style="font-size: 10px;">Pending</span>
                                        @endif
                                    </td>
                                    <td style="text-align: center;">
                                      @if ($d->status_approved == 0)
                                        <a href="/panel/perijinan/{{ $d->unik_ijin }}/detail" class="btn btn-info btn-xs rounded-pill"><i class="ti ti-edit-circle me-1" style="font-size: 10px;"></i>Aksi</a>
                                      @else
                                        <form action="/panel/perijinan/{{ $d->unik_ijin }}/batalkan" method="POST">
                                          @csrf
                                          <button class="btn btn-danger btn-xs rounded-pill batal-confirm" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="Batalkan"><i class="ti ti-rotate me-1" style="font-size: 10px;"></i>Batal</button>
                                        </form>
                                      @endif
                                    </td>
                              </tr>
                              @endforeach
                          </tbody>
                      </table>
                    </div>
                </div>
              </div>
              <!--/ Hoverable Table rows -->

              

            </div>
            <!-- / Content -->

            <!-- Footer -->
            @include('layouts.admin.footer')
            <!-- / Footer -->

            <div class="content-backdrop fade"></div>
          </div>
          <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
      </div>

      <!-- Overlay -->
      <div class="layout-overlay layout-menu-toggle"></div>

      <!-- Drag Target Area To SlideIn Menu On Small Screens -->
      <div class="drag-target"></div>
    </div>
    <!-- / Layout wrapper -->

    <!-- Core JS -->
    <!-- build:js assets/vendor/js/core.js -->
    <script src="{{ asset('assets/panel/vendor/libs/jquery/jquery.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/libs/popper/popper.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/js/bootstrap.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/libs/perfect-scrollbar/perfect-scrollbar.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/libs/node-waves/node-waves.js') }}"></script>

    <script src="{{ asset('assets/panel/vendor/libs/hammer/hammer.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/libs/i18n/i18n.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/libs/typeahead-js/typeahead.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/libs/datatables-bs5/1.13.6/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/libs/datatables-bs5/datatables-bootstrap5.js') }}"></script>

    <script src="{{ asset('assets/panel/vendor/js/menu.js') }}"></script>
    <!-- endbuild -->

    <!-- Vendors JS -->
    <script src="{{ asset('assets/panel/vendor/libs/sweetalert2/sweetalert2.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/libs/bootstrap-datepicker/bootstrap-datepicker.js') }}"></script>

    <!-- Main JS -->
    <script src="{{ asset('assets/panel/js/main.js') }}"></script>

    <!-- Page JS -->
    <script src="{{ asset('assets/panel/js/extended-ui-sweetalert2.js') }}"></script>

    <script>
      $(function(){
          $("#timer-alert").fadeTo(2000, 500).slideUp(500, function(){
              $("#timer-alert").slideUp(500);
          });

          $("#tgl_ijin_dari").datepicker({ 
              autoclose: true,
              odayHighlight: true,
              format: 'yyyy-mm-dd'
          });

          $("#tgl_ijin_sampai").datepicker({ 
              autoclose: true,
              odayHighlight: true,
              format: 'yyyy-mm-dd'
          });

          new DataTable('#perijinan');

          $(".detailijin").click(function(){
              var unik_ijin = $(this).attr('unik_ijin');
              $.ajax({
                  type:'POST',
                  url:'/panel/perijinan/detail',
                  cache:false,
                  data:{
                      _token:"{{ csrf_token(); }}",
                      unik_ijin:unik_ijin
                  },
                  success:function(respond){
                      $("#loaddetailijin").html(respond);
                  }
              });
              $("#modal-detail-ijin").modal("show");
          });

          $(".batal-confirm").click(function(e) {
              var form = $(this).closest('form');
              e.preventDefault();
              Swal.fire({
                  title: 'Anda Yakin?',
                  text: "Perijinan ini akan dibatalkan?",
                  icon: 'warning',
                  showCancelButton: true,
                  confirmButtonColor: '#6658dd',
                  cancelButtonColor: '#f1556c',
                  cancelButtonText: 'Batal',
                  confirmButtonText: 'Ya, Batalkan'
                  }).then((result) => {
                  if (result.isConfirmed) {
                      form.submit();
                  }
                  });
                  return false;
          });
      });
    </script>
</body>
</html>
