@if ($histori->isEmpty())
    <div class="alert alert-warning alert-dismissible fade show" role="alert" style="margin-bottom: 0px;">
        Tidak Ada Data
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
@endif
@foreach ($histori as $d)
<ul class="listview image-listview">
    <li>
        <div class="item" style="padding: 0px">
            @if ($d->status == "h")
                <div class="icon-box bg-primary">
                    <ion-icon name="finger-print-outline"></ion-icon>
                </div>
            @elseif($d->status == "i")
                <div class="icon-box bg-info">
                    <ion-icon name="document-text-outline"></ion-icon>
                </div>
            @elseif($d->status == "s")
                <div class="icon-box bg-danger">
                    <ion-icon name="medkit-outline"></ion-icon>
                </div>
            @elseif($d->status == "c")
                <div class="icon-box bg-warning">
                    <ion-icon name="calendar-outline"></ion-icon>
                </div>
            @endif
            <div class="in">
                <div style="line-height: 0.8rem">
                    {{ date("d-m-Y",strtotime($d->tgl_presensi)) }}
                </div>
                <div>
                    @if ($d->status == "h")
                        <span class="badge {{ $d->jam_in < $d->jam_masuk_akhir ? "badge-info" : "badge-warning" }}">{{ $d->jam_in }}</span>
                        <span class="badge badge-danger">{{ $d->jam_out != null ? $d->jam_out : 'Belum Absen' }}</span>
                    @else
                        <span class="badge badge-primary">{{ $d->status == "s" ? "Sakit" : ($d->status == "i" ? "Ijin" : "Cuti") }}</span>
                    @endif
                </div>
            </div>
        </div>
    </li>    
</ul>
@endforeach