<!doctype html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="theme-color" content="#000000">
    <title>Edit Profil</title>
    <meta http-equiv="Cache-Control" content="no-cache" />
    <meta name="description" content="E-Presensi Geolocation">
    <meta name="keywords" content="" />
    <link rel="icon" type="image/png" href="{{ asset('assets/img/favicon.png')}}" sizes="32x32">
    <link rel="apple-touch-icon" sizes="180x180" href="{{ asset('assets/img/icon/192x192.png')}}">
    <link rel="stylesheet" href="{{ asset('assets/css/style.css')}}">
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css"/>
    <link rel="manifest" href="__manifest.json">
</head>

<body>

    <!-- loader -->
    <div id="loader">
        <img src="{{ asset('assets/img/loading-icon.png')}}" alt="icon" class="loading-icon">
    </div>
    <!-- * loader -->

    <!-- App Header -->
    <div class="appHeader">
        <div class="left">
            <a href="/profile" class="headerButton goBack">
                <ion-icon name="chevron-back-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">Edit Profil</div>
        <div class="right">
        </div>
    </div>
    <!-- * App Header -->

    <!-- App Capsule -->
    <div id="appCapsule">
        <div class="section full mt-1">
            <div class="col">
                @php
                    $messagesuccess = Session::get('success');
                    $messageerror = Session::get('error');
                @endphp
                @if (Session::get('success'))
                <div class="alert alert-info alert-dismissible fade show mb-1" role="alert">
                    {{ $messagesuccess }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                @endif
                @if (Session::get('error'))
                <div class="alert alert-danger alert-dismissible fade show mb-1" role="alert">
                    {{ $messageerror }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                @endif
            <div class="card">
                <div class="card-body" style="padding: 10px;">
                    <form action="/presensi/{{ $karyawan->nik }}/updateprofile" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="form-group boxed">
                            <div class="input-wrapper">
                                <label class="label" for="nama_lengkap">Nama Lengkap</label>
                                <input type="text" class="form-control" value="{{ $karyawan->nama_lengkap }}" id="nama_lengkap" name="nama_lengkap" placeholder="Nama Lengkap" autocomplete="off">
                                <i class="clear-input">
                                    <ion-icon name="close-circle"></ion-icon>
                                </i>
                            </div>
                        </div>

                        <div class="form-group boxed">
                            <div class="input-wrapper">
                                <label class="label" for="tgl_lahir">Tanggal Lahir</label>
                                <input type="date" class="form-control" value="{{ $karyawan->tgl_lahir }}" id="tgl_lahir" name="tgl_lahir">
                                <i class="clear-input">
                                    <ion-icon name="close-circle"></ion-icon>
                                </i>
                            </div>
                        </div>

                        <div class="form-group boxed">
                            <div class="input-wrapper">
                                <label class="label" for="no_hp">No. Whatsapp</label>
                                <input type="number" class="form-control" value="{{ $karyawan->no_hp }}" id="no_hp" name="no_hp" placeholder="No. Whatsapp" autocomplete="off">
                                <i class="clear-input">
                                    <ion-icon name="close-circle"></ion-icon>
                                </i>
                            </div>
                        </div>

                        <div class="form-group boxed">
                            <div class="input-wrapper">
                                <label class="label" for="email">E-mail</label>
                                <input type="email" class="form-control" value="{{ $karyawan->email }}" id="email" name="email" placeholder="Email" autocomplete="off" >
                                <i class="clear-input">
                                    <ion-icon name="close-circle"></ion-icon>
                                </i>
                            </div>
                        </div>

                        <div class="form-group boxed">
                            <div class="input-wrapper">
                                <label class="label" for="password">Password</label>
                                <input type="password" autocomplete="off" class="form-control" id="password" name="password"
                                    placeholder="Password">
                                <i class="clear-input">
                                    <ion-icon name="close-circle"></ion-icon>
                                </i>
                            </div>
                        </div>

                        <div class="form-group boxed">
                            <div class="input-wrapper">
                                <label class="label" style="margin-bottom: 0px;" for="foto">Ubah Foto Profil</label>
                            </div>
                        </div>
                        <div class="custom-file-upload" id="fileUpload1">
                            <input type="file" id="fileuploadInput" name="foto" accept=".png, .jpg, .jpeg">
                            <input type="hidden" name="old_foto" value="{{ $karyawan->foto }}">
                            <label for="fileuploadInput">
                                <span>
                                    <strong>
                                        <ion-icon name="camera-outline"></ion-icon>
                                        <i>Pilih Foto Profil</i>
                                    </strong>
                                </span>
                            </label>
                        </div>

                        <div class="form-group boxed">
                            <div class="input-wrapper">
                                <button type="submit" class="btn btn-success btn-block">
                                    <ion-icon name="save-outline"></ion-icon>
                                    Simpan
                                </button>
                            </div>
                        </div>

                    </form>

                </div>
            </div>
            </div>
        </div>
    </div>
    <!-- * App Capsule -->

    <!-- App Bottom Menu -->
    <div class="appBottomMenu">
        <a href="/dashboard" class="item">
            <div class="col">
                <ion-icon name="file-tray-full-outline"></ion-icon>
                <strong>Home</strong>
            </div>
        </a>
        <a href="/histori" class="item">
            <div class="col">
                <ion-icon name="list-circle-outline"></ion-icon>
                <strong>Riwayat</strong>
            </div>
        </a>
        <a href="/presensi/create" class="item">
            <div class="col">
                <div class="action-button large">
                    <ion-icon name="finger-print"></ion-icon>
                </div>
            </div>
        </a>
        <a href="/ijin" class="item">
            <div class="col">
                <ion-icon name="document-text-outline"></ion-icon>
                <strong>Ijin</strong>
            </div>
        </a>
        <a href="/profile" class="item active">
            <div class="col">
                <ion-icon name="person-outline"></ion-icon>
                <strong>Profil</strong>
            </div>
        </a>
    </div>
    <!-- * App Bottom Menu -->



    <!-- ========= JS Files =========  -->
    <!-- Jquery -->
    <script src="{{asset('assets/js/lib/jquery-3.4.1.min.js')}}"></script>
    <!-- Bootstrap -->
    <script src="{{asset('assets/js/lib/bootstrap.bundle.min.js')}}"></script>
    <script src="{{asset('assets/js/lib/popper.min.js')}}"></script>
    <!-- Ionicons -->
    <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>
    <!-- Webcam -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/webcamjs/1.0.26/webcam.min.js"></script>
    <!-- Maps -->
    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
    <!-- Splide -->
    <script src="{{asset('assets/js/plugins/splide/splide.min.js')}}"></script>
    <!-- Owl Carousel -->
    <script src="{{asset('assets/js/plugins/owl-carousel/owl.carousel.min.js')}}"></script>
    <!-- jQuery Circle Progress -->
    <script src="{{asset('assets/js/plugins/jquery-circle-progress/circle-progress.min.js')}}"></script>
    <script src="https://cdn.amcharts.com/lib/4/core.js"></script>
    <script src="https://cdn.amcharts.com/lib/4/charts.js"></script>
    <script src="https://cdn.amcharts.com/lib/4/themes/animated.js"></script>
    <!-- SweetAlert -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <!-- Base Js File -->
    <script src="{{asset('assets/js/base.js')}}"></script>

</body>

</html>