@include('layouts.admin.header')

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="{{ asset('assets/panel/img/favicon/favicon.ico') }}" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet" />

    <!-- Icons -->
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/fonts/fontawesome.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/fonts/tabler-icons.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/fonts/flag-icons.css') }}" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/css/rtl/core.css') }}" class="template-customizer-core-css" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/css/rtl/theme-default.css') }}" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="{{ asset('assets/panel/css/demo.css') }}" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/perfect-scrollbar/perfect-scrollbar.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/node-waves/node-waves.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/typeahead-js/typeahead.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/animate-css/animate.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/sweetalert2/sweetalert2.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/datatables-bs5/datatables.bootstrap5.css') }}">
    
    <!-- Page CSS -->
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/bootstrap-datepicker/bootstrap-datepicker.css') }}" />

    <!-- Helpers -->
    <script src="{{ asset('assets/panel/vendor/js/helpers.js') }}"></script>
    <!-- Template customizer  -->
    <script src="{{ asset('assets/panel/vendor/js/template-customizer.js') }}"></script>
    <!-- Mandatory theme config file  -->
    <script src="{{ asset('assets/panel/js/config.js') }}"></script>
  </head>

  <body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
      <div class="layout-container">
        <!-- Menu -->
        <x-sidebar></x-sidebar>
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page">
          <!-- Navbar -->
          @include('layouts.admin.navbar')
          <!-- / Navbar -->

          <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->

            <div class="container-xxl flex-grow-1 container-p-y">
              <h4 class="fw-bold py-3 mb-4">Detail {{ $detailijin->status == "s" ? "Ijin Sakit" : ($detailijin->status == "i" ? "Ijin" : "Ijin Cuti") }} {{ $detailijin->nama_lengkap }}</h4>
              <!-- Hoverable Table rows -->
              <div class="card">
                <div class="card-body">
                    <div class="row mb-2">
                      <div class="col">
                        @php
                            $messagesuccess = Session::get('success');
                            $messageerror = Session::get('error');
                        @endphp
                        @if (Session::get('success'))
                        <div class="alert alert-success alert-dismissible" role="alert" id="timer-alert">
                            {{ $messagesuccess }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                        @endif
                        @if (Session::get('error'))
                        <div class="alert alert-danger alert-dismissible" role="alert" id="timer-alert">
                            {{ $messageerror }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                        @endif
                      </div>
                    </div>
                    <div class="row mb-2">
                        <div class="col">
                            <a href="/panel/perijinan" class="btn btn-primary waves-effect waves-light">Kembali</a>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-6">
                            @php
                                $path = Storage::url('uploads/file_ijin/'.$detailijin->file_surat);
                            @endphp
                            <table class="table">
                                <thead>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td style="width: 40%">NIK</td>
                                        <td style="width: 10%">:</td>
                                        <td>{{ $detailijin->nik }}</td>
                                    </tr>
                                    <tr>
                                        <td style="width: 40%">Nama Karyawan</td>
                                        <td style="width: 10%">:</td>
                                        <td>{{ $detailijin->nama_lengkap }}</td>
                                    </tr>
                                    <tr>
                                        <td style="width: 40%">Jabatan</td>
                                        <td style="width: 10%">:</td>
                                        <td>{{ $detailijin->nama_jab }}</td>
                                    </tr>
                                    <tr>
                                        <td style="width: 40%">Jenis Ijin</td>
                                        <td style="width: 10%">:</td>
                                        <td>{{ $detailijin->status == "s" ? "Sakit" : ($detailijin->status == "i" ? "Ijin" : "Cuti") }}</td>
                                    </tr>
                                    @if ($detailijin->status == "c")
                                        <tr>
                                            <td style="width: 40%">Jenis Cuti</td>
                                            <td style="width: 10%">:</td>
                                            <td>
                                                <span class="badge bg-info">{{ $cuti->nama_cuti }}</span>
                                            </td>
                                        </tr>
                                    @endif
                                    <tr>
                                        <td style="width: 40%">Keterangan</td>
                                        <td style="width: 10%">:</td>
                                        <td>{{ $detailijin->keterangan }}</td>
                                    </tr>
                                    <tr>
                                        <td style="width: 40%">File Surat</td>
                                        <td style="width: 10%">:</td>
                                        <td>
                                            @if (empty($detailijin->file_surat))
                                                <span class="badge bg-danger">Tidak Ada</span>
                                            @else
                                                <a href="{{ url($path) }}" target="_blank" class="btn btn-success btn-xs rounded-pill"><i class="ti ti-eye me-1" style="font-size: 10px;"></i>Lihat Surat</a>
                                            @endif
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="width: 40%">Status Ijin</td>
                                        <td style="width: 10%">:</td>
                                        <td>
                                            @if ($detailijin->status_approved == 1)
                                                <span class="badge bg-success">Disetujui</span>
                                            @elseif($detailijin->status_approved == 2)
                                                <span class="badge bg-danger">Ditolak</span>
                                            @else
                                                <span class="badge bg-warning">Pending</span>
                                            @endif
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="col-6">
                            <table class="table">
                                <thead>
                                </thead>
                                <tbody>
                                    <form action="/panel/perijinan/{{ $detailijin->unik_ijin }}/approvalijin" method="post">
                                        @csrf
                                        <tr>
                                            <input type="hidden" class="form-control" name="nik" value="{{ $detailijin->nik }}" readonly>
                                            <input type="hidden" class="form-control" name="status" value="{{ $detailijin->status }}" readonly>
                                            <td style="width: 40%">Dari Tanggal</td>
                                            <td style="width: 10%">:</td>
                                            <td><input type="text" name="tgl_ijin_dari" id="tgl_ijin_dari" class="form-control date" value="{{ $detailijin->tgl_ijin_dari }}" readonly></td>
                                        </tr>
                                        <tr>
                                            <td style="width: 40%">Sampai Tanggal</td>
                                            <td style="width: 10%">:</td>
                                            <td><input type="text" name="tgl_ijin_sampai" id="tgl_ijin_sampai" class="form-control date" value="{{ $detailijin->tgl_ijin_sampai }}"></td>
                                        </tr>
                                        <tr>
                                            <td style="width: 40%">Jumlah Hari</td>
                                            <td style="width: 10%">:</td>
                                            <td><input type="text" class="form-control" id="jml_hari" readonly></td>
                                        </tr>
                                        <tr>
                                            <td style="width: 40%">Aksi</td>
                                            <td style="width: 10%">:</td>
                                            <td>
                                                <select name="status_approve" id="status_approve" class="form-select">
                                                    <option value="">--- Pilih ---</option>
                                                    <option value="1">Disetujui</option>
                                                    <option value="2">Ditolak</option>
                                                </select>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td colspan="3">
                                                <div class="d-grid mx-auto">
                                                    <button class="btn btn-primary" type="submit">Simpan</button>
                                                </div>
                                            </td>
                                        </tr>
                                    </form>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
              </div>
              <!--/ Hoverable Table rows -->

              
              
            </div>
            <!-- / Content -->

            <!-- Footer -->
            @include('layouts.admin.footer')
            <!-- / Footer -->

            <div class="content-backdrop fade"></div>
          </div>
          <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
      </div>

      <!-- Overlay -->
      <div class="layout-overlay layout-menu-toggle"></div>

      <!-- Drag Target Area To SlideIn Menu On Small Screens -->
      <div class="drag-target"></div>
    </div>
    <!-- / Layout wrapper -->

    <!-- Core JS -->
    <!-- build:js assets/vendor/js/core.js -->
    <script src="{{ asset('assets/panel/vendor/libs/jquery/jquery.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/libs/popper/popper.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/js/bootstrap.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/libs/perfect-scrollbar/perfect-scrollbar.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/libs/node-waves/node-waves.js') }}"></script>

    <script src="{{ asset('assets/panel/vendor/libs/hammer/hammer.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/libs/i18n/i18n.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/libs/typeahead-js/typeahead.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/libs/datatables-bs5/1.13.6/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/libs/datatables-bs5/datatables-bootstrap5.js') }}"></script>

    <script src="{{ asset('assets/panel/vendor/js/menu.js') }}"></script>
    <!-- endbuild -->

    <!-- Vendors JS -->
    <script src="{{ asset('assets/panel/vendor/libs/sweetalert2/sweetalert2.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/libs/bootstrap-datepicker/bootstrap-datepicker.js') }}"></script>

    <!-- Main JS -->
    <script src="{{ asset('assets/panel/js/main.js') }}"></script>

    <!-- Page JS -->
    <script src="{{ asset('assets/panel/js/extended-ui-sweetalert2.js') }}"></script>

    <script>
      $(function(){
          $("#timer-alert").fadeTo(2000, 500).slideUp(500, function(){
              $("#timer-alert").slideUp(500);
          });

          $("#tgl_ijin_sampai").datepicker({ 
              autoclose: true,
              odayHighlight: true,
              format: 'yyyy-mm-dd'
          });

          new DataTable('#perijinan');

          $(".detailijin").click(function(){
              var unik_ijin = $(this).attr('unik_ijin');
              $.ajax({
                  type:'POST',
                  url:'/panel/perijinan/detail',
                  cache:false,
                  data:{
                      _token:"{{ csrf_token(); }}",
                      unik_ijin:unik_ijin
                  },
                  success:function(respond){
                      $("#loaddetailijin").html(respond);
                  }
              });
              $("#modal-detail-ijin").modal("show");
          });
      });

      $(document).ready(function(e){

        function loadjumlahhari() {
            var dari = $("#tgl_ijin_dari").val();
            var sampai = $("#tgl_ijin_sampai").val();
            var date1 = new Date(dari);
            var date2 = new Date(sampai);

            // To calculate the time difference of two dates
            var Difference_In_Time = date2.getTime() - date1.getTime();
            // To calculate the no. of days between two dates
            var Difference_In_Days = Difference_In_Time / (1000 * 3600 *24);

            if (dari == "" || sampai == "") {
                var jmlhari = 0;
            } else {
                var jmlhari = Difference_In_Days + 1;
            }
            //To display the final no. of days (result)
            $("#jml_hari").val(jmlhari + " Hari");
        }

        loadjumlahhari();

        $("#tgl_ijin_dari,#tgl_ijin_sampai").change(function(e) {
            loadjumlahhari();
        });
      });
    </script>
</body>
</html>
