<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <title>Cetak Rekap Presensi Karyawan</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/normalize/7.0.0/normalize.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/paper-css/0.4.1/paper.css">
  <style>
      @page {
        size: A4
      }
      h3 {
        font-family: Arial, Helvetica, sans-serif
      }
      span {
        font-family: Arial, Helvetica, sans-serif
      }
      .tabeldatakaryawan {
        margin-top: 30px;
        font-family: Arial, Helvetica, sans-serif;
        font-size: 14px;
      }
      .tabeldatakaryawan td {
        padding: 5px;
      }
      .tabelpresensi {
        width: 100%;
        margin-top: 20px;
        font-family: Arial, Helvetica, sans-serif;
        font-size: 10px;
        border-collapse: collapse;
      }
      .tabelpresensi tr th {
        border: 1px solid #000000;
        padding: 8px;
        background-color: #e2e2e2;
      }
      .tabelpresensi tr td {
        border: 1px solid #000000;
        padding: 2px;
      }
      .tandatangan {
        width: 100%;
        font-family: Arial, Helvetica, sans-serif;
        font-size: 14px;
        margin-top: 20px;
      }
  </style>
</head>

<body class="A4 landscape">
  @php
    //Function Untuk Menghitung Selisih Jam
    function selisih($jam_masuk, $jam_keluar)
            {
                list($h, $m, $s) = explode(":", $jam_masuk);
                $dtAwal = mktime($h, $m, $s, "1", "1", "1");
                list($h, $m, $s) = explode(":", $jam_keluar);
                $dtAkhir = mktime($h, $m, $s, "1", "1", "1");
                $dtSelisih = $dtAkhir - $dtAwal;
                $totalmenit = $dtSelisih / 60;
                $jam = explode(".", $totalmenit / 60);
                $sisamenit = ($totalmenit / 60) - $jam[0];
                $sisamenit2 = $sisamenit * 60;
                $jml_jam = $jam[0];
                return $jml_jam . ":" . round($sisamenit2);
            }
  @endphp
  
  <section class="sheet padding-10mm">

    <table style="width: 100%">
      <tr>
        <td>
          <h3 style="margin-block-end: 0em;">
            LAPORAN PRESENSI KARYAWAN <br>
            PERIODE {{ strtoupper($namabulan[$bulan]) }} {{ $tahun }} <br>
            AL AMIEN JEMBER <br>
          </h3>
          <span>Jl. K. Masduqi Kebonsari Ambulu Jember</span>
        </td>
      </tr>
    </table>

    <table class="tabelpresensi">
      <tr>
        <th rowspan="2">No.</th>
        <th rowspan="2">NIK</th>
        <th rowspan="2">Nama Karyawan</th>
        <th colspan="31">Tanggal Presensi</th>
        <th rowspan="2">TH</th>
        <th rowspan="2">TT</th>
      </tr>
      <tr>
        <?php
            for($i=1; $i<=31; $i++){
        ?>
            <th>{{ $i }}</th>
        <?php
            }
        ?>
      </tr>
      @foreach ($rekap as $d)
          <tr>
              <td style="text-align: center;">{{ $loop->iteration }}</td>  
              <td style="text-align: center;">{{ $d->nik }}</td>
              <td>{{ $d->nama_lengkap }}</td>

              <?php
              $totalhadir = 0;
              $totalterlambat = 0;
              for($i=1; $i<=31; $i++){
                  $tgl = "tgl_".$i;
                  if(empty($d->$tgl)){
                    $hadir = ["",""];
                    $totalhadir += 0;
                  }else{
                    $hadir = explode("-", $d->$tgl);
                    $totalhadir += 1;
                    if ($hadir[0] > $d->jam_masuk_akhir) {
                      $totalterlambat += 1;
                    }
                  }
              ?>
                  <td style="text-align: center;">
                    <span style="color: {{ $hadir[0] > $d->jam_masuk_akhir ? "red" : "" }}">{{ !empty($hadir[0]) ? $hadir[0] : '-' }}</span> <br>
                    <span style="color: {{ $hadir[1] < $d->jam_pulang_awal ? "red" : "" }}">{{ !empty($hadir[1]) ? $hadir[1] : '-' }}</span>

                  </td>
              <?php
                  }
              ?>

              <td style="text-align: center;">{{ $totalhadir }}</td>
              <td style="text-align: center;">{{ $totalterlambat }}</td>

          </tr>
      @endforeach
    </table>
    

    <table class="tandatangan">
      <tr>
        <td style="width: 60%;"></td>
        <td style="text-align: center;">
          Jember, {{ date("d-m-Y") }} <br>
          Kepala Madrasah <br>
          <br><br><br><br>
          <b><u>Nama Kepala Madrasah</u></b>
        </td>
      </tr>
    </table>

  </section>

</body>

</html>