<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <title>Cetak Laporan Karyawan</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/normalize/7.0.0/normalize.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/paper-css/0.4.1/paper.css">
  <style>
      @page {
        size: A4
      }
      h3 {
        font-family: Arial, Helvetica, sans-serif
      }
      span {
        font-family: Arial, Helvetica, sans-serif
      }
      .tabeldatakaryawan {
        margin-top: 30px;
        font-family: Arial, Helvetica, sans-serif;
        font-size: 14px;
      }
      .tabeldatakaryawan td {
        padding: 5px;
      }
      .tabelpresensi {
        width: 100%;
        margin-top: 20px;
        font-family: Arial, Helvetica, sans-serif;
        font-size: 14px;
        border-collapse: collapse;
      }
      .tabelpresensi tr th {
        border: 1px solid #000000;
        padding: 8px;
        background-color: #e2e2e2;
      }
      .tabelpresensi tr td {
        border: 1px solid #000000;
        padding: 2px;
      }
      .tandatangan {
        width: 100%;
        font-family: Arial, Helvetica, sans-serif;
        font-size: 14px;
        margin-top: 20px;
      }
  </style>
</head>

<body class="A4">
  @php
    //Function Untuk Menghitung Selisih Jam
    function selisih($jam_masuk, $jam_keluar)
            {
                list($h, $m, $s) = explode(":", $jam_masuk);
                $dtAwal = mktime($h, $m, $s, "1", "1", "1");
                list($h, $m, $s) = explode(":", $jam_keluar);
                $dtAkhir = mktime($h, $m, $s, "1", "1", "1");
                $dtSelisih = $dtAkhir - $dtAwal;
                $totalmenit = $dtSelisih / 60;
                $jam = explode(".", $totalmenit / 60);
                $sisamenit = ($totalmenit / 60) - $jam[0];
                $sisamenit2 = $sisamenit * 60;
                $jml_jam = $jam[0];
                return $jml_jam . ":" . round($sisamenit2);
            }
  @endphp
  
  <section class="sheet padding-10mm">

    <table style="width: 100%">
      <tr>
        <td style="width: 120px">
          <img src="{{ asset('assets/panel/img/logo-alamien.png') }}" width="100" alt="">
        </td>
        <td>
          <h3 style="margin-block-end: 0em;">
            LAPORAN PRESENSI KARYAWAN <br>
            PERIODE {{ strtoupper($namabulan[$bulan]) }} {{ $tahun }} <br>
            AL AMIEN JEMBER <br>
          </h3>
          <span>Jl. K. Masduqi Kebonsari Ambulu Jember</span>
        </td>
      </tr>
    </table>
    <table class="tabeldatakaryawan">
      <tr>
        <td rowspan="6">
          @php
              $path = Storage::url('uploads/karyawan/'.$karyawan->foto);
          @endphp
          <img src="{{ url($path) }}" width="150px" alt="">
        </td>
      </tr>
      <tr>
        <td>NIK</td>
        <td>:</td>
        <td>{{ $karyawan->nik }}</td>
      </tr>
      <tr>
        <td>Nama Lengkap</td>
        <td>:</td>
        <td><b>{{ $karyawan->nama_lengkap }}</b></td>
      </tr>
      <tr>
        <td>Jabatan</td>
        <td>:</td>
        <td>{{ $karyawan->nama_jab }}</td>
      </tr>
      <tr>
        <td>Departemen</td>
        <td>:</td>
        <td>{{ $karyawan->nama_dept }}</td>
      </tr>
      <tr>
        <td>No. HP</td>
        <td>:</td>
        <td>{{ $karyawan->no_hp }}</td>
      </tr>
    </table>
    <table class="tabelpresensi">
      <tr>
        <th>No.</th>
        <th>Tanggal</th>
        <th>Masuk</th>
        <th>Foto</th>
        <th>Pulang</th>
        <th>Foto</th>
        <th>Status</th>
        <th>Ket.</th>
        <th>Jml Jam</th>
      </tr>
      @foreach ($presensi as $d)
      @if ($d->status == "h")
        <tr style="text-align: center;">
          
            @php
                $pathIn = Storage::url('uploads/absensi/'.$d->foto_in);
                $pathOut = Storage::url('uploads/absensi/'.$d->foto_out);
                $jamterlambat = selisih($d->jam_masuk_akhir,$d->jam_in);
            @endphp
                <td>{{ $loop->iteration }}.</td>
                <td>{{ date("d-m-Y",strtotime($d->tgl_presensi)) }}</td>
                <td>{{ $d->jam_in }}</td>
                <td><img src="{{ url($pathIn) }}" width="50px" style="border-radius: 0.25rem;"></td>
                <td>{{ $d->jam_out != null ? $d->jam_out : 'Belum Absen' }}</td>
                <td>
                    @if (empty($d->foto_out))
                      Belum Absen
                    @else
                      <img src="{{ url($pathOut) }}" width="50px" style="border-radius: 0.25rem;">
                    @endif
                </td>
                <td>
                  @if ($d->status == "h")
                      H
                  @endif
                </td>
                <td>
                    @if ($d->jam_in > $d->jam_masuk_akhir)
                    Terlambat: {{ $jamterlambat }}
                    @else
                    Tepat Waktu
                    @endif
                </td>
                <td>
                  @if ($d->jam_out != null)
                    @php
                        $jmljamkerja = selisih($d->jam_in,$d->jam_out);
                    @endphp
                  @else
                    @php
                        $jmljamkerja = 0;
                    @endphp
                  @endif
                  {{ $jmljamkerja }}
                </td>
          
        </tr> 
      @else
        <tr style="text-align: center;">
          
          <td>{{ $loop->iteration }}.</td>
          <td>{{ date("d-m-Y",strtotime($d->tgl_presensi)) }}</td>
          <td></td>
          <td></td>
          <td></td>
          <td></td>
          <td>
            @if ($d->status == "i")
              I
            @elseif ($d->status == "s")
              S
            @elseif ($d->status == "c")
              C
            @endif
          </td>
          <td>{{ $d->keterangan }}</td>
          <td></td>
        </tr>
      @endif
      @endforeach
    </table>

    <table class="tandatangan">
      <tr>
        <td style="width: 60%;"></td>
        <td style="text-align: center;">
          Jember, {{ date("d-m-Y") }} <br>
          Kepala Madrasah <br>
          <br><br><br><br>
          <b><u>Nama Kepala Madrasah</u></b>
        </td>
      </tr>
    </table>

  </section>

</body>

</html>