@include('layouts.admin.header')

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="{{ asset('assets/panel/img/favicon/favicon.ico') }}" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet" />

    <!-- Icons -->
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/fonts/fontawesome.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/fonts/tabler-icons.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/fonts/flag-icons.css') }}" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/css/rtl/core.css') }}" class="template-customizer-core-css" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/css/rtl/theme-default.css') }}" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="{{ asset('assets/panel/css/demo.css') }}" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/perfect-scrollbar/perfect-scrollbar.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/node-waves/node-waves.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/typeahead-js/typeahead.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/animate-css/animate.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/sweetalert2/sweetalert2.css') }}" />
    
    <!-- Page CSS -->

    <!-- Helpers -->
    <script src="{{ asset('assets/panel/vendor/js/helpers.js') }}"></script>
    <!-- Template customizer  -->
    <script src="{{ asset('assets/panel/vendor/js/template-customizer.js') }}"></script>
    <!-- Mandatory theme config file  -->
    <script src="{{ asset('assets/panel/js/config.js') }}"></script>
  </head>

  <body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
      <div class="layout-container">
        <!-- Menu -->
        <x-sidebar></x-sidebar>
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page">
          <!-- Navbar -->
          @include('layouts.admin.navbar')
          <!-- / Navbar -->

          <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->

            <div class="container-xxl flex-grow-1 container-p-y">
              <h4 class="fw-bold py-3 mb-4">Atur Jam Kerja</h4>
              <!-- Hoverable Table rows -->
              <div class="card">
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col">
                        <a href="/panel/jamkerjadept" type="button" class="btn btn-secondary waves-effect waves-light">
                            <span class="ti-xs ti ti-arrow-left me-1"></span>Kembali
                        </a>
                        </div>
                    </div>
                    <div class="row mb-2">
                      <div class="col">
                        @php
                            $messagesuccess = Session::get('success');
                            $messageerror = Session::get('error');
                        @endphp
                        @if (Session::get('success'))
                        <div class="alert alert-success alert-dismissible" role="alert">
                            {{ $messagesuccess }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                        @endif
                        @if (Session::get('error'))
                        <div class="alert alert-danger alert-dismissible" role="alert">
                            {{ $messageerror }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                        @endif
                      </div>
                    </div>

                    <form action="/panel/jamkerjadept/store" method="POST" id="tbhjkdept">
                    @csrf
                        <div class="row mb-3">
                            <div class="col-12">
                                <div class="row">
                                    <div class="col-6">
                                        <div class="form-group">
                                            <select name="kode_cabang" id="kode_cabang" class="form-select" required>
                                                <option value="">Pilih Cabang</option>
                                                @foreach ($cabang as $d)
                                                    <option value="{{ $d->kode_cabang }}">{{ $d->nama_cabang }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="form-group">
                                            <select name="kode_dept" id="kode_dept" class="form-select" required>
                                                <option value="">Pilih Departemen</option>
                                                @foreach ($departemen as $d)
                                                    <option value="{{ $d->kode_dept }}">{{ $d->nama_dept }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-4">
                                <div class="table-responsive text-nowrap">
                                    <table class="table table-hover mb-0">
                                        <thead class="table-light">
                                            <tr>
                                                <th style="text-align: center;">Hari</th>
                                                <th style="text-align: center;">Jam Kerja</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>Senin
                                                    <input type="hidden" name="hari[]" value="Senin">
                                                </td>
                                                <td>
                                                    <select name="kode_jam_kerja[]" id="kode_jam_kerja" class="form-select" required>
                                                        <option value="">Pilih Jam Kerja</option>
                                                        @foreach ($jamkerja as $d)
                                                            <option value="{{ $d->kode_jam_kerja }}">{{ $d->nama_jam_kerja }}</option>
                                                        @endforeach
                                                    </select>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>Selasa
                                                    <input type="hidden" name="hari[]" value="Selasa">
                                                </td>
                                                <td>
                                                    <select name="kode_jam_kerja[]" id="kode_jam_kerja" class="form-select" required>
                                                        <option value="">Pilih Jam Kerja</option>
                                                        @foreach ($jamkerja as $d)
                                                            <option value="{{ $d->kode_jam_kerja }}">{{ $d->nama_jam_kerja }}</option>
                                                        @endforeach
                                                    </select>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>Rabu
                                                    <input type="hidden" name="hari[]" value="Rabu">
                                                </td>
                                                <td>
                                                    <select name="kode_jam_kerja[]" id="kode_jam_kerja" class="form-select" required>
                                                        <option value="">Pilih Jam Kerja</option>
                                                        @foreach ($jamkerja as $d)
                                                            <option value="{{ $d->kode_jam_kerja }}">{{ $d->nama_jam_kerja }}</option>
                                                        @endforeach
                                                    </select>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>Kamis
                                                    <input type="hidden" name="hari[]" value="Kamis">
                                                </td>
                                                <td>
                                                    <select name="kode_jam_kerja[]" id="kode_jam_kerja" class="form-select" required>
                                                        <option value="">Pilih Jam Kerja</option>
                                                        @foreach ($jamkerja as $d)
                                                            <option value="{{ $d->kode_jam_kerja }}">{{ $d->nama_jam_kerja }}</option>
                                                        @endforeach
                                                    </select>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>Jumat
                                                    <input type="hidden" name="hari[]" value="Jumat">
                                                </td>
                                                <td>
                                                    <select name="kode_jam_kerja[]" id="kode_jam_kerja" class="form-select" required>
                                                        <option value="">Pilih Jam Kerja</option>
                                                        @foreach ($jamkerja as $d)
                                                            <option value="{{ $d->kode_jam_kerja }}">{{ $d->nama_jam_kerja }}</option>
                                                        @endforeach
                                                    </select>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>Sabtu
                                                    <input type="hidden" name="hari[]" value="Sabtu">
                                                </td>
                                                <td>
                                                    <select name="kode_jam_kerja[]" id="kode_jam_kerja" class="form-select" required>
                                                        <option value="">Pilih Jam Kerja</option>
                                                        @foreach ($jamkerja as $d)
                                                            <option value="{{ $d->kode_jam_kerja }}">{{ $d->nama_jam_kerja }}</option>
                                                        @endforeach
                                                    </select>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>Minggu
                                                    <input type="hidden" name="hari[]" value="Minggu">
                                                </td>
                                                <td>
                                                    <select name="kode_jam_kerja[]" id="kode_jam_kerja" class="form-select" required>
                                                        <option value="">Pilih Jam Kerja</option>
                                                        @foreach ($jamkerja as $d)
                                                            <option value="{{ $d->kode_jam_kerja }}">{{ $d->nama_jam_kerja }}</option>
                                                        @endforeach
                                                    </select>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <br>
                                <button type="submit" class="btn btn-primary w-100">Simpan</button>
                            </div>
                            <div class="col-8">
                                <div class="table-responsive text-nowrap">
                                    <table class="table table-hover mb-0">
                                        <thead class="table-light">
                                            <tr>
                                                <th colspan="5" style="text-align: center;">Master Jam Kerja</th>
                                            </tr>
                                            <tr style="text-align: center;">
                                                <th>Nama<br>Jam Kerja</th>
                                                <th>Masuk<br>Awal</th>
                                                <th>Masuk<br>Akhir</th>
                                                <th>Pulang<br>Awal</th>
                                                <th>Pulang<br>Akhir</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($jamkerja as $d)
                                                <tr style="text-align: center;">
                                                    <th>{{ $d->nama_jam_kerja }}</th>
                                                    <td>{{ date("H:i",strtotime($d->jam_masuk_awal)) }}</td>
                                                    <td>{{ date("H:i",strtotime($d->jam_masuk_akhir)) }}</td>
                                                    <td>{{ date("H:i",strtotime($d->jam_pulang_awal)) }}</td>
                                                    <td>{{ date("H:i",strtotime($d->jam_pulang_akhir)) }}</td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
              </div>
              <!--/ Hoverable Table rows -->

            </div>
            <!-- / Content -->

            <!-- Footer -->
            @include('layouts.admin.footer')
            <!-- / Footer -->

            <div class="content-backdrop fade"></div>
          </div>
          <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
      </div>

      <!-- Overlay -->
      <div class="layout-overlay layout-menu-toggle"></div>

      <!-- Drag Target Area To SlideIn Menu On Small Screens -->
      <div class="drag-target"></div>
    </div>
    <!-- / Layout wrapper -->

    <!-- Core JS -->
    <!-- build:js assets/vendor/js/core.js -->
    <script src="{{ asset('assets/panel/vendor/libs/jquery/jquery.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/libs/popper/popper.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/js/bootstrap.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/libs/perfect-scrollbar/perfect-scrollbar.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/libs/node-waves/node-waves.js') }}"></script>

    <script src="{{ asset('assets/panel/vendor/libs/hammer/hammer.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/libs/i18n/i18n.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/libs/typeahead-js/typeahead.js') }}"></script>

    <script src="{{ asset('assets/panel/vendor/js/menu.js') }}"></script>
    <!-- endbuild -->

    <!-- Vendors JS -->
    <script src="{{ asset('assets/panel/vendor/libs/sweetalert2/sweetalert2.js') }}"></script>

    <!-- Main JS -->
    <script src="{{ asset('assets/panel/js/main.js') }}"></script>

    <!-- Page JS -->
    <script src="{{ asset('assets/panel/js/extended-ui-sweetalert2.js') }}"></script>

    <script>
        $(function(){
          
            $("#timer-alert").fadeTo(2000, 500).slideUp(500, function(){
                $("#timer-alert").slideUp(500);
            });

            new DataTable('#departemen');

            $("#tbhjkdept").submit(function(){
                var kode_cabang = $("#kode_cabang").val();
                var kode_dept = $("#kode_dept").val();
                if(kode_cabang == '') {
                    Swal.fire({
                        title: 'Maaf!',
                        text: 'Cabang Wajib Dipilih',
                        icon: 'warning'
                        });
                    return false;
                } else if(kode_dept == '') {
                    Swal.fire({
                        title: 'Maaf!',
                        text: 'Departemen Wajib Dipilih',
                        icon: 'warning'
                        });
                    return false;
                } 
            });
        });
    </script>
</body>
</html>
