@include('layouts.admin.header')

<!-- Favicon -->
<link rel="icon" type="image/x-icon" href="{{ asset('assets/panel/img/favicon/favicon.ico') }}" />

<!-- Fonts -->
<link rel="preconnect" href="https://fonts.googleapis.com" />
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
<link href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap" rel="stylesheet" />

<!-- Icons -->
<link rel="stylesheet" href="{{ asset('assets/panel/vendor/fonts/fontawesome.css') }}" />
<link rel="stylesheet" href="{{ asset('assets/panel/vendor/fonts/tabler-icons.css') }}" />
<link rel="stylesheet" href="{{ asset('assets/panel/vendor/fonts/flag-icons.css') }}" />

<!-- Core CSS -->
<link rel="stylesheet" href="{{ asset('assets/panel/vendor/css/rtl/core.css') }}" class="template-customizer-core-css" />
<link rel="stylesheet" href="{{ asset('assets/panel/vendor/css/rtl/theme-default.css') }}" class="template-customizer-theme-css" />
<link rel="stylesheet" href="{{ asset('assets/panel/css/demo.css') }}" />

<!-- Vendors CSS -->
<link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/perfect-scrollbar/perfect-scrollbar.css') }}" />
<link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/node-waves/node-waves.css') }}" />
<link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/typeahead-js/typeahead.css') }}" />
<link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/animate-css/animate.css') }}" />
<link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/sweetalert2/sweetalert2.css') }}" />
<link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/datatables-bs5/datatables.bootstrap5.css') }}">
{{-- <link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.css') }}" /> --}}
{{-- <link href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css" rel="stylesheet"> --}}
<link href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.dataTables.min.css" rel="stylesheet">

<!-- Page CSS -->

<!-- Helpers -->
<script src="{{ asset('assets/panel/vendor/js/helpers.js') }}"></script>
<!-- Template customizer  -->
<script src="{{ asset('assets/panel/vendor/js/template-customizer.js') }}"></script>
<!-- Mandatory theme config file  -->
<script src="{{ asset('assets/panel/js/config.js') }}"></script>
</head>

<body>
  <!-- Layout wrapper -->
  <div class="layout-wrapper layout-content-navbar">
    <div class="layout-container">
      <!-- Menu -->
      <x-sidebar></x-sidebar>
      <!-- / Menu -->

      <!-- Layout container -->
      <div class="layout-page">
        <!-- Navbar -->
        @include('layouts.admin.navbar')
        <!-- / Navbar -->

        <!-- Content wrapper -->
        <div class="content-wrapper">
          <!-- Content -->

          <div class="container-xxl flex-grow-1 container-p-y">
            <h4 class="fw-bold py-3 mb-4">Data Karyawan</h4>
            <!-- Hoverable Table rows -->
            <div class="card">
              <div class="card-body">
                <div class="row mb-3">
                  <div class="col">
                    <button type="button" class="btn btn-primary waves-effect waves-light" data-bs-toggle="modal" data-bs-target="#modal-tambah-karyawan">
                      <span class="ti-xs ti ti-circle-plus me-1"></span>Tambah Data
                    </button>
                    <button type="button" class="btn btn-success waves-effect waves-light" data-bs-toggle="modal" data-bs-target="#modal-import-karyawan">
                      <span class="ti-xs ti ti-upload me-1"></span>Import Data
                    </button>
                    <button type="button" class="btn btn-danger waves-effect waves-light">
                      <span class="ti-xs ti ti-download me-1"></span>Export Data
                    </button>
                  </div>
                </div>
                <form action="/panel/karyawan">
                  <div class="row mb-2">
                    <div class="col-6">
                      <input type="text" id="nama_karyawan" name="nama_karyawan" class="form-control" value="{{ Request('nama_karyawan') }}" placeholder="Nama Karyawan" />
                    </div>
                    <div class="col-4">
                      <select name="kode_dept" id="kode_dept" class="form-select">
                        <option value="">Departemen</option>
                        @foreach ($departemen as $d)
                          <option {{ Request('kode_dept') == $d->kode_dept ? 'selected' : '' }} value="{{ $d->kode_dept }}">{{ $d->nama_dept }}</option>
                        @endforeach
                      </select>
                    </div>
                    <div class="col-2">
                      <button type="submit" class="btn btn-primary waves-effect waves-light">
                        <span class="ti-xs ti ti-search me-1"></span>Cari Data
                      </button>
                    </div>
                  </div>
                </form>
                <div class="row mb-1">
                  <div class="col">
                    @php
                      $messagesuccess = Session::get('success');
                      $messageerror = Session::get('error');
                    @endphp
                    @if (Session::get('success'))
                      <div class="alert alert-success alert-dismissible" role="alert" id="timer-alert">
                        {{ $messagesuccess }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                      </div>
                    @endif
                    @if (Session::get('error'))
                      <div class="alert alert-danger alert-dismissible" role="alert" id="timer-alert">
                        {{ $messageerror }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                      </div>
                    @endif
                  </div>
                </div>
                <div class="table-responsive text-nowrap">
                  <table class="table table-hover">
                    <thead class="table-light">
                      <tr class="text-nowrap" style="text-align: center;">
                        <th>No.</th>
                        <th>NIK</th>
                        <th>Nama</th>
                        <th>Jabatan</th>
                        <th>Dep</th>
                        <th>Cabang</th>
                        <th>Foto</th>
                        <th style="width: 40px;">Aksi</th>
                      </tr>
                    </thead>
                    <tbody class="table-border-bottom-0">
                      @foreach ($karyawan as $d)
                        @php
                          $path = Storage::url('uploads/karyawan/' . $d->foto);
                        @endphp
                        <tr>
                          <td style="text-align: center; vertical-align: middle;">{{ $loop->iteration + $karyawan->firstItem() - 1 }}.</td>
                          <td style="text-align: center; vertical-align: middle;">{{ $d->nik }}</td>
                          <td style="vertical-align: middle;">{{ $d->nama_lengkap }}</td>
                          <td style="text-align: center; vertical-align: middle;">{{ $d->nama_jab }}</td>
                          <td style="text-align: center; vertical-align: middle;">{{ $d->nama_dept }}</td>
                          <td style="text-align: center; vertical-align: middle;">{{ $d->kode_cabang }}</td>
                          <td>
                            <div class="avatar">
                              @if (empty($d->foto))
                                <img src="{{ asset('storage/uploads/karyawan/default.png') }}" alt="Avatar" class="rounded-circle">
                              @else
                                <img src="{{ url($path) }}" alt="Avatar" class="rounded-circle">
                              @endif
                            </div>
                          </td>
                          <td>
                            <div class="d-flex align-items-center">
                              <a href="#" class="btn text-primary" style="padding: 0px;" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="Detail"><i class="ti ti-eye ti-xs me-2"></i></a>
                              <a href="#" class="btn text-success edit" style="padding: 0px;" id_enc="{{ $d->id_enc }}" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="Edit"><i class="ti ti-edit ti-xs me-2"></i></a>
                              <a href="/panel/konfigurasi/{{ $d->nik }}/setjamkerja" class="btn text-info" style="padding: 0px;" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="Set Jam Kerja"><i class="ti ti-settings ti-xs me-2"></i></a>
                              {{-- <a href="/panel/karyawan/{{ $d->id_enc }}/resetpassword" class="btn text-warning" style="padding: 0px;" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="Reset Password"><i class="ti ti-refresh ti-xs me-2"></i></a> --}}
                              <form action="/panel/karyawan/{{ $d->id_enc }}/resetpassword" method="POST">
                                @csrf
                                <a class="btn text-warning reset-confirm me-1" style="padding: 0px;" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="Reset Password"><i class="ti ti-refresh ti-xs"></i></a>
                              </form>
                              <form action="/panel/karyawan/{{ $d->id_enc }}/delete" method="POST">
                                @csrf
                                <a class="btn text-danger delete-confirm" style="padding: 0px;" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="Hapus"><i class="ti ti-trash ti-xs"></i></a>
                              </form>
                            </div>
                          </td>
                        </tr>
                      @endforeach
                    </tbody>
                  </table>
                </div>
                {{ $karyawan->links('vendor.pagination.bootstrap-5') }}
              </div>
            </div>
            <!--/ Hoverable Table rows -->



            <!-- Modal Tambah Karyawan -->
            <div class="modal fade" id="modal-tambah-karyawan" tabindex="-1" aria-hidden="true">
              <div class="modal-dialog" role="document">
                <div class="modal-content">
                  <div class="modal-header">
                    <h5 class="modal-title" id="modalCenterTitle">Tambah Karyawan</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                  </div>
                  <div class="modal-body">
                    <form action="/panel/karyawan/store" method="POST" id="frmKaryawan" enctype="multipart/form-data">
                      @csrf
                      <div class="row">
                        <div class="col-4 mb-3">
                          <label for="nik" class="form-label">NIK</label>
                          <input type="text" id="nik" name="nik" class="form-control" placeholder="NIK" />
                        </div>
                        <div class="col-8 mb-3">
                          <label for="nama_lengkap" class="form-label">Nama Lengkap</label>
                          <input type="text" id="nama_lengkap" name="nama_lengkap" class="form-control" placeholder="Nama Lengkap" />
                        </div>
                      </div>
                      <div class="row">
                        <div class="col-6 mb-3">
                          <label for="kode_cabang" class="form-label">Kantor Cabang</label>
                          <select name="kode_cabang" id="kode_cabang" class="form-select">
                            <option value="">--- Pilih ---</option>
                            @foreach ($kantorcabang as $d)
                              <option value="{{ $d->kode_cabang }}">{{ $d->nama_cabang }}</option>
                            @endforeach
                          </select>
                        </div>
                        <div class="col-6 mb-3">
                          <label for="kode_dept" class="form-label">Departemen</label>
                          <select name="kode_dept" id="kode_dept" class="form-select">
                            <option value="">--- Pilih ---</option>
                            @foreach ($departemen as $d)
                              <option value="{{ $d->kode_dept }}">{{ $d->nama_dept }}</option>
                            @endforeach
                          </select>
                        </div>
                      </div>
                      <div class="row">
                        <div class="col-6 mb-3">
                          <label for="kode_jab" class="form-label">Jabatan</label>
                          <select name="kode_jab" id="kode_jab" class="form-select">
                            <option value="">--- Pilih ---</option>
                            @foreach ($jabatan as $d)
                              <option value="{{ $d->kode_jab }}">{{ $d->nama_jab }}</option>
                            @endforeach
                          </select>
                        </div>
                        <div class="col-6 mb-3">
                          <label for="foto" class="form-label">Foto Profil (Opsional)</label>
                          <input class="form-control" type="file" id="foto" name="foto" accept=".png, .jpg, .jpeg" />
                        </div>
                      </div>
                      <div class="modal-footer">
                        <button type="button" class="btn btn-label-secondary" data-bs-dismiss="modal">
                          Batal
                        </button>
                        <button type="submit" class="btn btn-primary">Tambah</button>
                      </div>
                    </form>
                  </div>
                </div>
              </div>
            </div>

            <!-- Modal Edit Karyawan -->
            <div class="modal fade" id="modal-edit-karyawan" tabindex="-1" aria-hidden="true">
              <div class="modal-dialog" role="document">
                <div class="modal-content">
                  <div class="modal-header">
                    <h5 class="modal-title" id="modalCenterTitle">Edit Karyawan</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                  </div>
                  <div class="modal-body" id="loadeditform">

                  </div>
                </div>
              </div>
            </div>

            <!-- Modal Import Karyawan -->
            <div class="modal fade" id="modal-import-karyawan" tabindex="-1" aria-hidden="true">
              <div class="modal-dialog modal-sm" role="document">
                <div class="modal-content">
                  <div class="modal-header">
                    <h5 class="modal-title" id="modalCenterTitle">Import Data Karyawan</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                  </div>
                  <div class="modal-body">
                    <form action="/panel/karyawan/import" method="POST" enctype="multipart/form-data">
                      @csrf
                      <div class="row">
                        @php
                          $path = Storage::url('uploads/data-import-karyawan.xlsx');
                        @endphp
                        <div class="col mb-3">
                          Download Template <a href="{{ url($path) }}" type="button" class="btn btn-xs btn-danger waves-effect waves-light">Disini</a>
                        </div>
                      </div>
                      <div class="row">
                        <div class="col mb-3">
                          <label for="file" class="form-label">Import File (.xls/.xlsx)</label>
                          <input class="form-control" type="file" id="file" name="file" accept=".xls, .xlsx" required />
                        </div>
                      </div>
                      <div class="modal-footer">
                        <button type="button" class="btn btn-label-secondary" data-bs-dismiss="modal">
                          Batal
                        </button>
                        <button type="submit" class="btn btn-success">
                          <span class="ti-xs ti ti-upload me-1"></span>Import Data
                        </button>
                      </div>
                    </form>
                  </div>
                </div>
              </div>
            </div>

          </div>
          <!-- / Content -->

          <!-- Footer -->
          @include('layouts.admin.footer')
          <!-- / Footer -->

          <div class="content-backdrop fade"></div>
        </div>
        <!-- Content wrapper -->
      </div>
      <!-- / Layout page -->
    </div>

    <!-- Overlay -->
    <div class="layout-overlay layout-menu-toggle"></div>

    <!-- Drag Target Area To SlideIn Menu On Small Screens -->
    <div class="drag-target"></div>
  </div>
  <!-- / Layout wrapper -->

  <!-- Core JS -->
  <!-- build:js assets/vendor/js/core.js -->
  <script src="{{ asset('assets/panel/vendor/libs/jquery/jquery.js') }}"></script>
  <script src="{{ asset('assets/panel/vendor/libs/popper/popper.js') }}"></script>
  <script src="{{ asset('assets/panel/vendor/js/bootstrap.js') }}"></script>
  <script src="{{ asset('assets/panel/vendor/libs/perfect-scrollbar/perfect-scrollbar.js') }}"></script>
  <script src="{{ asset('assets/panel/vendor/libs/node-waves/node-waves.js') }}"></script>

  <script src="{{ asset('assets/panel/vendor/libs/hammer/hammer.js') }}"></script>
  <script src="{{ asset('assets/panel/vendor/libs/i18n/i18n.js') }}"></script>
  <script src="{{ asset('assets/panel/vendor/libs/typeahead-js/typeahead.js') }}"></script>

  <script src="{{ asset('assets/panel/vendor/js/menu.js') }}"></script>
  <!-- endbuild -->

  <!-- Vendors JS -->
  <script src="{{ asset('assets/panel/vendor/libs/sweetalert2/sweetalert2.js') }}"></script>
  <script src="{{ asset('assets/panel/vendor/libs/datatables-bs5/1.13.6/jquery.dataTables.min.js') }}"></script>
  <script src="{{ asset('assets/panel/vendor/libs/datatables-bs5/datatables-bootstrap5.js') }}"></script>

  <!-- Main JS -->
  <script src="{{ asset('assets/panel/js/main.js') }}"></script>

  <!-- Page JS -->
  <script src="{{ asset('assets/panel/js/extended-ui-sweetalert2.js') }}"></script>
  <script src="{{ asset('assets/panel/js/tables-datatables-basic.js') }}"></script>

  <script>
    $(function() {

      $("#timer-alert").fadeTo(2000, 500).slideUp(500, function() {
        $("#timer-alert").slideUp(500);
      });

      // new DataTable('#example');
      var table = $('#example').DataTable({
        lengthChange: false,
        buttons: ['copy', 'excel', 'pdf', 'colvis']
      });

      table.buttons().container()
        .appendTo('#example_wrapper .col-md-6:eq(0)');

      $("#btnTambahkaryawan").click(function() {
        $("#modal-tambah-karyawan").modal("show");
      });

      $(".edit").click(function() {
        var id_enc = $(this).attr('id_enc');
        $.ajax({
          type: 'POST',
          url: '/panel/karyawan/edit',
          cache: false,
          data: {
            _token: "{{ csrf_token() }}",
            id_enc: id_enc
          },
          success: function(respond) {
            $("#loadeditform").html(respond);
          }
        });
        $("#modal-edit-karyawan").modal("show");
      });

      $(".delete-confirm").click(function(e) {
        var form = $(this).closest('form');
        e.preventDefault();
        Swal.fire({
          title: 'Anda Yakin?',
          text: "Data Karyawan Ini Akan Di Hapus",
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#6658dd',
          cancelButtonColor: '#f1556c',
          cancelButtonText: 'Batal',
          confirmButtonText: 'Hapus'
        }).then((result) => {
          if (result.isConfirmed) {
            form.submit();
            // Swal.fire(
            // 'Mantab!',
            // 'Hapus Karyawan Berhasil.',
            // 'success'
            // )
          }
        });
        return false;
      });

      $(".reset-confirm").click(function(e) {
        var form = $(this).closest('form');
        e.preventDefault();
        Swal.fire({
          title: 'Anda Yakin?',
          text: "Password Karyawan Ini Akan Di Reset",
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#6658dd',
          cancelButtonColor: '#f1556c',
          cancelButtonText: 'Batal',
          confirmButtonText: 'Reset'
        }).then((result) => {
          if (result.isConfirmed) {
            form.submit();
            // Swal.fire(
            // 'Mantab!',
            // 'Password Default "12345".',
            // 'success'
            // )
          }
        });
        return false;
      });

      $("#nik").change(function(e) {
        var nik = $(this).val();
        $.ajax({
          type: 'POST',
          url: '/panel/karyawan/ceknik',
          data: {
            _token: "{{ csrf_token() }}",
            nik: nik
          },
          cache: false,
          success: function(respond) {
            if (respond == 1) {
              Swal.fire({
                title: 'Maaf!',
                text: 'NIK Sudah Terdaftar!',
                icon: 'warning'
              }).then((result) => {
                $("#nik").val("");
              });
              return false;
            }
          }
        });
      });

      $("#frmKaryawan").submit(function() {
        var nik = $("#nik").val();
        var nama_lengkap = $("#nama_lengkap").val();
        var kode_cabang = $("#frmKaryawan").find("#kode_cabang").val();
        var kode_dept = $("#frmKaryawan").find("#kode_dept").val();
        var kode_jab = $("#frmKaryawan").find("#kode_jab").val();
        if (nik == "") {
          Swal.fire({
            title: 'Maaf!',
            text: 'NIK Wajib Diisi',
            icon: 'warning'
          }).then((result) => {
            $("#nik").focus();
          });
          return false;
        } else if (nama_lengkap == "") {
          Swal.fire({
            title: 'Maaf!',
            text: 'Nama Lengkap Wajib Diisi',
            icon: 'warning'
          }).then((result) => {
            $("#nama_lengkap").focus();
          });
          return false;
        } else if (kode_cabang == "") {
          Swal.fire({
            title: 'Maaf!',
            text: 'Kantor Cabang Wajib Diisi',
            icon: 'warning'
          }).then((result) => {
            $("#kode_cabang").focus();
          });
          return false;
        } else if (kode_dept == "") {
          Swal.fire({
            title: 'Maaf!',
            text: 'Departemen Wajib Diisi',
            icon: 'warning'
          }).then((result) => {
            $("#kode_dept").focus();
          });
          return false;
        } else if (kode_jab == "") {
          Swal.fire({
            title: 'Maaf!',
            text: 'Jabatan Wajib Diisi',
            icon: 'warning'
          }).then((result) => {
            $("#kode_jab").focus();
          });
          return false;
        }
      });
    });
  </script>
</body>

</html>
