<!doctype html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="theme-color" content="#000000">
    <title>E-Presensi Geolocation</title>
    <meta http-equiv="Cache-Control" content="no-cache" />
    <meta name="description" content="E-Presensi Geolocation">
    <meta name="keywords" content="" />
    <link rel="icon" type="image/png" href="{{ asset('assets/img/favicon.png') }}" sizes="32x32">
    <link rel="apple-touch-icon" sizes="180x180" href="{{ asset('assets/img/icon/192x192.png') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/style.css') }}">
    <link rel="manifest" href="__manifest.json">
    <style>
        div.scrollmenu {
            overflow: auto;
            white-space: nowrap;
            padding:10px; 
            max-height:300px;
        }
    </style>
</head>

<body>
    <?php
    function format_hari_tanggal($waktu)
        {
            $hari_array = array(
                'Minggu',
                'Senin',
                'Selasa',
                'Rabu',
                'Kamis',
                'Jumat',
                'Sabtu'
            );
            $hr = date('w', strtotime($waktu));
            $hari = $hari_array[$hr];
            $tanggal = date('j', strtotime($waktu));
            $bulan_array = array(
                1 => 'Januari',
                2 => 'Februari',
                3 => 'Maret',
                4 => 'April',
                5 => 'Mei',
                6 => 'Juni',
                7 => 'Juli',
                8 => 'Agustus',
                9 => 'September',
                10 => 'Oktober',
                11 => 'November',
                12 => 'Desember',
            );
            $bl = date('n', strtotime($waktu));
            $bulan = $bulan_array[$bl];
            $tahun = date('Y', strtotime($waktu));
            $jam = date( 'H:i:s', strtotime($waktu));
            return "$hari, $tanggal $bulan $tahun";
        }

        $date = date('Y-m-d');
    ?>

    <!-- loader -->
    <div id="loader">
        <img src="{{ asset('assets/img/loading-icon.png') }}" alt="icon" class="loading-icon">
    </div>
    <!-- * loader -->

    <!-- App Header -->
    <div class="appHeader bg-primary text-light">
        <div class="left">
            <a href="#" class="headerButton" data-bs-toggle="modal" data-bs-target="#sidebarPanel">
                <ion-icon name="menu-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">
            {{-- <img src="{{ asset('assets/img/logo.png') }}" alt="logo" class="logo"> --}}
            E-Presensi Al Amien
        </div>
        <div class="right">
            {{-- <a href="#" class="headerButton">
                <ion-icon class="icon" name="notifications-outline"></ion-icon>
                <span class="badge badge-danger">4</span>
            </a>
            <a href="#" class="headerButton">
                @if (!empty(Auth::guard('karyawan')->user()->foto))
                    @php
                        $path = Storage::url('uploads/karyawan/'.Auth::guard('karyawan')->user()->foto);
                    @endphp
                <img src="{{ url($path) }}" alt="image" class="imaged w32">
                @else
                <img src="{{ asset('storage/uploads/karyawan/default.png') }}" alt="image" class="imaged w32">
                @endif
                <span class="badge badge-danger">6</span>
            </a> --}}
            <a href="/proseslogout" class="headerButton">
                <ion-icon class="icon" name="log-out-outline"></ion-icon>
            </a>
        </div>
    </div>
    <!-- * App Header -->


    <!-- App Capsule -->
    <div id="appCapsule">
        <!-- Wallet Card -->
        <div class="section wallet-card-section pt-1">
            <div class="wallet-card">

                <div class="section text-center">
                    <div class="avatar-section">
                        @if (!empty(Auth::guard('karyawan')->user()->foto))
                         @php
                             $path = Storage::url('uploads/karyawan/'.Auth::guard('karyawan')->user()->foto);
                         @endphp
                        <img src="{{ url($path) }}" alt="avatar" class="imaged w100 rounded">
                        @else
                        <img src="{{ asset('storage/uploads/karyawan/default.png') }}" alt="avatar" class="imaged w100 rounded">
                        @endif
                    </div>
                </div>

                <!-- Balance -->
                <div class="balance">
                    <div class="center">
                            <h1 style="margin-bottom: 0px; margin-top: 5px;" class="total">{{ $karyawan->nama_lengkap }}</h1>
                            <span class="title" style="margin-bottom: 0px;">{{ $karyawan->nama_jab }} ({{ $karyawan->kode_cabang }})</span>
                    </div>
                </div>
                <!-- * Balance -->
                <!-- Wallet Footer -->
                <div class="wallet-footer">
                    <div class="item">
                        <a href="/profile">
                            <div class="icon-wrapper">
                                <ion-icon name="person-outline"></ion-icon>
                            </div>
                            <strong>Profil</strong>
                        </a>
                    </div>
                    <div class="item">
                        <a href="/ijin">
                            <div class="icon-wrapper">
                                <ion-icon name="calendar-outline"></ion-icon>
                            </div>
                            <strong>Cuti</strong>
                        </a>
                    </div>
                    <div class="item">
                        <a href="/histori">
                            <div class="icon-wrapper">
                                <ion-icon name="document-text-outline"></ion-icon>
                            </div>
                            <strong>Histori</strong>
                        </a>
                    </div>
                    <div class="item">
                        <a href="/lokasisaya">
                            <div class="icon-wrapper">
                                <ion-icon name="location-outline"></ion-icon>
                            </div>
                            <strong>Lokasi</strong>
                        </a>
                    </div>

                </div>
                <!-- * Wallet Footer -->
            </div>
        </div>
        <!-- Wallet Card -->

        <!-- Stats -->
        <div class="section">
            <div class="todaypresence">
                <div class="row">
                    <div class="col-6">
                        <div class="card warnagreen">
                            <div class="card-body">
                                <div class="presencecontent">
                                    <div class="iconpresence">

                                        @if ($presensihariini != null)
                                            @php
                                            $path = Storage::url('uploads/absensi/'.$presensihariini->foto_in);
                                            @endphp
                                            <img src="{{url($path)}}" alt="" class="imaged w48">
                                            @else
                                            <ion-icon name="image"></ion-icon>
                                        @endif
                                        
                                    </div>
                                    <div class="presencedetail">
                                        <h4 class="presencetitle">Masuk</h4>
                                        <span>{{$presensihariini != null ? $presensihariini->jam_in : "Belum Absen"}}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="card warnared">
                            <div class="card-body">
                                <div class="presencecontent">
                                    <div class="iconpresence">
                                        @if ($presensihariini != null && $presensihariini->jam_out != null)
                                            @php
                                            $path = Storage::url('uploads/absensi/'.$presensihariini->foto_out);
                                            @endphp
                                            <img src="{{url($path)}}" alt="" class="imaged w48">
                                            @else
                                            <ion-icon name="image"></ion-icon>
                                        @endif
                                        
                                    </div>
                                    <div class="presencedetail">
                                        <h4 class="presencetitle">Pulang</h4>
                                        <span>{{$presensihariini != null && $presensihariini->jam_out != null ? $presensihariini->jam_out : "Belum Absen"}}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- * Stats -->

        <!-- Rekap -->
        <div class="section mt-2" id="rekappresensi">
            <div class="section-heading2" style="margin-bottom: 0px;">
                <h3>Rekap Presensi Bulan {{ $namabulan[$bulanini] }} {{ $tahunini }}</h3>
            </div>
            <div class="row">
                <div class="col-3">
                    <div class="card">
                        <div class="card-body text-center" style="padding: 8px !important; line-height: 0.8rem;">
                            <span class="badge badge-danger" style="position:absolute; top:3px; right:5px; font-size:0.6rem; z-index:999;">
                                {{ $rekappresensi->jmlhadir }}</span>
                            <ion-icon name="checkmark-circle" class="text-info" style="font-size: 1.5rem"></ion-icon>
                            <br>
                            <span style="font-size: 0.8rem; font-weight:500;">Hadir</span>
                        </div>
                    </div>
                </div>
                <div class="col-3">
                    <div class="card">
                        <div class="card-body text-center" style="padding: 8px !important; line-height: 0.8rem;">
                            <span class="badge badge-danger" style="position:absolute; top:3px; right:5px; font-size:0.6rem; z-index:999;">
                                {{ $rekapijin->jmlijin != null ? $rekapijin->jmlijin : 0 }}</span>
                            <ion-icon name="document-text" class="text-primary" style="font-size: 1.5rem"></ion-icon>
                            <br>
                            <span style="font-size: 0.8rem; font-weight:500;">Ijin</span>
                        </div>
                    </div>
                </div>
                <div class="col-3">
                    <div class="card">
                        <div class="card-body text-center" style="padding: 8px !important; line-height: 0.8rem;">
                            <span class="badge badge-danger" style="position:absolute; top:3px; right:5px; font-size:0.6rem; z-index:999;">
                                {{ $rekapijin->jmlsakit != null ? $rekapijin->jmlsakit : 0 }}</span>
                            <ion-icon name="fitness" class="text-danger" style="font-size: 1.5rem"></ion-icon>
                            <br>
                            <span style="font-size: 0.8rem; font-weight:500;">Sakit</span>
                        </div>
                    </div>
                </div>
                <div class="col-3">
                    <div class="card">
                        <div class="card-body text-center" style="padding: 8px !important; line-height: 0.8rem;">
                            <span class="badge badge-danger" style="position:absolute; top:3px; right:5px; font-size:0.6rem; z-index:999;">
                                {{ $rekappresensi->jmlterlambat != null ? $rekappresensi->jmlterlambat : 0 }}</span>
                            <ion-icon name="alarm" class="text-warning" style="font-size: 1.5rem"></ion-icon>
                            <br>
                            <span style="font-size: 0.8rem; font-weight:500;">Telat</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <div class="section mt-3">
            <div class="section-heading2" style="margin-bottom: 0px;">
                <h3>Riwayat Presensi</h3>
            </div>
            <div class="card">
                <div class="card-body" style="padding: 10px;">
                    <ul class="nav nav-tabs capsuled" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" data-bs-toggle="tab" href="#bulanini" role="tab">
                                Bulan Ini
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-bs-toggle="tab" href="#leaderboard" role="tab">
                                Leaderboard
                            </a>
                        </li>
                    </ul>
                    <div class="tab-content mt-1">
                        <div class="tab-pane fade show active" id="bulanini" role="tabpanel">
                            <div class="scrollmenu">
                                <ul class="listview image-listview">

                                    @foreach ($historibulanini as $d)  
                                    <li>
                                        <div class="item" style="padding: 0px">
                                            <div class="icon-box bg-primary">
                                                <ion-icon name="finger-print-outline"></ion-icon>
                                            </div>
                                            <div class="in">
                                                <div>{{ date("d-m-Y",strtotime($d->tgl_presensi)) }}</div>
                                                <div>
                                                    <span class="badge {{ $d->jam_in < $d->jam_masuk_akhir ? "badge-info" : "badge-warning" }}">{{ $d->jam_in }}</span>
                                                    <span class="badge badge-danger">{{ $presensihariini != null && $d->jam_out != null ? $d->jam_out : 'Belum Absen' }}</span>
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                    @endforeach
                                    
                                </ul>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="leaderboard" role="tabpanel">
                            <div class="scrollmenu">
                                <ul class="listview image-listview"> 
                                    
                                    @foreach ($leaderboard as $d)
                                    <li>
                                        <div class="item" style="padding: 0px">
                                            @if (!empty($d->foto))
                                            @php
                                                $path = Storage::url('uploads/karyawan/'.$d->foto);
                                            @endphp
                                            <img src="{{ url($path) }}" alt="image" class="image">
                                            @else
                                            <img src="{{ asset('storage/uploads/karyawan/default.png') }}" alt="image" class="image">
                                            @endif
                                            <div class="in">
                                                <div style="line-height: 0.8rem">
                                                    {{ $d->nama_lengkap }}
                                                    <br>
                                                    <span class="text-muted" style="font-size: 10px">{{ $d->nama_jab }} ({{ $d->kode_cabang }})</span>
                                                </div>
                                                <div>
                                                    <span class="badge {{ $d->jam_in < $d->jam_masuk_akhir ? "badge-info" : "badge-warning" }}" style="margin-bottom: 0.1rem;">{{ $d->jam_in }}</span>
                                                    <br>
                                                    @if ($d->jam_out != null)
                                                    <span class="badge badge-danger">{{ $d->jam_out }}</span>
                                                    @else
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                    @endforeach
                                    
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- <div class="section mt-3">
            <div class="section-heading2" style="margin-bottom: 0px;">
                <h3>Riwayat Presensi</h3>
            </div>
            <div class="card">
                <div class="card-body" style="padding: 10px;">
                    <ul class="nav nav-tabs capsuled" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" data-bs-toggle="tab" href="#bulanini2" role="tab">
                                Bulan Ini
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-bs-toggle="tab" href="#leaderboard" role="tab">
                                Leaderboard
                            </a>
                        </li>
                    </ul>
                    <div class="tab-content mt-1">
                        <div class="tab-pane fade show active" id="bulanini2" role="tabpanel">
                            <div class="scrollmenu">
                            <ul class="listview image-listview">
                                <li>
                                    <div class="item" style="padding: 0px">
                                        <div class="icon-box bg-primary">
                                            <ion-icon name="finger-print-outline"></ion-icon>
                                        </div>
                                        <div class="in">
                                            <div>27 Maret 2023</div>
                                            <div>
                                                <span class="badge badge-info">17:00:00</span>
                                                <span class="badge badge-danger">17:00:00</span>
                                            </div>
                                        </div>
                                    </div>
                                </li> 
                                <li>
                                    <div class="item" style="padding: 0px">
                                        <div class="icon-box bg-primary">
                                            <ion-icon name="finger-print-outline"></ion-icon>
                                        </div>
                                        <div class="in">
                                            <div>27 Maret 2023</div>
                                            <div>
                                                <span class="badge badge-info">17:00:00</span>
                                                <span class="badge badge-danger">17:00:00</span>
                                            </div>
                                        </div>
                                    </div>
                                </li> 
                                <li>
                                    <div class="item" style="padding: 0px">
                                        <div class="icon-box bg-primary">
                                            <ion-icon name="finger-print-outline"></ion-icon>
                                        </div>
                                        <div class="in">
                                            <div>27 Maret 2023</div>
                                            <div>
                                                <span class="badge badge-info">17:00:00</span>
                                                <span class="badge badge-danger">17:00:00</span>
                                            </div>
                                        </div>
                                    </div>
                                </li> 
                                <li>
                                    <div class="item" style="padding: 0px">
                                        <div class="icon-box bg-primary">
                                            <ion-icon name="finger-print-outline"></ion-icon>
                                        </div>
                                        <div class="in">
                                            <div>27 Maret 2023</div>
                                            <div>
                                                <span class="badge badge-info">17:00:00</span>
                                                <span class="badge badge-danger">17:00:00</span>
                                            </div>
                                        </div>
                                    </div>
                                </li> 
                                <li>
                                    <div class="item" style="padding: 0px">
                                        <div class="icon-box bg-primary">
                                            <ion-icon name="finger-print-outline"></ion-icon>
                                        </div>
                                        <div class="in">
                                            <div>27 Maret 2023</div>
                                            <div>
                                                <span class="badge badge-info">17:00:00</span>
                                                <span class="badge badge-danger">17:00:00</span>
                                            </div>
                                        </div>
                                    </div>
                                </li> 
                                <li>
                                    <div class="item" style="padding: 0px">
                                        <div class="icon-box bg-primary">
                                            <ion-icon name="finger-print-outline"></ion-icon>
                                        </div>
                                        <div class="in">
                                            <div>27 Maret 2023</div>
                                            <div>
                                                <span class="badge badge-info">17:00:00</span>
                                                <span class="badge badge-danger">17:00:00</span>
                                            </div>
                                        </div>
                                    </div>
                                </li> 
                                <li>
                                    <div class="item" style="padding: 0px">
                                        <div class="icon-box bg-primary">
                                            <ion-icon name="finger-print-outline"></ion-icon>
                                        </div>
                                        <div class="in">
                                            <div>27 Maret 2023</div>
                                            <div>
                                                <span class="badge badge-info">17:00:00</span>
                                                <span class="badge badge-danger">17:00:00</span>
                                            </div>
                                        </div>
                                    </div>
                                </li> 
                                <li>
                                    <div class="item" style="padding: 0px">
                                        <div class="icon-box bg-primary">
                                            <ion-icon name="finger-print-outline"></ion-icon>
                                        </div>
                                        <div class="in">
                                            <div>27 Maret 2023</div>
                                            <div>
                                                <span class="badge badge-info">17:00:00</span>
                                                <span class="badge badge-danger">17:00:00</span>
                                            </div>
                                        </div>
                                    </div>
                                </li> 
                                <li>
                                    <div class="item" style="padding: 0px">
                                        <div class="icon-box bg-primary">
                                            <ion-icon name="finger-print-outline"></ion-icon>
                                        </div>
                                        <div class="in">
                                            <div>27 Maret 2023</div>
                                            <div>
                                                <span class="badge badge-info">17:00:00</span>
                                                <span class="badge badge-danger">17:00:00</span>
                                            </div>
                                        </div>
                                    </div>
                                </li> 
                                <li>
                                    <div class="item" style="padding: 0px">
                                        <div class="icon-box bg-primary">
                                            <ion-icon name="finger-print-outline"></ion-icon>
                                        </div>
                                        <div class="in">
                                            <div>27 Maret 2023</div>
                                            <div>
                                                <span class="badge badge-info">17:00:00</span>
                                                <span class="badge badge-danger">17:00:00</span>
                                            </div>
                                        </div>
                                    </div>
                                </li> 
                                <li>
                                    <div class="item" style="padding: 0px">
                                        <div class="icon-box bg-primary">
                                            <ion-icon name="finger-print-outline"></ion-icon>
                                        </div>
                                        <div class="in">
                                            <div>27 Maret 2023</div>
                                            <div>
                                                <span class="badge badge-info">17:00:00</span>
                                                <span class="badge badge-danger">17:00:00</span>
                                            </div>
                                        </div>
                                    </div>
                                </li> 
                                <li>
                                    <div class="item" style="padding: 0px">
                                        <div class="icon-box bg-primary">
                                            <ion-icon name="finger-print-outline"></ion-icon>
                                        </div>
                                        <div class="in">
                                            <div>27 Maret 2023</div>
                                            <div>
                                                <span class="badge badge-info">17:00:00</span>
                                                <span class="badge badge-danger">17:00:00</span>
                                            </div>
                                        </div>
                                    </div>
                                </li> 
                                <li>
                                    <div class="item" style="padding: 0px">
                                        <div class="icon-box bg-primary">
                                            <ion-icon name="finger-print-outline"></ion-icon>
                                        </div>
                                        <div class="in">
                                            <div>27 Maret 2023</div>
                                            <div>
                                                <span class="badge badge-info">17:00:00</span>
                                                <span class="badge badge-danger">17:00:00</span>
                                            </div>
                                        </div>
                                    </div>
                                </li> 
                                <li>
                                    <div class="item" style="padding: 0px">
                                        <div class="icon-box bg-primary">
                                            <ion-icon name="finger-print-outline"></ion-icon>
                                        </div>
                                        <div class="in">
                                            <div>27 Maret 2023</div>
                                            <div>
                                                <span class="badge badge-info">17:00:00</span>
                                                <span class="badge badge-danger">17:00:00</span>
                                            </div>
                                        </div>
                                    </div>
                                </li> 
                                <li>
                                    <div class="item" style="padding: 0px">
                                        <div class="icon-box bg-primary">
                                            <ion-icon name="finger-print-outline"></ion-icon>
                                        </div>
                                        <div class="in">
                                            <div>27 Maret 2023</div>
                                            <div>
                                                <span class="badge badge-info">17:00:00</span>
                                                <span class="badge badge-danger">17:00:00</span>
                                            </div>
                                        </div>
                                    </div>
                                </li> 
                            </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div> --}}

    </div>
    <!-- * App Capsule -->

    <br>

    <!-- App Bottom Menu -->
    <div class="appBottomMenu">
        <a href="/dashboard" class="item active">
            <div class="col">
                <ion-icon name="file-tray-full-outline"></ion-icon>
                <strong>Home</strong>
            </div>
        </a>
        <a href="/histori" class="item">
            <div class="col">
                <ion-icon name="list-circle-outline"></ion-icon>
                <strong>Riwayat</strong>
            </div>
        </a>
        <a href="/presensi/create" class="item">
            <div class="col">
                <div class="action-button large">
                    <ion-icon name="finger-print"></ion-icon>
                </div>
            </div>
        </a>
        <a href="/ijin" class="item">
            <div class="col">
                <ion-icon name="document-text-outline"></ion-icon>
                <strong>Ijin</strong>
            </div>
        </a>
        <a href="/profile" class="item">
            <div class="col">
                <ion-icon name="person-outline"></ion-icon>
                <strong>Profil</strong>
            </div>
        </a>
    </div>
    <!-- * App Bottom Menu -->

    <!-- App Sidebar -->
    <div class="modal fade panelbox panelbox-left" id="sidebarPanel" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body p-0">
                    <!-- profile box -->
                    <div class="profileBox pt-2 pb-2">
                        <div class="image-wrapper">
                            @if (!empty(Auth::guard('karyawan')->user()->foto))
                            @php
                                $path = Storage::url('uploads/karyawan/'.Auth::guard('karyawan')->user()->foto);
                            @endphp
                            <img src="{{ url($path) }}" alt="image" class="imaged  w36">
                            @else
                            <img src="{{ asset('storage/uploads/karyawan/default.png') }}" alt="image" class="imaged  w36">
                            @endif
                        </div>
                        <div class="in">
                            <strong>{{ Auth::guard('karyawan')->user()->nama_lengkap }}</strong>
                            <div class="text-muted">{{ Auth::guard('karyawan')->user()->nik }}</div>
                        </div>
                        <a href="#" class="btn btn-link btn-icon sidebar-close" data-bs-dismiss="modal">
                            <ion-icon name="close-outline"></ion-icon>
                        </a>
                    </div>
                    <!-- * profile box -->
                    <!-- balance -->
                    <div class="sidebar-balance">
                        <div class="listview-title">{{ format_hari_tanggal($date); }}</div>
                        <div class="in">
                            <h1 id="jam" class="amount"></h1>
                        </div>
                    </div>
                    <!-- * balance -->

                    <!-- menu -->
                    <div class="listview-title mt-1">Menu</div>
                    <ul class="listview flush transparent no-line image-listview">
                        <li>
                            <a href="/proseslogout" class="item">
                                <div class="icon-box bg-primary">
                                    <ion-icon name="log-out-outline"></ion-icon>
                                </div>
                                <div class="in">
                                    Logout
                                </div>
                            </a>
                        </li>
                    </ul>
                    <!-- * menu -->

                </div>
            </div>
        </div>
    </div>
    <!-- * App Sidebar -->


    <!-- ========= JS Files =========  -->
    <!-- Jquery -->
    <script src="{{asset('assets/js/lib/jquery-3.4.1.min.js')}}"></script>
    <!-- Bootstrap -->
    <script src="{{asset('assets/js/lib/bootstrap.bundle.min.js')}}"></script>
    <script src="{{asset('assets/js/lib/popper.min.js')}}"></script>
    <!-- Ionicons -->
    <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>
    <!-- Splide -->
    <script src="{{ asset('assets/js/plugins/splide/splide.min.js') }}"></script>
    <!-- Apex Charts -->
    <script src="{{ asset('assets/js/plugins/apexcharts/apexcharts.min.js') }}"></script>
    <!-- Owl Carousel -->
    <script src="{{asset('assets/js/plugins/owl-carousel/owl.carousel.min.js')}}"></script>
    <!-- jQuery Circle Progress -->
    <script src="{{asset('assets/js/plugins/jquery-circle-progress/circle-progress.min.js')}}"></script>
    <script src="https://cdn.amcharts.com/lib/4/core.js"></script>
    <script src="https://cdn.amcharts.com/lib/4/charts.js"></script>
    <script src="https://cdn.amcharts.com/lib/4/themes/animated.js"></script>
    <!-- SweetAlert -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <!-- Base Js File -->
    <script src="{{ asset('assets/js/base.js') }}"></script>

    <script type="text/javascript">
        window.onload = function() {
            jam();
        }
     
        function jam() {
            var e = document.getElementById('jam')
                , d = new Date()
                , h, m, s;
            h = d.getHours();
            m = set(d.getMinutes());
            s = set(d.getSeconds());
     
            e.innerHTML = h + ':' + m + ':' + s;
     
            setTimeout('jam()', 1000);
        }
     
        function set(e) {
            e = e < 10 ? '0' + e : e;
            return e;
        }
     
    </script>

</body>

</html>