<!doctype html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="theme-color" content="#000000">
    <title>Lokasi Saya</title>
    <meta http-equiv="Cache-Control" content="no-cache" />
    <meta name="description" content="E-Presensi Geolocation">
    <meta name="keywords" content="" />
    <link rel="icon" type="image/png" href="{{ asset('assets/img/favicon.png')}}" sizes="32x32">
    <link rel="apple-touch-icon" sizes="180x180" href="{{ asset('assets/img/icon/192x192.png')}}">
    <link rel="stylesheet" href="{{ asset('assets/css/style.css')}}">
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css"/>
    <link rel="manifest" href="__manifest.json">
    <style>
        #map { 
            height: 550px;
            border-radius: 15px;
        }
    </style>
</head>

<body>

    <!-- loader -->
    <div id="loader">
        <img src="{{ asset('assets/img/loading-icon.png')}}" alt="icon" class="loading-icon">
    </div>
    <!-- * loader -->

    <!-- App Header -->
    <div class="appHeader">
        <div class="left">
            <a href="/dashboard" class="headerButton goBack">
                <ion-icon name="chevron-back-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">Lokasi Saya</div>
        <div class="right">
        </div>
    </div>
    <!-- * App Header -->

    <!-- App Capsule -->
    <div id="appCapsule">
        <div class="section full mt-1">
            <div class="col">
                <div class="card">
                    <div class="card-body" style="padding: 10px;">
                        <div class="row">
                            <div class="col">
                                <input type="hidden" id="lokasi">
                                <div id="map"></div>
                            </div>
                        </div>   
                    </div>
                </div>
                <div class="form-group boxed">
                    <div class="input-wrapper">
                        <a href="/dashboard" type="button" class="btn btn-primary btn-block">
                            <ion-icon name="arrow-back-circle-outline"></ion-icon>
                            Beranda
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- * App Capsule -->

    <!-- App Bottom Menu -->
    <div class="appBottomMenu">
        <a href="/dashboard" class="item active">
            <div class="col">
                <ion-icon name="file-tray-full-outline"></ion-icon>
                <strong>Home</strong>
            </div>
        </a>
        <a href="/histori" class="item">
            <div class="col">
                <ion-icon name="list-circle-outline"></ion-icon>
                <strong>Riwayat</strong>
            </div>
        </a>
        <a href="/presensi/create" class="item">
            <div class="col">
                <div class="action-button large">
                    <ion-icon name="finger-print"></ion-icon>
                </div>
            </div>
        </a>
        <a href="/ijin" class="item">
            <div class="col">
                <ion-icon name="document-text-outline"></ion-icon>
                <strong>Ijin</strong>
            </div>
        </a>
        <a href="/profile" class="item">
            <div class="col">
                <ion-icon name="person-outline"></ion-icon>
                <strong>Profil</strong>
            </div>
        </a>
    </div>
    <!-- * App Bottom Menu -->



    <!-- ========= JS Files =========  -->
    <!-- Jquery -->
    <script src="{{asset('assets/js/lib/jquery-3.4.1.min.js')}}"></script>
    <!-- Bootstrap -->
    <script src="{{asset('assets/js/lib/bootstrap.bundle.min.js')}}"></script>
    <script src="{{asset('assets/js/lib/popper.min.js')}}"></script>
    <!-- Ionicons -->
    <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>
    <!-- Webcam -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/webcamjs/1.0.26/webcam.min.js"></script>
    <!-- Maps -->
    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
    <!-- Splide -->
    <script src="{{asset('assets/js/plugins/splide/splide.min.js')}}"></script>
    <!-- Owl Carousel -->
    <script src="{{asset('assets/js/plugins/owl-carousel/owl.carousel.min.js')}}"></script>
    <!-- jQuery Circle Progress -->
    <script src="{{asset('assets/js/plugins/jquery-circle-progress/circle-progress.min.js')}}"></script>
    <script src="https://cdn.amcharts.com/lib/4/core.js"></script>
    <script src="https://cdn.amcharts.com/lib/4/charts.js"></script>
    <script src="https://cdn.amcharts.com/lib/4/themes/animated.js"></script>
    <!-- SweetAlert -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <!-- Base Js File -->
    <script src="{{asset('assets/js/base.js')}}"></script>

    <script>
        $(function(){
            $("#timer-alert").fadeTo(2000, 500).slideUp(500, function(){
                $("#timer-alert").slideUp(500);
            });
        });

        var lokasi = document.getElementById('lokasi');
        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(successCallback, errorCallback);
        }

        function successCallback(position) {
            lokasi.value = position.coords.latitude + "," + position.coords.longitude;

            var map = L.map('map').setView([position.coords.latitude, position.coords.longitude], 17);

            L.tileLayer('http://{s}.google.com/vt/lyrs=m&x={x}&y={y}&z={z}',{
                maxZoom: 20,
                subdomains:['mt0','mt1','mt2','mt3']
            }).addTo(map);

            var marker = L.marker([position.coords.latitude, position.coords.longitude]).addTo(map);
            //Lokasi Kantor
            var lat_kantor = {{ $lokasi_kantor->latitude }}
            var long_kantor = {{ $lokasi_kantor->longitude }}
            var radius = {{ $lokasi_kantor->radius }}
            var circle = L.circle([lat_kantor, long_kantor], {
                color: 'red',
                fillColor: '#f03',
                fillOpacity: 0.5,
                radius: radius
            }).addTo(map);
        }

        function errorCallback() {

        }
        
    </script>

</body>

</html>