@include('layouts.admin.header')

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="{{ asset('assets/panel/img/favicon/favicon.ico') }}" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet" />

    <!-- Icons -->
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/fonts/fontawesome.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/fonts/tabler-icons.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/fonts/flag-icons.css') }}" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/css/rtl/core.css') }}" class="template-customizer-core-css" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/css/rtl/theme-default.css') }}" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="{{ asset('assets/panel/css/demo.css') }}" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/perfect-scrollbar/perfect-scrollbar.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/node-waves/node-waves.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/typeahead-js/typeahead.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/animate-css/animate.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/sweetalert2/sweetalert2.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/panel/vendor/libs/datatables-bs5/datatables.bootstrap5.css') }}">
    
    <!-- Page CSS -->

    <!-- Helpers -->
    <script src="{{ asset('assets/panel/vendor/js/helpers.js') }}"></script>
    <!-- Template customizer  -->
    <script src="{{ asset('assets/panel/vendor/js/template-customizer.js') }}"></script>
    <!-- Mandatory theme config file  -->
    <script src="{{ asset('assets/panel/js/config.js') }}"></script>
  </head>

  <body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
      <div class="layout-container">
        <!-- Menu -->
        <x-sidebar></x-sidebar>
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page">
          <!-- Navbar -->
          @include('layouts.admin.navbar')
          <!-- / Navbar -->

          <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->

            <div class="container-xxl flex-grow-1 container-p-y">
              <h4 class="fw-bold py-3 mb-4">Kantor Cabang</h4>
              <!-- Hoverable Table rows -->
              <div class="card">
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col">
                        <button type="button" class="btn btn-primary waves-effect waves-light" data-bs-toggle="modal" data-bs-target="#modal-tambah-kantor">
                            <span class="ti-xs ti ti-circle-plus me-1"></span>Tambah Data
                        </button>
                        </div>
                    </div>
                    <div class="row mb-2">
                      <div class="col">
                        @php
                            $messagesuccess = Session::get('success');
                            $messageerror = Session::get('error');
                        @endphp
                        @if (Session::get('success'))
                        <div class="alert alert-success alert-dismissible" role="alert" id="timer-alert">
                            {{ $messagesuccess }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                        @endif
                        @if (Session::get('error'))
                        <div class="alert alert-danger alert-dismissible" role="alert" id="timer-alert">
                            {{ $messageerror }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                        @endif
                      </div>
                    </div>
                    <div class="table-responsive text-nowrap">
                        <table id="cabang" class="table table-hover" style="width:100%">
                            <thead class="table-light">
                              <tr class="text-nowrap">
                                  <th style="text-align: center;">No.</th>
                                  <th style="text-align: center;">Kode Cab</th>
                                  <th style="text-align: center;">Nama Cabang</th>
                                  <th style="text-align: center;">Lat-Long</th>
                                  <th style="text-align: center;">Radius</th>
                                  <th style="width: 20px; text-align: center;">Aksi</th>
                              </tr>
                          </thead>
                          <tbody class="table-border-bottom-0">
                              @foreach ($kantorcabang as $d)
                              <tr>
                                <td style="text-align: center;">{{ $loop->iteration }}.</td>
                                <td style="text-align: center;">{{ $d->kode_cabang }}</td>
                                <td>
                                    {{ $d->nama_cabang }} <br>
                                    <span style="font-size: 10px;">{{ $d->alamat_cabang }}</span>
                                    
                                </td>
                                <td>
                                    Lat: {{ $d->latitude }} <br>
                                    Long: {{ $d->longitude }}
                                </td>
                                <td style="text-align: center;">{{ $d->radius }} Meter</td>
                                <td>
                                    <div class="d-flex align-items-center">
                                    {{-- <a href="#" class="btn text-primary" style="padding: 0px;" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="Detail"><i class="ti ti-eye ti-xs me-2"></i></a> --}}
                                    <a href="#" class="btn text-success edit" style="padding: 0px;" id="{{ $d->id }}" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="Edit"><i class="ti ti-edit ti-xs me-2"></i></a>
                                    <form action="/panel/cabang/{{ $d->id }}/delete" method="POST">
                                        @csrf
                                        <a class="btn text-danger delete-confirm" style="padding: 0px;" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="Hapus"><i class="ti ti-trash ti-xs"></i></a>
                                    </form>
                                    </div>
                                </td>
                              </tr>
                              @endforeach
                          </tbody>
                      </table>
                    </div>
                </div>
              </div>
              <!--/ Hoverable Table rows -->

              <!-- Modal Tambah Kantor Cabang -->
              <div class="modal fade" id="modal-tambah-kantor" tabindex="-1" aria-hidden="true">
                <div class="modal-dialog" role="document">
                  <div class="modal-content">
                    <div class="modal-header">
                      <h5 class="modal-title" id="modalCenterTitle">Tambah Kantor Cabang</h5>
                      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                      <form action="/tambahcabang" method="POST" id="tbhcabang">
                        @csrf
                        <div class="row">
                            <div class="col-4 mb-3">
                                <label for="kode_cabang" class="form-label">Kode</label>
                                <input type="text" id="kode_cabang" name="kode_cabang" class="form-control" placeholder="Kode" />
                            </div>
                            <div class="col-8 mb-3">
                                <label for="nama_cabang" class="form-label">Nama Kantor Cabang</label>
                                <input type="text" id="nama_cabang" name="nama_cabang" class="form-control" placeholder="Nama Kantor Cabang" />
                            </div>
                        </div>
                        <div class="row">
                            <div class="col mb-3">
                                <label for="alamat_cabang" class="form-label">Alamat</label>
                                <input type="text" id="alamat_cabang" name="alamat_cabang" class="form-control" placeholder="Alamat" />
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-6 mb-3">
                                <label for="latitude" class="form-label">Latitude</label>
                                <input type="text" id="latitude" name="latitude" class="form-control" placeholder="Contoh: -8.341272" />
                            </div>
                            <div class="col-6 mb-3">
                                <label for="longitude" class="form-label">Longitude</label>
                                <input type="text" id="longitude" name="longitude" class="form-control" placeholder="Contoh: 113.6332" />
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-4 mb-3">
                                <label   label for="radius" class="form-label">Radius (Meter)</label>
                                <input type="text" id="radius" name="radius" class="form-control" placeholder="Contoh: 100" />
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-label-secondary" data-bs-dismiss="modal">
                                Batal
                            </button>
                            <button type="submit" class="btn btn-primary">Tambah</button>
                        </div>
                      </form>
                    </div>
                  </div>
                </div>
              </div>

              <!-- Modal Edit Kantor Cabang -->
              <div class="modal fade" id="modal-edit-kantor" tabindex="-1" aria-hidden="true">
                <div class="modal-dialog" role="document">
                  <div class="modal-content">
                    <div class="modal-header">
                      <h5 class="modal-title" id="modalCenterTitle">Edit Kantor Cabang</h5>
                      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body" id="loadeditcabangform">
                      
                    </div>
                  </div>
                </div>
              </div>
              
            </div>
            <!-- / Content -->

            <!-- Footer -->
            @include('layouts.admin.footer')
            <!-- / Footer -->

            <div class="content-backdrop fade"></div>
          </div>
          <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
      </div>

      <!-- Overlay -->
      <div class="layout-overlay layout-menu-toggle"></div>

      <!-- Drag Target Area To SlideIn Menu On Small Screens -->
      <div class="drag-target"></div>
    </div>
    <!-- / Layout wrapper -->

    <!-- Core JS -->
    <!-- build:js assets/vendor/js/core.js -->
    <script src="{{ asset('assets/panel/vendor/libs/jquery/jquery.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/libs/popper/popper.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/js/bootstrap.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/libs/perfect-scrollbar/perfect-scrollbar.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/libs/node-waves/node-waves.js') }}"></script>

    <script src="{{ asset('assets/panel/vendor/libs/hammer/hammer.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/libs/i18n/i18n.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/libs/typeahead-js/typeahead.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/libs/datatables-bs5/1.13.6/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/panel/vendor/libs/datatables-bs5/datatables-bootstrap5.js') }}"></script>

    <script src="{{ asset('assets/panel/vendor/js/menu.js') }}"></script>
    <!-- endbuild -->

    <!-- Vendors JS -->
    <script src="{{ asset('assets/panel/vendor/libs/sweetalert2/sweetalert2.js') }}"></script>

    <!-- Main JS -->
    <script src="{{ asset('assets/panel/js/main.js') }}"></script>

    <!-- Page JS -->
    <script src="{{ asset('assets/panel/js/extended-ui-sweetalert2.js') }}"></script>

    <script>
        $(function(){
            $("#timer-alert").fadeTo(2000, 500).slideUp(500, function(){
                $("#timer-alert").slideUp(500);
            });

            new DataTable('#cabang');
            
            $("#tbhcabang").submit(function(){
                var kode_cabang = $("#kode_cabang").val();
                var nama_cabang = $("#nama_cabang").val();
                var alamat_cabang = $("#alamat_cabang").val();
                var latitude = $("#latitude").val();
                var longitude = $("#longitude").val();
                var radius = $("#radius").val();
                if(kode_cabang == '') {
                    Swal.fire({
                        title: 'Maaf!',
                        text: 'Kode Cabang Wajib Diisi',
                        icon: 'warning'
                        });
                    return false;
                } else if(nama_cabang == '') {
                    Swal.fire({
                        title: 'Maaf!',
                        text: 'Nama Kantor Cabang Wajib Diisi',
                        icon: 'warning'
                        });
                    return false;
                } else if(alamat_cabang == '') {
                    Swal.fire({
                        title: 'Maaf!',
                        text: 'Alamat Wajib Diisi',
                        icon: 'warning'
                        });
                    return false;
                } else if(latitude == '') {
                    Swal.fire({
                        title: 'Maaf!',
                        text: 'Latitude Wajib Diisi',
                        icon: 'warning'
                        });
                    return false;
                } else if(longitude == '') {
                    Swal.fire({
                        title: 'Maaf!',
                        text: 'Longitude Wajib Diisi',
                        icon: 'warning'
                        });
                    return false;
                } else if(radius == '') {
                    Swal.fire({
                        title: 'Maaf!',
                        text: 'Radius Wajib Diisi',
                        icon: 'warning'
                        });
                    return false;
                }
            });

            $(".edit").click(function(){
                var id = $(this).attr('id');
                $.ajax({
                    type:'POST',
                    url:'/panel/cabang/edit',
                    cache:false,
                    data:{
                        _token:"{{ csrf_token(); }}",
                        id:id
                    },
                    success:function(respond){
                        $("#loadeditcabangform").html(respond);
                    }
                });
                $("#modal-edit-kantor").modal("show");
            });

            $(".delete-confirm").click(function(e) {
                var form = $(this).closest('form');
                e.preventDefault();
                Swal.fire({
                    title: 'Anda Yakin?',
                    text: "Data Kantor Ini Akan Di Hapus",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#6658dd',
                    cancelButtonColor: '#f1556c',
                    cancelButtonText: 'Batal',
                    confirmButtonText: 'Ya, Hapus'
                    }).then((result) => {
                    if (result.isConfirmed) {
                        form.submit();
                        Swal.fire(
                        'Mantab!',
                        'Hapus Kantor Berhasil.',
                        'success'
                        )
                    }
                    });
                    return false;
            });
        });
    </script>
</body>
</html>
