<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class UserController extends Controller
{
    public function index()
    {
        $title = 'User - Administrator';
        $user = DB::table('users')->get();
        return view('user.index', compact('title', 'user'));
    }

    public function profil()
    {
        $title = 'Profil - Administrator';
        $id = Auth::guard('user')->user()->id;
        $user = DB::table('users')->where('id', $id)->first();
        return view('user.profil', compact('title', 'user'));
    }

    public function updatepassword($id, Request $request)
    {
        $password = Hash::make($request->password);
        $data = [
            'password' => $password
        ];

        $update = DB::table('users')->where('id', $id)->update($data);
        if ($update) {
            return redirect('/panel/profil')->with(['success' => 'Password Berhasil Di Update']);
        } else {
            return redirect('/panel/profil')->with(['error' => 'Update Password Gagal']);
        }
    }
}
