<?php

namespace App\Http\Controllers;

use App\Models\Karyawan;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Storage;

class PresensiController extends Controller
{
    public function gethari()
    {
        $hari = date("D");

        switch ($hari) {
            case 'Sun':
                $hari_ini = "Minggu";
                break;

            case 'Mon':
                $hari_ini = "Senin";
                break;

            case 'Tue':
                $hari_ini = "Selasa";
                break;

            case 'Wed':
                $hari_ini = "Rabu";
                break;

            case 'Thu':
                $hari_ini = "Kamis";
                break;

            case 'Fri':
                $hari_ini = "Jumat";
                break;

            case 'Sat':
                $hari_ini = "Sabtu";
                break;

            default:
                $hari_ini = "Tidak di Ketahui";
                break;
        }

        return $hari_ini;
    }

    public function create()
    {
        $hariini = date("Y-m-d");
        $namahari = $this->gethari();
        $nik = Auth::guard('karyawan')->user()->nik;
        $kode_dept = Auth::guard('karyawan')->user()->kode_dept;
        $cek = DB::table('presensi')->where('tgl_presensi', $hariini)->where('nik', $nik)->first();
        $kode_cabang = Auth::guard('karyawan')->user()->kode_cabang;
        $lokasi_kantor = DB::table('kantorcabang')->where('kode_cabang', $kode_cabang)->first();
        $jamkerja = DB::table('konfigurasi_jamkerja')
            ->join('jam_kerja', 'konfigurasi_jamkerja.kode_jam_kerja', '=', 'jam_kerja.kode_jam_kerja')
            ->where('nik', $nik)
            ->where('hari', $namahari)
            ->first();

        if ($jamkerja == null) {
            $jamkerja = DB::table('konfigurasi_jk_dept_detail')
                ->join('konfigurasi_jk_dept', 'konfigurasi_jk_dept_detail.kode_jk_dept', '=', 'konfigurasi_jk_dept.kode_jk_dept')
                ->join('jam_kerja', 'konfigurasi_jk_dept_detail.kode_jam_kerja', '=', 'jam_kerja.kode_jam_kerja')
                //fungsi kode_cabang di bawah ini aktifkan jika fungsi jam kerja
                //sesuai dengan lokasi kantor di aktifkan, jika tidak maka lokasi kantor
                //tidak berpengaruh pada jam kerja//
                //->where('kode_cabang', $kode_cabang)
                ->where('kode_dept', $kode_dept)
                ->where('hari', $namahari)
                ->first();
        }

        if ($jamkerja == null) {
            return view('presensi.notifjamkerja');
        } else {
            return view('presensi.create', compact('cek', 'lokasi_kantor', 'jamkerja'));
        }
    }

    public function store(Request $request)
    {
        $nik = Auth::guard('karyawan')->user()->nik;
        $kode_dept = Auth::guard('karyawan')->user()->kode_dept;
        $kode_cabang = Auth::guard('karyawan')->user()->kode_cabang;
        $tgl_presensi = date("Y-m-d");
        $jam = date("H:i:s");
        $lokasi_kantor = DB::table('kantorcabang')->where('kode_cabang', $kode_cabang)->first();
        $latitudekantor = $lokasi_kantor->latitude;
        $longitudekantor = $lokasi_kantor->longitude;
        // $latitudekantor = -8.341192768662394;
        // $longitudekantor = 113.63305310775826;
        $lokasi = $request->lokasi;
        $lokasiuser = explode(",", $lokasi);
        $latitudeuser = $lokasiuser[0];
        $longitudeuser = $lokasiuser[1];
        $jarak = $this->distance($latitudekantor, $longitudekantor, $latitudeuser, $longitudeuser);
        $radius = round($jarak["meters"]);
        $namahari = $this->gethari();
        $jamkerja = DB::table('konfigurasi_jamkerja')
            ->join('jam_kerja', 'konfigurasi_jamkerja.kode_jam_kerja', '=', 'jam_kerja.kode_jam_kerja')
            ->where('nik', $nik)
            ->where('hari', $namahari)
            ->first();

        if ($jamkerja == null) {
            $jamkerja = DB::table('konfigurasi_jk_dept_detail')
                ->join('konfigurasi_jk_dept', 'konfigurasi_jk_dept_detail.kode_jk_dept', '=', 'konfigurasi_jk_dept.kode_jk_dept')
                ->join('jam_kerja', 'konfigurasi_jk_dept_detail.kode_jam_kerja', '=', 'jam_kerja.kode_jam_kerja')
                //fungsi kode_cabang di bawah ini aktifkan jika fungsi jam kerja
                //sesuai dengan lokasi kantor di aktifkan, jika tidak maka lokasi kantor
                //tidak berpengaruh pada jam kerja//
                //->where('kode_cabang', $kode_cabang)
                ->where('kode_dept', $kode_dept)
                ->where('hari', $namahari)
                ->first();
        }

        $image = $request->image;
        $folderPath = "public/uploads/absensi/";
        $formatName = $nik . "-" . $tgl_presensi;
        $image_parts = explode(";base64", $image);
        $image_base64 = base64_decode($image_parts[1]);
        $fileNameIn = $formatName . "-in" . ".png";
        $fileNameOut = $formatName . "-out" . ".png";
        $fileIn = $folderPath . $fileNameIn;
        $fileOut = $folderPath . $fileNameOut;

        $cek = DB::table('presensi')->where('tgl_presensi', $tgl_presensi)->where('nik', $nik)->count();
        if ($radius > $lokasi_kantor->radius) {
            echo "error|Anda berada di luar radius, jarak Anda " . $radius . " meter dari kantor|";
        } else {
            if ($cek > 0) {
                if ($jam < $jamkerja->jam_pulang_awal) {
                    echo "error|Belum Waktunya Absen Pulang|out";
                } else if ($jam > $jamkerja->jam_pulang_akhir) {
                    echo "error|Waktu Absen Pulang Sudah Habis|out";
                } else {
                    $data_pulang = [
                        'jam_out' => $jam,
                        'foto_out' => $fileNameOut,
                        'lokasi_out' => $lokasi,
                    ];
                    $update = DB::table('presensi')->where('tgl_presensi', $tgl_presensi)->where('nik', $nik)->update($data_pulang);
                    if ($update) {
                        echo "success|Absen Pulang Berhasil|out";
                        Storage::put($fileOut, $image_base64);
                    } else {
                        echo "error|Absen Pulang Gagal|out";
                    }
                }
            } else {
                if ($jam < $jamkerja->jam_masuk_awal) {
                    echo "error|Belum Waktunya Absen Masuk|in";
                } else if ($jam > $jamkerja->jam_pulang_awal) {
                    echo "error|Waktu Absen Masuk Sudah Habis|in";
                } else {
                    $data = [
                        'nik' => $nik,
                        'tgl_presensi' => $tgl_presensi,
                        'jam_in' => $jam,
                        'foto_in' => $fileNameIn,
                        'lokasi_in' => $lokasi,
                        'kode_jam_kerja' => $jamkerja->kode_jam_kerja,
                        'status' => 'h',
                    ];
                    $simpan = DB::table('presensi')->insert($data);
                    if ($simpan) {
                        echo "success|Absen Masuk Berhasil|in";
                        Storage::put($fileIn, $image_base64);
                    } else {
                        echo "error|Absen Masuk Gagal|in";
                    }
                }
            }
        }
    }

    //Menghitung Jarak
    function distance($lat1, $lon1, $lat2, $lon2)
    {
        $theta = $lon1 - $lon2;
        $miles = (sin(deg2rad($lat1)) * sin(deg2rad($lat2))) + (cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * cos(deg2rad($theta)));
        $miles = acos($miles);
        $miles = rad2deg($miles);
        $miles = $miles * 60 * 1.1515;
        $feet = $miles * 5280;
        $yards = $feet / 3;
        $kilometers = $miles * 1.609344;
        $meters = $kilometers * 1000;
        return compact('meters');
    }

    public function profile()
    {
        $nik = Auth::guard('karyawan')->user()->nik;
        $karyawan = DB::table('karyawan')->where('nik', $nik)->first();
        return view('presensi.profile', compact('karyawan'));
    }

    public function editprofile()
    {
        $nik = Auth::guard('karyawan')->user()->nik;
        $karyawan = DB::table('karyawan')->where('nik', $nik)->first();
        return view('presensi.editprofile', compact('karyawan'));
    }

    public function updateprofile(Request $request)
    {
        $nik = Auth::guard('karyawan')->user()->nik;
        $nama_lengkap = $request->nama_lengkap;
        $tgl_lahir = $request->tgl_lahir;
        $email = $request->email;
        $no_hp = $request->no_hp;
        $password = Hash::make($request->password);
        $old_foto = $request->old_foto;

        if ($request->hasFile('foto')) {
            $foto = $nik . "." . $request->file('foto')->getClientOriginalExtension();
        } else {
            $foto = $old_foto;
        }
        if (empty($request->password)) {
            $data = [
                'nama_lengkap' => $nama_lengkap,
                'tgl_lahir' => $tgl_lahir,
                'email' => $email,
                'no_hp' => $no_hp,
                'foto' => $foto
            ];
        } else {
            $data = [
                'nama_lengkap' => $nama_lengkap,
                'tgl_lahir' => $tgl_lahir,
                'email' => $email,
                'no_hp' => $no_hp,
                'foto' => $foto,
                'password' => $password
            ];
        }

        try {
            DB::table('karyawan')->where('nik', $nik)->update($data);
            if ($request->hasFile('foto')) {
                $folderPath = "public/uploads/karyawan/";
                $folderPathOld = "public/uploads/karyawan/" . $old_foto;
                Storage::delete($folderPathOld);
                $request->file('foto')->storeAs($folderPath, $foto);
            }
            return redirect('/profile')->with(['success' => 'Data Berhasil di Ubah']);
        } catch (\Exception $e) {
            return redirect('/profile')->with(['error' => 'Update Data Gagal']);
        }
    }

    public function histori()
    {
        $namabulan = ["", "Januari", "Februari", "Maret", "April", "Mei", "Juni", "Juli", "Agustus", "September", "Oktober", "November", "Desember"];
        return view('presensi.histori', compact('namabulan'));
    }

    public function gethistori(Request $request)
    {
        $bulan = $request->bulan;
        $tahun = $request->tahun;
        $nik = Auth::guard('karyawan')->user()->nik;

        $histori = DB::table('presensi')
            ->leftJoin('jam_kerja', 'presensi.kode_jam_kerja', '=', 'jam_kerja.kode_jam_kerja')
            ->whereRaw('MONTH(tgl_presensi)="' . $bulan . '"')
            ->whereRaw('YEAR(tgl_presensi)="' . $tahun . '"')
            ->where('nik', $nik)
            ->orderBy('tgl_presensi')
            ->get();

        return view('presensi.gethistori', compact('histori'));
    }

    public function ijin(Request $request)
    {
        $nik = Auth::guard('karyawan')->user()->nik;
        $bulanini = date("m") * 1;
        $tahunini = date("Y");

        if (!empty($request->bulan) && !empty($request->tahun)) {
            $dataijin = DB::table('pengajuan_ijin')
                ->leftJoin('master_cuti', 'pengajuan_ijin.kode_cuti', '=', 'master_cuti.kode_cuti')
                ->orderBy('tgl_ijin_dari')
                ->where('nik', $nik)
                ->whereRaw('MONTH(tgl_ijin_dari)="' . $request->bulan . '"')
                ->whereRaw('YEAR(tgl_ijin_dari)="' . $request->tahun . '"')
                ->get();
        } else {
            $dataijin = DB::table('pengajuan_ijin')
                ->leftJoin('master_cuti', 'pengajuan_ijin.kode_cuti', '=', 'master_cuti.kode_cuti')
                ->orderBy('tgl_ijin_dari')
                ->where('nik', $nik)
                ->whereRaw('MONTH(tgl_ijin_dari)="' . $bulanini . '"')
                ->whereRaw('YEAR(tgl_ijin_dari)="' . $tahunini . '"')
                ->get();
        }


        $namabulan = ["", "Januari", "Februari", "Maret", "April", "Mei", "Juni", "Juli", "Agustus", "September", "Oktober", "November", "Desember"];
        return view('presensi.ijin', compact('dataijin', 'namabulan'));
    }

    // public function buatijin()
    // {
    //     return view('presensi.ijinbuat');
    // }

    // public function storeijin(Request $request)
    // {
    //     $nik = Auth::guard('karyawan')->user()->nik;
    //     $tgl_skrg = date("Y-m-d");
    //     $tgl_ijin = $request->tgl_ijin;
    //     $status = $request->status;
    //     $keterangan = $request->keterangan;

    //     if ($request->hasFile('file_surat')) {
    //         $file_surat = $tgl_skrg . "-" . $nik . "." . $request->file('file_surat')->getClientOriginalExtension();
    //     } else {
    //         $file_surat = null;
    //     }
    //     if (empty($request->file_surat)) {
    //         $data = [
    //             'nik' => $nik,
    //             'tgl_ijin' => $tgl_ijin,
    //             'status' => $status,
    //             'keterangan' => $keterangan,
    //             'time' => time()
    //         ];
    //     } else {
    //         $data = [
    //             'nik' => $nik,
    //             'tgl_ijin' => $tgl_ijin,
    //             'status' => $status,
    //             'keterangan' => $keterangan,
    //             'time' => time(),
    //             'file_surat' => $file_surat
    //         ];
    //     }

    //     $simpan = DB::table('pengajuan_ijin')->insert($data);
    //     if ($simpan) {
    //         if ($request->hasFile('file_surat')) {
    //             $folderPath = "public/uploads/file_ijin/";
    //             $request->file('file_surat')->storeAs($folderPath, $file_surat);
    //         }
    //         return redirect('/ijin')->with(['success' => 'Data Ajuan Ijin Berhasil di Simpan']);
    //     } else {
    //         return redirect('/ijin')->with(['error' => 'Data Ajuan Ijin Gagal']);
    //     }
    // }

    public function cekpengajuanijin(Request $request)
    {
        $tgl_ijin = $request->tgl_ijin;
        $nik = Auth::guard('karyawan')->user()->nik;

        $cek = DB::table('pengajuan_ijin')->where('nik', $nik)->where('tgl_ijin', $tgl_ijin)->count();
        return $cek;
    }

    public function deleteijin($unik_ijin)
    {
        $delete = DB::table('pengajuan_ijin')->where('unik$unik_ijin', $unik_ijin)->delete();
        if ($delete) {
            return Redirect::back()->with(['success' => 'Data Ijin Berhasil Di Hapus']);
        } else {
            return Redirect::back()->with(['error' => 'Data Gagal Di Hapus']);
        }
    }

    public function monitoring()
    {
        $title = 'Monitoring - Administrator';
        return view('presensi.monitoring', compact('title'));
    }

    public function getpresensi(Request $request)
    {
        $tanggal = $request->tanggal;
        $presensi = DB::table('presensi')
            ->select('presensi.*', 'nama_lengkap', 'nama_dept', 'jam_masuk_akhir', 'keterangan')
            ->leftJoin('jam_kerja', 'presensi.kode_jam_kerja', '=', 'jam_kerja.kode_jam_kerja')
            ->leftJoin('pengajuan_ijin', 'presensi.unik_ijin', '=', 'pengajuan_ijin.unik_ijin')
            ->join('karyawan', 'presensi.nik', '=', 'karyawan.nik')
            ->join('departement', 'karyawan.kode_dept', '=', 'departement.kode_dept')
            ->where('tgl_presensi', $tanggal)
            ->get();

        return view('presensi.getpresensi', compact('presensi'));
    }

    public function tampilkanpeta(Request $request)
    {
        $id = $request->id;
        $presensi = DB::table('presensi')->where('presensi.id', $id)
            ->join('karyawan', 'presensi.nik', '=', 'karyawan.nik')
            ->first();

        $lokasi_kantor = DB::table('kantorcabang')->where('kode_cabang', $presensi->kode_cabang)->first();

        return view('presensi.showmap', compact('presensi', 'lokasi_kantor'));
    }

    public function laporan()
    {
        $title = 'Laporan - Administrator';
        $namabulan = ["", "Januari", "Februari", "Maret", "April", "Mei", "Juni", "Juli", "Agustus", "September", "Oktober", "November", "Desember"];
        $karyawan = DB::table('karyawan')->orderBy('nama_lengkap')->get();
        return view('presensi.laporan', compact('title', 'namabulan', 'karyawan'));
    }

    public function cetaklaporan(Request $request)
    {
        $nik = $request->nik;
        $bulan = $request->bulan;
        $tahun = $request->tahun;
        $namabulan = ["", "Januari", "Februari", "Maret", "April", "Mei", "Juni", "Juli", "Agustus", "September", "Oktober", "November", "Desember"];
        $karyawan = DB::table('karyawan')->where('nik', $nik)
            ->join('jabatan', 'karyawan.kode_jab', '=', 'jabatan.kode_jab')
            ->join('departement', 'karyawan.kode_dept', '=', 'departement.kode_dept')
            ->first();
        $presensi = DB::table('presensi')
            ->select('presensi.*', 'keterangan', 'jam_kerja.*')
            ->leftJoin('jam_kerja', 'presensi.kode_jam_kerja', '=', 'jam_kerja.kode_jam_kerja')
            ->leftJoin('pengajuan_ijin', 'presensi.unik_ijin', '=', 'pengajuan_ijin.unik_ijin')
            ->where('presensi.nik', $nik)
            ->whereRaw('MONTH(tgl_presensi)="' . $bulan . '"')
            ->whereRaw('YEAR(tgl_presensi)="' . $tahun . '"')
            ->orderBy('tgl_presensi')
            ->get();

        if (isset($_POST['exportexcel'])) {
            $time = date("d-m-Y H:i:s");
            //Fungsi header dengan mengirimkan row data excel
            header("Content-type: application/vnd-ms-excel");
            //Mendefinisikan nama file ekspor "hasil-export.xls"
            header("Content-Disposition:attachment; filename=Laporan Presensi Karyawan $time.xls");
            return view('presensi.cetaklaporanexcel', compact('bulan', 'tahun', 'namabulan', 'karyawan', 'presensi'));
        }
        return view('presensi.cetaklaporan', compact('bulan', 'tahun', 'namabulan', 'karyawan', 'presensi'));
    }

    public function rekap()
    {
        $title = 'Rekap Presensi - Administrator';
        $namabulan = ["", "Januari", "Februari", "Maret", "April", "Mei", "Juni", "Juli", "Agustus", "September", "Oktober", "November", "Desember"];
        return view('presensi.rekap', compact('title', 'namabulan'));
    }

    public function cetakrekap(Request $request)
    {
        $bulan = $request->bulan;
        $tahun = $request->tahun;
        $dari = $tahun . "-" . $bulan . "-01";
        $sampai = date("Y-m-t", strtotime($dari));
        $namabulan = ["", "Januari", "Februari", "Maret", "April", "Mei", "Juni", "Juli", "Agustus", "September", "Oktober", "November", "Desember"];

        $select_date = "";
        $field_date = "";
        $i = 1;
        while (strtotime($dari) <= strtotime($sampai)) {
            $rangetanggal[] = $dari;

            $select_date .= "MAX(IF(tgl_presensi = '$dari',
            CONCAT(
                IFNULL(jam_in,'NA'),'|',
                IFNULL(jam_out,'NA'),'|',
                IFNULL(presensi.status,'NA'),'|',
                IFNULL(nama_jam_kerja,'NA'),'|',
                IFNULL(jam_masuk_awal,'NA'),'|',
                IFNULL(jam_pulang_awal,'NA'),'|',
                IFNULL(presensi.unik_ijin,'NA'),'|',
                IFNULL(keterangan,'NA'),'|'
            ),NULL)) as tgl_" . $i . ",";

            $field_date .= "tgl_" . $i . ",";
            $i++;
            $dari = date("Y-m-d", strtotime("+1 day", strtotime($dari)));
        }

        $jmlhari = count($rangetanggal);
        $lastrange = $jmlhari - 1;
        $sampai = $rangetanggal[$lastrange];
        if ($jmlhari == 30) {
            array_push($rangetanggal, NULL);
        } else if ($jmlhari == 29) {
            array_push($rangetanggal, NULL, NULL);
        } else if ($jmlhari == 28) {
            array_push($rangetanggal, NULL, NULL, NULL);
        }

        $query = Karyawan::query();
        $query->selectRaw(
            "$field_date karyawan.nik, nama_lengkap"
        );

        $query->leftJoin(
            DB::raw("(
            SELECT
            $select_date
            presensi.nik
            FROM presensi
            LEFT JOIN jam_kerja ON presensi.kode_jam_kerja = jam_kerja.kode_jam_kerja
            LEFT JOIN pengajuan_ijin ON presensi.unik_ijin = pengajuan_ijin.unik_ijin
            WHERE tgl_presensi BETWEEN '$rangetanggal[0]' AND '$sampai'
            GROUP BY nik
            ) presensi"),
            function ($join) {
                $join->on('karyawan.nik', '=', 'presensi.nik');
            }
        );

        $query->orderBy('nama_lengkap');
        $rekap = $query->get();

        if (isset($_POST['exportexcel'])) {
            $time = date("d-m-Y H:i:s");
            //Fungsi header dengan mengirimkan row data excel
            header("Content-type: application/vnd-ms-excel");
            //Mendefinisikan nama file ekspor "hasil-export.xls"
            header("Content-Disposition:attachment; filename=Rekap Presensi Karyawan $time.xls");
            return view('presensi.cetakrekapexcel', compact('bulan', 'tahun', 'namabulan', 'rekap', 'rangetanggal', 'jmlhari'));
        }
        return view('presensi.cetakrekap', compact('bulan', 'tahun', 'namabulan', 'rekap', 'rangetanggal', 'jmlhari'));
    }

    public function rekapijin()
    {
        $title = 'Rekap Ijin/Sakit - Administrator';
        $namabulan = ["", "Januari", "Februari", "Maret", "April", "Mei", "Juni", "Juli", "Agustus", "September", "Oktober", "November", "Desember"];
        return view('presensi.rekapijin', compact('title', 'namabulan'));
    }

    public function cetakrekapijin(Request $request)
    {
        $bulan = $request->bulan;
        $tahun = $request->tahun;
        $namabulan = ["", "Januari", "Februari", "Maret", "April", "Mei", "Juni", "Juli", "Agustus", "September", "Oktober", "November", "Desember"];
        $rekap = DB::table('pengajuan_ijin')
            ->join('karyawan', 'pengajuan_ijin.nik', '=', 'karyawan.nik')
            ->whereRaw('MONTH(tgl_ijin)="' . $bulan . '"')
            ->whereRaw('YEAR(tgl_ijin)="' . $tahun . '"')
            ->where('status_approved', 1)
            ->orderBy('tgl_ijin')
            ->get();

        if (isset($_POST['exportexcel'])) {
            $time = date("d-m-Y H:i:s");
            //Fungsi header dengan mengirimkan row data excel
            header("Content-type: application/vnd-ms-excel");
            //Mendefinisikan nama file ekspor "hasil-export.xls"
            header("Content-Disposition:attachment; filename=Rekap Perijinan Karyawan $time.xls");
            return view('presensi.cetakrekapijinexcel', compact('bulan', 'tahun', 'namabulan', 'rekap'));
        }
        return view('presensi.cetakrekapijin', compact('bulan', 'tahun', 'namabulan', 'rekap'));
    }

    public function perijinan()
    {
        $title = 'Data Ijin/Sakit - Administrator';
        $perijinan = DB::table('pengajuan_ijin')
            ->join('karyawan', 'pengajuan_ijin.nik', '=', 'karyawan.nik')
            ->join('jabatan', 'karyawan.kode_jab', '=', 'jabatan.kode_jab')
            ->where('status', '!=', 'c')
            ->where('status_approved', 0)
            ->orderBy('tgl_ijin_dari')
            ->get();
        return view('presensi.perijinan', compact('title', 'perijinan'));
    }

    public function perijinancuti()
    {
        $title = 'Data Cuti - Administrator';
        $cuti = DB::table('pengajuan_ijin')
            ->join('karyawan', 'pengajuan_ijin.nik', '=', 'karyawan.nik')
            ->join('jabatan', 'karyawan.kode_jab', '=', 'jabatan.kode_jab')
            ->where('status', 'c')
            ->where('status_approved', 0)
            ->orderBy('tgl_ijin_dari')
            ->get();
        return view('presensi.perijinancuti', compact('title', 'cuti'));
    }

    public function detailijin($unik_ijin, Request $request)
    {
        $title = 'Detail Ijin - Administrator';
        $detailijin = DB::table('pengajuan_ijin')
            ->join('karyawan', 'pengajuan_ijin.nik', '=', 'karyawan.nik')
            ->join('jabatan', 'karyawan.kode_jab', '=', 'jabatan.kode_jab')
            ->where('unik_ijin', $unik_ijin)
            ->first();
        $cuti = DB::table('pengajuan_ijin')
            ->join('master_cuti', 'pengajuan_ijin.kode_cuti', '=', 'master_cuti.kode_cuti')
            ->where('unik_ijin', $unik_ijin)
            ->first();
        return view('presensi.detailijin', compact('title', 'detailijin', 'cuti'));
    }

    public function approvalijin($unik_ijin, Request $request)
    {
        $nik = $request->nik;
        $status = $request->status;
        $status_approve = $request->status_approve;
        $tgl_dari = $request->tgl_ijin_dari;
        $tgl_sampai = $request->tgl_ijin_sampai;
        DB::beginTransaction();
        try {
            if ($status_approve == 1) {
                while (strtotime($tgl_dari) <= strtotime($tgl_sampai)) {
                    DB::table('presensi')->insert([
                        'nik' => $nik,
                        'tgl_presensi' => $tgl_dari,
                        'status' => $status,
                        'unik_ijin' => $unik_ijin
                    ]);
                    $tgl_dari = date("Y-m-d", strtotime("+1 days", strtotime($tgl_dari)));
                }
            }

            DB::table('pengajuan_ijin')->where('unik_ijin', $unik_ijin)->update([
                'tgl_ijin_sampai' => $tgl_sampai,
                'status_approved' => $status_approve,
            ]);

            DB::commit();
            return redirect('/panel/perijinan')->with(['success' => 'Data Berhasil Diproses']);
        } catch (\Exception $e) {
            DB::rollBack();
            return redirect('/panel/perijinan')->with(['error' => 'Proses Data Gagal']);
        }


        // $update = DB::table('pengajuan_ijin')->where('unik_ijin', $unik_ijin)->update([
        //     'status_approved' => 1
        // ]);
        // if ($update) {
        //     return Redirect::back()->with(['success' => 'Data Berhasil di Ubah']);
        // } else {
        //     return Redirect::back()->with(['error' => 'Update Data Gagal']);
        // }
    }

    public function batalkan($unik_ijin)
    {
        DB::beginTransaction();
        try {
            DB::table('pengajuan_ijin')->where('unik_ijin', $unik_ijin)->update([
                'status_approved' => 0
            ]);
            DB::table('presensi')->where('unik_ijin', $unik_ijin)->delete();
            DB::commit();
            return redirect('/panel/perijinan')->with(['success' => 'Data Berhasil Dibatalkan']);
        } catch (\Exception $e) {
            DB::rollBack();
            return redirect('/panel/perijinan')->with(['error' => 'Pembatalan Data Gagal']);
        }
    }

    public function approve($unik_ijin)
    {
        $update = DB::table('pengajuan_ijin')->where('unik_ijin', $unik_ijin)->update([
            'status_approved' => 1
        ]);
        if ($update) {
            return Redirect::back()->with(['success' => 'Data Berhasil di Ubah']);
        } else {
            return Redirect::back()->with(['error' => 'Update Data Gagal']);
        }
    }

    public function tolak($unik_ijin)
    {
        $update = DB::table('pengajuan_ijin')->where('unik_ijin', $unik_ijin)->update([
            'status_approved' => 2
        ]);
        if ($update) {
            return Redirect::back()->with(['success' => 'Data Berhasil di Ubah']);
        } else {
            return Redirect::back()->with(['error' => 'Update Data Gagal']);
        }
    }

    public function approved()
    {
        $title = 'Ijin Disetujui - Administrator';
        $approved = DB::table('pengajuan_ijin')
            ->join('karyawan', 'pengajuan_ijin.nik', '=', 'karyawan.nik')
            ->join('jabatan', 'karyawan.kode_jab', '=', 'jabatan.kode_jab')
            ->where('status_approved', 1)
            ->get();
        return view('presensi.approved', compact('title', 'approved'));
    }

    public function refused()
    {
        $title = 'Ijin Ditolak - Administrator';
        $refused = DB::table('pengajuan_ijin')
            ->join('karyawan', 'pengajuan_ijin.nik', '=', 'karyawan.nik')
            ->join('jabatan', 'karyawan.kode_jab', '=', 'jabatan.kode_jab')
            ->where('status_approved', 2)
            ->get();
        return view('presensi.refused', compact('title', 'refused'));
    }

    public function showact($unik_ijin)
    {
        $dataijin = DB::table('pengajuan_ijin')->where('unik_ijin', $unik_ijin)->first();
        return view('presensi.showact', compact('dataijin'));
    }
}
