<?php

namespace App\Http\Controllers;

use App\Imports\SetjamkerjaImport;
use App\Models\Setjamkerja;
use App\Models\Setjamkerjadept;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Maatwebsite\Excel\Facades\Excel;
use PhpParser\Node\Stmt\TryCatch;

class KonfigurasiController extends Controller
{
    public function lokasikantor()
    {
        $title = 'Setting Lokasi - Administrator';
        $lokasikantor = DB::table('konfigurasi_lokasi')->get();
        return view('konfigurasi.lokasikantor', compact('title', 'lokasikantor'));
    }

    public function tambahkantor(Request $request)
    {
        $nama_kantor = $request->nama_kantor;
        $latitude = $request->latitude;
        $longitude = $request->longitude;
        $radius = $request->radius;

        $data = [
            'nama_kantor' => $nama_kantor,
            'latitude' => $latitude,
            'longitude' => $longitude,
            'radius' => $radius
        ];

        $simpan = DB::table('konfigurasi_lokasi')->insert($data);
        if ($simpan) {
            return redirect('/panel/kantor')->with(['success' => 'Kantor Berhasil Ditambahkan']);
        } else {
            return redirect('/panel/kantor')->with(['error' => 'Data Gagal Ditambahkan']);
        }
    }

    public function edit(Request $request)
    {
        $id = $request->id;
        $lokasikantor = DB::table('konfigurasi_lokasi')->where('id', $id)->first();
        return view('konfigurasi.editlokasi', compact('lokasikantor'));
    }

    public function update($id, Request $request)
    {
        $nama_kantor = $request->nama_kantor;
        $latitude = $request->latitude;
        $longitude = $request->longitude;
        $radius = $request->radius;

        $data = [
            'nama_kantor' => $nama_kantor,
            'latitude' => $latitude,
            'longitude' => $longitude,
            'radius' => $radius
        ];

        $update = DB::table('konfigurasi_lokasi')->where('id', $id)->update($data);
        if ($update) {
            return redirect('/panel/kantor')->with(['success' => 'Data Kantor Berhasil Di Update']);
        } else {
            return redirect('/panel/kantor')->with(['error' => 'Update Data Gagal']);
        }
    }

    public function delete($id)
    {
        $delete = DB::table('konfigurasi_lokasi')->where('id', $id)->delete();
        if ($delete) {
            return Redirect::back()->with(['success' => 'Data Kantor Berhasil Di Hapus']);
        } else {
            return Redirect::back()->with(['error' => 'Data Gagal Di Hapus']);
        }
    }

    public function jamkerja()
    {
        $title = 'Jam Kerja - Administrator';
        $jamkerja = DB::table('jam_kerja')->orderBy('kode_jam_kerja')->get();
        return view('konfigurasi.jamkerja', compact('title', 'jamkerja'));
    }

    public function tambahjamkerja(Request $request)
    {
        $kode_jam_kerja = $request->kode_jam_kerja;
        $nama_jam_kerja = $request->nama_jam_kerja;
        $jam_masuk_awal = $request->jam_masuk_awal;
        $jam_masuk_akhir = $request->jam_masuk_akhir;
        $jam_pulang_awal = $request->jam_pulang_awal;
        $jam_pulang_akhir = $request->jam_pulang_akhir;

        $data = [
            'kode_jam_kerja' => $kode_jam_kerja,
            'nama_jam_kerja' => $nama_jam_kerja,
            'jam_masuk_awal' => $jam_masuk_awal,
            'jam_masuk_akhir' => $jam_masuk_akhir,
            'jam_pulang_awal' => $jam_pulang_awal,
            'jam_pulang_akhir' => $jam_pulang_akhir
        ];

        $simpan = DB::table('jam_kerja')->insert($data);
        if ($simpan) {
            return redirect('/panel/jamkerja')->with(['success' => 'Jam Kerja Berhasil Ditambahkan']);
        } else {
            return redirect('/panel/jamkerja')->with(['error' => 'Data Gagal Ditambahkan']);
        }
    }

    public function cekkode(Request $request)
    {
        $kode_jam_kerja = $request->kode_jam_kerja;

        $cek = DB::table('jam_kerja')->where('kode_jam_kerja', $kode_jam_kerja)->count();
        return $cek;
    }

    public function editjamkerja(Request $request)
    {
        $id = $request->id;
        $jamkerja = DB::table('jam_kerja')->where('id', $id)->first();
        return view('konfigurasi.editjamkerja', compact('jamkerja'));
    }

    public function updatejamkerja($id, Request $request)
    {
        $kode_jam_kerja = $request->kode_jam_kerja;
        $nama_jam_kerja = $request->nama_jam_kerja;
        $jam_masuk_awal = $request->jam_masuk_awal;
        $jam_masuk_akhir = $request->jam_masuk_akhir;
        $jam_pulang_awal = $request->jam_pulang_awal;
        $jam_pulang_akhir = $request->jam_pulang_akhir;

        $data = [
            'kode_jam_kerja' => $kode_jam_kerja,
            'nama_jam_kerja' => $nama_jam_kerja,
            'jam_masuk_awal' => $jam_masuk_awal,
            'jam_masuk_akhir' => $jam_masuk_akhir,
            'jam_pulang_awal' => $jam_pulang_awal,
            'jam_pulang_akhir' => $jam_pulang_akhir
        ];

        $update = DB::table('jam_kerja')->where('id', $id)->update($data);
        if ($update) {
            return redirect('/panel/jamkerja')->with(['success' => 'Jam Kerja Berhasil Di Update']);
        } else {
            return redirect('/panel/jamkerja')->with(['error' => 'Update Data Gagal']);
        }
    }

    public function deletejamkerja($id)
    {
        $delete = DB::table('jam_kerja')->where('id', $id)->delete();
        if ($delete) {
            return Redirect::back()->with(['success' => 'Jam Kerja Berhasil Di Hapus']);
        } else {
            return Redirect::back()->with(['error' => 'Data Gagal Di Hapus']);
        }
    }

    public function setjamkerja($nik)
    {
        $title = 'Set Jam Kerja - Administrator';
        $karyawan = DB::table('karyawan')->where('nik', $nik)->first();
        $jamkerja = DB::table('jam_kerja')->orderBy('nama_jam_kerja')->get();
        $cekjamkerja = DB::table('konfigurasi_jamkerja')->where('nik', $nik)->count();
        if ($cekjamkerja > 0) {
            $setjamkerja = DB::table('konfigurasi_jamkerja')->where('nik', $nik)->get();
            return view('konfigurasi.editsetjamkerja', compact('title', 'karyawan', 'jamkerja', 'setjamkerja'));
        } else {
            return view('konfigurasi.setjamkerja', compact('title', 'karyawan', 'jamkerja'));
        }
    }

    public function storesetjamkerja(Request $request)
    {
        $nik = $request->nik;
        $hari = $request->hari;
        $kode_jam_kerja = $request->kode_jam_kerja;

        for ($i = 0; $i < count($hari); $i++) {
            $data[] = [
                'nik' => $nik,
                'hari' => $hari[$i],
                'kode_jam_kerja' => $kode_jam_kerja[$i]
            ];
        }

        try {
            Setjamkerja::insert($data);
            return redirect('/panel/karyawan')->with(['success' => 'Jam Kerja Berhasil Di Update']);
        } catch (\Exception $e) {
            return redirect('/panel/karyawan')->with(['error' => 'Jam Kerja Gagal Di Update']);
            // dd($e);
        }
    }

    public function updatesetjamkerja(Request $request)
    {
        $nik = $request->nik;
        $hari = $request->hari;
        $kode_jam_kerja = $request->kode_jam_kerja;

        for ($i = 0; $i < count($hari); $i++) {
            $data[] = [
                'nik' => $nik,
                'hari' => $hari[$i],
                'kode_jam_kerja' => $kode_jam_kerja[$i]
            ];
        }

        DB::beginTransaction();
        try {
            DB::table('konfigurasi_jamkerja')->where('nik', $nik)->delete();
            Setjamkerja::insert($data);
            DB::commit();
            return redirect('/panel/karyawan')->with(['success' => 'Jam Kerja Berhasil Di Update']);
        } catch (\Exception $e) {
            DB::rollBack();
            return redirect('/panel/karyawan')->with(['error' => 'Jam Kerja Gagal Di Update']);
            // dd($e);
        }
    }

    public function jamkerjadept()
    {
        $title = 'Jam Kerja Departemen - Administrator';
        $jamkerjadept = DB::table('konfigurasi_jk_dept')
            ->join('kantorcabang', 'konfigurasi_jk_dept.kode_cabang', '=', 'kantorcabang.kode_cabang')
            ->join('departement', 'konfigurasi_jk_dept.kode_dept', '=', 'departement.kode_dept')
            ->get();
        return view('konfigurasi.jamkerjadept', compact('title', 'jamkerjadept'));
    }

    public function createjamkerjadept()
    {
        $title = 'Set Jam Kerja Departemen - Administrator';
        $jamkerja = DB::table('jam_kerja')->orderBy('nama_jam_kerja')->get();
        $cabang = DB::table('kantorcabang')->get();
        $departemen = DB::table('departement')->get();
        return view('konfigurasi.createjamkerjadept', compact('title', 'jamkerja', 'cabang', 'departemen'));
    }

    public function storejamkerjadept(Request $request)
    {
        $kode_cabang = $request->kode_cabang;
        $kode_dept = $request->kode_dept;
        $hari = $request->hari;
        $kode_jam_kerja = $request->kode_jam_kerja;
        $kode_jk_dept = "J" . $kode_cabang . $kode_dept;

        DB::beginTransaction();
        try {
            //Menyimpan data ke tabel konfigurasi_jk_dept
            DB::table('konfigurasi_jk_dept')->insert([
                'kode_jk_dept' => $kode_jk_dept,
                'kode_cabang' => $kode_cabang,
                'kode_dept' => $kode_dept
            ]);

            for ($i = 0; $i < count($hari); $i++) {
                $data[] = [
                    'kode_jk_dept' => $kode_jk_dept,
                    'hari' => $hari[$i],
                    'kode_jam_kerja' => $kode_jam_kerja[$i]
                ];
            }
            Setjamkerjadept::insert($data);
            DB::commit();
            return redirect('/panel/jamkerjadept')->with(['success' => 'Jam Kerja Berhasil Ditambahkan']);
        } catch (\Exception $e) {
            DB::rollBack();
            return redirect('/panel/jamkerjadept')->with(['error' => 'Jam Kerja Gagal Ditambahkan']);
        }
    }

    public function editjamkerjadept($kode_jk_dept)
    {
        $title = 'Edit Jam Kerja Departemen - Administrator';
        $jamkerja = DB::table('jam_kerja')->orderBy('nama_jam_kerja')->get();
        $cabang = DB::table('kantorcabang')->get();
        $departemen = DB::table('departement')->get();
        $jamkerjadept = DB::table('konfigurasi_jk_dept')->where('kode_jk_dept', $kode_jk_dept)->first();
        $jamkerjadept_detail = DB::table('konfigurasi_jk_dept_detail')->where('kode_jk_dept', $kode_jk_dept)->get();
        return view('konfigurasi.editjamkerjadept', compact('title', 'jamkerja', 'cabang', 'departemen', 'jamkerjadept', 'jamkerjadept_detail'));
    }

    public function updatejamkerjadept($kode_jk_dept, Request $request)
    {
        $hari = $request->hari;
        $kode_jam_kerja = $request->kode_jam_kerja;

        DB::beginTransaction();
        try {

            //Hapus data jam kerja sebalumnya
            DB::table('konfigurasi_jk_dept_detail')->where('kode_jk_dept', $kode_jk_dept)->delete();
            for ($i = 0; $i < count($hari); $i++) {
                $data[] = [
                    'kode_jk_dept' => $kode_jk_dept,
                    'hari' => $hari[$i],
                    'kode_jam_kerja' => $kode_jam_kerja[$i]
                ];
            }
            Setjamkerjadept::insert($data);
            DB::commit();
            return redirect('/panel/jamkerjadept')->with(['success' => 'Jam Kerja Berhasil Diubah']);
        } catch (\Exception $e) {
            DB::rollBack();
            return redirect('/panel/jamkerjadept')->with(['error' => 'Jam Kerja Gagal Diubah']);
        }
    }

    public function showjamkerjadept(Request $request)
    {
        $kode_jk_dept = $request->kode_jk_dept;
        $jamkerja = DB::table('jam_kerja')->orderBy('nama_jam_kerja')->get();
        $cabang = DB::table('kantorcabang')->get();
        $departemen = DB::table('departement')->get();
        $jamkerjadept = DB::table('konfigurasi_jk_dept')->where('kode_jk_dept', $kode_jk_dept)->first();
        $jamkerjadept_detail = DB::table('konfigurasi_jk_dept_detail')
            ->join('jam_kerja', 'konfigurasi_jk_dept_detail.kode_jam_kerja', '=', 'jam_kerja.kode_jam_kerja')
            ->where('kode_jk_dept', $kode_jk_dept)->get();
        return view('konfigurasi.showjamkerjadept', compact('jamkerja', 'cabang', 'departemen', 'jamkerjadept', 'jamkerjadept_detail'));
    }

    public function deletejamkerjadept($kode_jk_dept)
    {
        try {
            DB::table('konfigurasi_jk_dept')->where('kode_jk_dept', $kode_jk_dept)->delete();
            return Redirect::back()->with(['success' => 'Jam Kerja Berhasil Di Hapus']);
        } catch (\Exception $e) {
            return Redirect::back()->with(['error' => 'Data Gagal Di Hapus']);
        }
    }

    // public function uploadsetjamkerja()
    // {
    //     $title = 'Upload Set Jam Kerja - Administrator';
    //     return view('konfigurasi.uploadsetjamkerja', compact('title'));
    // }

    // public function import(Request $request)
    // {
    //melakukan import file
    // $import = Excel::import(new SetjamkerjaImport, request()->file('file'));
    //jika berhasil kembali ke halaman sebelumnya
    //     if ($import) {
    //         return redirect('/panel/uploadsetjamkerja')->with(['success' => 'Data Berhasil Diunggah']);
    //     } else {
    //         return redirect('/panel/uploadsetjamkerja')->with(['error' => 'Data Gagal Diunggah']);
    //     }
    // }
}
