<?php

namespace App\Http\Controllers;

use App\Imports\KaryawanImport;
use App\Models\Karyawan;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Storage;
use Maatwebsite\Excel\Facades\Excel;

class KaryawanController extends Controller
{
  public function index(Request $request)
  {
    $title = 'Karyawan - Administrator';
    $jmlkaryawan = DB::table('karyawan')
      ->selectRaw('COUNT(nik) as jmlkaryawan')
      ->first();

    $query = Karyawan::query();
    $query->select('karyawan.*', 'nama_dept', 'nama_jab');
    $query->join('departement', 'karyawan.kode_dept', '=', 'departement.kode_dept',);
    $query->join('jabatan', 'karyawan.kode_jab', '=', 'jabatan.kode_jab');
    $query->join('kantorcabang', 'karyawan.kode_cabang', '=', 'kantorcabang.kode_cabang');
    $query->orderBy('nama_lengkap');
    if (!empty($request->nama_karyawan)) {
      $query->where('nama_lengkap', 'like', '%' . $request->nama_karyawan . '%');
    }
    if (!empty($request->kode_dept)) {
      $query->where('karyawan.kode_dept', $request->kode_dept);
    }
    $karyawan = $query->paginate(10);

    $departemen = DB::table('departement')->get();
    $jabatan = DB::table('jabatan')->get();
    $kantorcabang = DB::table('kantorcabang')->orderBy('kode_cabang')->get();
    return view('karyawan.index', compact('title', 'jmlkaryawan', 'karyawan', 'departemen', 'jabatan', 'kantorcabang'));
  }

  public function store(Request $request)
  {
    $nik = $request->nik;
    $id_enc = md5($request->nik);
    $nama_lengkap = $request->nama_lengkap;
    $kode_cabang = $request->kode_cabang;
    $kode_dept = $request->kode_dept;
    $kode_jab = $request->kode_jab;
    $password = Hash::make('12345');
    $foto = $request->foto;

    if ($request->hasFile('foto')) {
      $foto = $nik . "." . $request->file('foto')->getClientOriginalExtension();
    } else {
      $foto = null;
    }
    if (empty($request->foto)) {
      $data = [
        'nik' => $nik,
        'id_enc' => $id_enc,
        'nama_lengkap' => $nama_lengkap,
        'tgl_lahir' => '2020-08-17',
        'no_hp' => '081234567',
        'email' => 'emailanda@gmail.com',
        'kode_cabang' => $kode_cabang,
        'kode_dept' => $kode_dept,
        'kode_jab' => $kode_jab,
        'password' => $password
      ];
    } else {
      $data = [
        'nik' => $nik,
        'id_enc' => $id_enc,
        'nama_lengkap' => $nama_lengkap,
        'tgl_lahir' => '2020-08-17',
        'no_hp' => '081234567',
        'email' => 'emailanda@gmail.com',
        'kode_cabang' => $kode_cabang,
        'kode_dept' => $kode_dept,
        'kode_jab' => $kode_jab,
        'password' => $password,
        'foto' => $foto
      ];
    }

    $simpan = DB::table('karyawan')->insert($data);
    if ($simpan) {
      if ($request->hasFile('foto')) {
        $folderPath = "public/uploads/karyawan/";
        $request->file('foto')->storeAs($folderPath, $foto);
      }
      return redirect('/panel/karyawan')->with(['success' => 'Data Karyawan Berhasil Ditambahkan']);
    } else {
      return redirect('/panel/karyawan')->with(['error' => 'Data Gagal Ditambahkan']);
    }
  }

  public function import(Request $request)
  {
    //melakukan import file
    $import = Excel::import(new KaryawanImport, request()->file('file'));
    //jika berhasil kembali ke halaman sebelumnya
    if ($import) {
      return redirect('/panel/karyawan')->with(['success' => 'Data Berhasil Diunggah']);
    } else {
      return redirect('/panel/karyawan')->with(['error' => 'Data Gagal Diunggah']);
    }
  }

  public function ceknik(Request $request)
  {
    $nik = $request->nik;

    $cek = DB::table('karyawan')->where('nik', $nik)->count();
    return $cek;
  }

  public function edit(Request $request)
  {
    $id_enc = $request->id_enc;
    $departemen = DB::table('departement')->get();
    $jabatan = DB::table('jabatan')->get();
    $kantorcabang = DB::table('kantorcabang')->orderBy('kode_cabang')->get();
    $karyawan = DB::table('karyawan')->where('id_enc', $id_enc)->first();
    return view('karyawan.edit', compact('departemen', 'jabatan', 'karyawan', 'kantorcabang'));
  }

  public function update($id_enc, Request $request)
  {
    $nik = $request->nik;
    $nama_lengkap = $request->nama_lengkap;
    $kode_cabang = $request->kode_cabang;
    $kode_dept = $request->kode_dept;
    $kode_jab = $request->kode_jab;
    $old_foto = $request->old_foto;

    if ($request->hasFile('foto')) {
      $foto = $nik . "." . $request->file('foto')->getClientOriginalExtension();
    } else {
      $foto = $old_foto;
    }
    if (empty($request->foto)) {
      $data = [
        'nama_lengkap' => $nama_lengkap,
        'kode_cabang' => $kode_cabang,
        'kode_dept' => $kode_dept,
        'kode_jab' => $kode_jab
      ];
    } else {
      $data = [
        'nama_lengkap' => $nama_lengkap,
        'kode_cabang' => $kode_cabang,
        'kode_dept' => $kode_dept,
        'kode_jab' => $kode_jab,
        'foto' => $foto
      ];
    }

    try {
      DB::table('karyawan')->where('id_enc', $id_enc)->update($data);
      if ($request->hasFile('foto')) {
        $folderPath = "public/uploads/karyawan/";
        $folderPathOld = "public/uploads/karyawan/" . $old_foto;
        Storage::delete($folderPathOld);
        $request->file('foto')->storeAs($folderPath, $foto);
      }
      return redirect('/panel/karyawan')->with(['success' => 'Data Karyawan Berhasil Di Update']);
    } catch (\Exception $e) {
      return redirect('/panel/karyawan')->with(['error' => 'Update Data Gagal']);
    }
  }

  public function delete($id_enc)
  {
    $delete = DB::table('karyawan')->where('id_enc', $id_enc)->delete();
    if ($delete) {
      return Redirect::back()->with(['success' => 'Data Karyawan Berhasil Di Hapus']);
    } else {
      return Redirect::back()->with(['error' => 'Data Gagal Di Hapus']);
    }
  }

  public function resetpassword($id_enc)
  {
    $update = DB::table('karyawan')->where('id_enc', $id_enc)->update([
      'password' => Hash::make('12345')
    ]);
    if ($update) {
      return Redirect::back()->with(['success' => 'Password Berhasil di Reset ke Default Password (12345)']);
    } else {
      return Redirect::back()->with(['error' => 'Reset Password Gagal']);
    }
  }
}
