<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;

class JabatanController extends Controller
{
    public function index()
    {
        $title = 'Jabatan - Administrator';
        $jabatan = DB::table('jabatan')->get();
        return view('jabatan.index', compact('title', 'jabatan'));
    }

    public function tambahjabatan(Request $request)
    {
        $kode_jab = $request->kode_jab;
        $nama_jab = $request->nama_jab;

        $data = [
            'kode_jab' => $kode_jab,
            'nama_jab' => $nama_jab
        ];

        $simpan = DB::table('jabatan')->insert($data);
        if ($simpan) {
            return redirect('/panel/jabatan')->with(['success' => 'Data Berhasil Ditambahkan']);
        } else {
            return redirect('/panel/jabatan')->with(['error' => 'Data Gagal Ditambahkan']);
        }
    }

    public function edit(Request $request)
    {
        $id = $request->id;
        $jabatan = DB::table('jabatan')->where('id', $id)->first();
        return view('jabatan.edit', compact('jabatan'));
    }

    public function update($id, Request $request)
    {
        $kode_jab = $request->kode_jab;
        $nama_jab = $request->nama_jab;
        $data = [
            'kode_jab' => $kode_jab,
            'nama_jab' => $nama_jab
        ];

        $update = DB::table('jabatan')->where('id', $id)->update($data);
        if ($update) {
            return redirect('/panel/jabatan')->with(['success' => 'Data Jabatan Berhasil Di Update']);
        } else {
            return redirect('/panel/jabatan')->with(['error' => 'Update Data Gagal']);
        }
    }

    public function delete($kode_jab)
    {
        $delete = DB::table('jabatan')->where('kode_jab', $kode_jab)->delete();
        if ($delete) {
            return Redirect::back()->with(['success' => 'Data Jabatan Berhasil Di Hapus']);
        } else {
            return Redirect::back()->with(['error' => 'Data Gagal Di Hapus']);
        }
    }
}
