<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;

class IjincutiController extends Controller
{
    public function create()
    {
        $cuti = DB::table('master_cuti')->orderBy('kode_cuti')->get();
        return view('ijincuti.create', compact('cuti'));
    }

    public function store(Request $request)
    {
        $nik = Auth::guard('karyawan')->user()->nik;
        $tgl_skrg = date("Y-m-d");
        $time = time();
        $tgl_ijin_dari = $request->tgl_ijin_dari;
        $tgl_ijin_sampai = $request->tgl_ijin_sampai;
        $status = "c";
        $kode_cuti = $request->kode_cuti;
        $keterangan = $request->keterangan;
        $tahun = date("Y", strtotime($tgl_ijin_dari));
        // $file_surat = $request->file_surat;

        //Hitung Jumlah Hari yang Digunakan
        $jmlhari = hitunghari($tgl_ijin_dari, $tgl_ijin_sampai);

        //Cek Jumlah Maksimal Cuti
        $cuti = DB::table('master_cuti')->where('kode_cuti', $kode_cuti)->first();
        $jmlmaxcuti = $cuti->jml_hari;

        //Cek Jumlah Cuti yang Sudah Digunakan Pada Tahun Aktif
        $cutidigunakan = DB::table('presensi')
            ->whereRaw('YEAR(tgl_presensi)="' . $tahun . '"')
            ->where('status', 'c')
            ->where('nik', $nik)
            ->count();

        //Sisa Cuti
        $sisacuti = $jmlmaxcuti - $cutidigunakan;

        if ($request->hasFile('file_surat')) {
            $file_surat = $tgl_skrg . "-" . $nik . "-" . $time . "." . $request->file('file_surat')->getClientOriginalExtension();
        } else {
            $file_surat = null;
        }
        if (empty($request->file_surat)) {
            $data = [
                'nik' => $nik,
                'tgl_ijin_dari' => $tgl_ijin_dari,
                'tgl_ijin_sampai' => $tgl_ijin_sampai,
                'status' => $status,
                'kode_cuti' => $kode_cuti,
                'keterangan' => $keterangan,
                'status_approved' => 0,
                'unik_ijin' => time()
            ];
        } else {
            $data = [
                'nik' => $nik,
                'tgl_ijin_dari' => $tgl_ijin_dari,
                'tgl_ijin_sampai' => $tgl_ijin_sampai,
                'status' => $status,
                'kode_cuti' => $kode_cuti,
                'keterangan' => $keterangan,
                'status_approved' => 0,
                'unik_ijin' => time(),
                'file_surat' => $file_surat
            ];
        }

        //Cek Tanggal Sudah Ada Presensi/Belum
        $cekpresensi = DB::table('presensi')
            ->whereBetween('tgl_presensi', [$tgl_ijin_dari, $tgl_ijin_sampai])
            ->count();
        //Cek Tanggal Sudah Ada Ijin/Belum
        $cekpengajuan = DB::table('pengajuan_ijin')
            ->whereRaw('"' . $tgl_ijin_dari . '"BETWEEN tgl_ijin_dari AND tgl_ijin_sampai')
            ->count();
        if ($jmlhari > $sisacuti) {
            return redirect('/ijin')->with(['error' => 'Jumlah hari melebihi batas maksimal jatah cuti dalam 1 tahun, sisa cuti Anda adalah ' . $sisacuti . ' hari']);
        } else if ($cekpresensi > 0) {
            return redirect('/ijin')->with(['error' => 'Periode tanggal sudah digunakan untuk presensi, silahkan ubah periode tanggal ijin cuti Anda']);
        } else if ($cekpengajuan > 0) {
            return redirect('/ijin')->with(['error' => 'Periode tanggal sudah digunakan, silahkan ubah periode tanggal ijin cuti Anda']);
        } else {
            $simpan = DB::table('pengajuan_ijin')->insert($data);
            if ($simpan) {
                if ($request->hasFile('file_surat')) {
                    $folderPath = "public/uploads/file_ijin/";
                    $request->file('file_surat')->storeAs($folderPath, $file_surat);
                }
                return redirect('/ijin')->with(['success' => 'Data Ajuan Cuti Berhasil di Simpan']);
            } else {
                return redirect('/ijin')->with(['error' => 'Data Ajuan Cuti Gagal']);
            }
        }
    }

    public function edit($unik_ijin)
    {
        $dataijin = DB::table('pengajuan_ijin')->where('unik_ijin', $unik_ijin)->first();
        $cuti = DB::table('master_cuti')->orderBy('kode_cuti')->get();
        return view('ijincuti.edit', compact('dataijin', 'cuti'));
    }

    public function update($unik_ijin, Request $request)
    {
        $nik = Auth::guard('karyawan')->user()->nik;
        $tgl_skrg = date("Y-m-d");
        $time = time();
        $tgl_ijin_dari = $request->tgl_ijin_dari;
        $tgl_ijin_sampai = $request->tgl_ijin_sampai;
        $kode_cuti = $request->kode_cuti;
        $keterangan = $request->keterangan;
        $old_file_surat = $request->old_file_surat;
        // $file_surat = $request->file_surat;

        if ($request->hasFile('file_surat')) {
            $file_surat = $tgl_skrg . "-" . $nik . "-" . $time . "." . $request->file('file_surat')->getClientOriginalExtension();
        } else {
            $file_surat = $old_file_surat;
        }
        if (empty($request->file_surat)) {
            $data = [
                'nik' => $nik,
                'tgl_ijin_dari' => $tgl_ijin_dari,
                'tgl_ijin_sampai' => $tgl_ijin_sampai,
                'kode_cuti' => $kode_cuti,
                'keterangan' => $keterangan,
            ];
        } else {
            $data = [
                'nik' => $nik,
                'tgl_ijin_dari' => $tgl_ijin_dari,
                'tgl_ijin_sampai' => $tgl_ijin_sampai,
                'kode_cuti' => $kode_cuti,
                'keterangan' => $keterangan,
                'file_surat' => $file_surat,
            ];
        }

        try {
            DB::table('pengajuan_ijin')->where('unik_ijin', $unik_ijin)->update($data);
            if ($request->hasFile('file_surat')) {
                $folderPath = "public/uploads/file_ijin/";
                $folderPathOld = "public/uploads/file_ijin/" . $old_file_surat;
                Storage::delete($folderPathOld);
                $request->file('file_surat')->storeAs($folderPath, $file_surat);
            }
            return redirect('/ijin')->with(['success' => 'Data Ajuan Ijin Berhasil Diupdate']);
        } catch (\Exception $e) {
            return redirect('/ijin')->with(['error' => 'Update Data Gagal']);
        }
    }
}
