<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;

class DepartemenController extends Controller
{
    public function index()
    {
        $title = 'Departemen - Administrator';
        $departemen = DB::table('departement')->get();
        return view('departemen.index', compact('title', 'departemen'));
    }

    public function tambahdepartemen(Request $request)
    {
        $kode_dept = $request->kode_dept;
        $nama_dept = $request->nama_dept;

        $data = [
            'kode_dept' => $kode_dept,
            'nama_dept' => $nama_dept
        ];

        $simpan = DB::table('departement')->insert($data);
        if ($simpan) {
            return redirect('/panel/departemen')->with(['success' => 'Data Berhasil Ditambahkan']);
        } else {
            return redirect('/panel/departemen')->with(['error' => 'Data Gagal Ditambahkan']);
        }
    }

    public function edit(Request $request)
    {
        $id = $request->id;
        $departemen = DB::table('departement')->where('id', $id)->first();
        return view('departemen.edit', compact('departemen'));
    }

    public function update($id, Request $request)
    {
        $kode_dept = $request->kode_dept;
        $nama_dept = $request->nama_dept;
        $data = [
            'kode_dept' => $kode_dept,
            'nama_dept' => $nama_dept
        ];

        $update = DB::table('departement')->where('id', $id)->update($data);
        if ($update) {
            return redirect('/panel/departemen')->with(['success' => 'Data Departemen Berhasil Di Update']);
        } else {
            return redirect('/panel/departemen')->with(['error' => 'Update Data Gagal']);
        }
    }

    public function delete($kode_dept)
    {
        $delete = DB::table('departement')->where('kode_dept', $kode_dept)->delete();
        if ($delete) {
            return Redirect::back()->with(['success' => 'Data Departemen Berhasil Di Hapus']);
        } else {
            return Redirect::back()->with(['error' => 'Data Gagal Di Hapus']);
        }
    }
}
