<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;

class CutiController extends Controller
{
    public function index()
    {
        $title = 'Cuti - Administrator';
        $cuti = DB::table('master_cuti')->get();
        return view('cuti.index', compact('title', 'cuti'));
    }

    public function tambahcuti(Request $request)
    {
        $kode_cuti = $request->kode_cuti;
        $nama_cuti = $request->nama_cuti;
        $jml_hari = $request->jml_hari;

        $data = [
            'kode_cuti' => $kode_cuti,
            'nama_cuti' => $nama_cuti,
            'jml_hari' => $jml_hari,
            'unik_cuti' => time()
        ];

        $simpan = DB::table('master_cuti')->insert($data);
        if ($simpan) {
            return redirect('/panel/cuti')->with(['success' => 'Cuti Berhasil Ditambahkan']);
        } else {
            return redirect('/panel/cuti')->with(['error' => 'Data Gagal Ditambahkan']);
        }
    }

    public function cekkodecuti(Request $request)
    {
        $kode_cuti = $request->kode_cuti;

        $cek = DB::table('master_cuti')->where('kode_cuti', $kode_cuti)->count();
        return $cek;
    }

    public function edit(Request $request)
    {
        $unik_cuti = $request->unik_cuti;
        $cuti = DB::table('master_cuti')->where('unik_cuti', $unik_cuti)->first();
        return view('cuti.edit', compact('cuti'));
    }

    public function update($unik_cuti, Request $request)
    {
        $kode_cuti = $request->kode_cuti;
        $nama_cuti = $request->nama_cuti;
        $jml_hari = $request->jml_hari;
        $data = [
            'kode_cuti' => $kode_cuti,
            'nama_cuti' => $nama_cuti,
            'jml_hari' => $jml_hari
        ];

        $update = DB::table('master_cuti')->where('unik_cuti', $unik_cuti)->update($data);
        if ($update) {
            return redirect('/panel/cuti')->with(['success' => 'Data Cuti Berhasil Di Update']);
        } else {
            return redirect('/panel/cuti')->with(['error' => 'Update Data Gagal']);
        }
    }

    public function delete($unik_cuti)
    {
        $delete = DB::table('master_cuti')->where('unik_cuti', $unik_cuti)->delete();
        if ($delete) {
            return Redirect::back()->with(['success' => 'Data Cuti Berhasil Di Hapus']);
        } else {
            return Redirect::back()->with(['error' => 'Data Gagal Di Hapus']);
        }
    }
}
