<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;

class CabangController extends Controller
{
    public function index()
    {
        $title = 'Kantor Cabang - Administrator';
        $kantorcabang = DB::table('kantorcabang')->get();
        return view('cabang.index', compact('title', 'kantorcabang'));
    }

    public function tambahcabang(Request $request)
    {
        $kode_cabang = $request->kode_cabang;
        $nama_cabang = $request->nama_cabang;
        $alamat_cabang = $request->alamat_cabang;
        $latitude = $request->latitude;
        $longitude = $request->longitude;
        $radius = $request->radius;

        $data = [
            'kode_cabang' => $kode_cabang,
            'nama_cabang' => $nama_cabang,
            'alamat_cabang' => $alamat_cabang,
            'latitude' => $latitude,
            'longitude' => $longitude,
            'radius' => $radius
        ];

        $simpan = DB::table('kantorcabang')->insert($data);
        if ($simpan) {
            return redirect('/panel/cabang')->with(['success' => 'Kantor Cabang Berhasil Ditambahkan']);
        } else {
            return redirect('/panel/cabang')->with(['error' => 'Data Gagal Ditambahkan']);
        }
    }

    public function edit(Request $request)
    {
        $id = $request->id;
        $kantorcabang = DB::table('kantorcabang')->where('id', $id)->first();
        return view('cabang.edit', compact('kantorcabang'));
    }

    public function update($id, Request $request)
    {
        $kode_cabang = $request->kode_cabang;
        $nama_cabang = $request->nama_cabang;
        $alamat_cabang = $request->alamat_cabang;
        $latitude = $request->latitude;
        $longitude = $request->longitude;
        $radius = $request->radius;

        $data = [
            'kode_cabang' => $kode_cabang,
            'nama_cabang' => $nama_cabang,
            'alamat_cabang' => $alamat_cabang,
            'latitude' => $latitude,
            'longitude' => $longitude,
            'radius' => $radius
        ];

        $update = DB::table('kantorcabang')->where('id', $id)->update($data);
        if ($update) {
            return redirect('/panel/cabang')->with(['success' => 'Kantor Cabang Berhasil Di Update']);
        } else {
            return redirect('/panel/cabang')->with(['error' => 'Update Data Gagal']);
        }
    }

    public function delete($id)
    {
        $delete = DB::table('kantorcabang')->where('id', $id)->delete();
        if ($delete) {
            return Redirect::back()->with(['success' => 'Data Kantor Berhasil Di Hapus']);
        } else {
            return Redirect::back()->with(['error' => 'Data Gagal Di Hapus']);
        }
    }
}
